@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dms.EventSubscription("example", {
 *     enabled: true,
 *     eventCategories: [
 *         "creation",
 *         "failure",
 *     ],
 *     name: "my-favorite-event-subscription",
 *     snsTopicArn: exampleAwsSnsTopic.arn,
 *     sourceIds: [exampleAwsDmsReplicationTask&#46;replicationTaskId],
 *     sourceType: "replication-task",
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dms.EventSubscription("example",
 *     enabled=True,
 *     event_categories=[
 *         "creation",
 *         "failure",
 *     ],
 *     name="my-favorite-event-subscription",
 *     sns_topic_arn=example_aws_sns_topic["arn"],
 *     source_ids=[example_aws_dms_replication_task["replicationTaskId"]],
 *     source_type="replication-task",
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dms.EventSubscription("example", new()
 *     {
 *         Enabled = true,
 *         EventCategories = new[]
 *         {
 *             "creation",
 *             "failure",
 *         },
 *         Name = "my-favorite-event-subscription",
 *         SnsTopicArn = exampleAwsSnsTopic.Arn,
 *         SourceIds = new[]
 *         {
 *             exampleAwsDmsReplicationTask.ReplicationTaskId,
 *         },
 *         SourceType = "replication-task",
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewEventSubscription(ctx, "example", &dms.EventSubscriptionArgs{
 * 			Enabled: pulumi.Bool(true),
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("creation"),
 * 				pulumi.String("failure"),
 * 			},
 * 			Name:        pulumi.String("my-favorite-event-subscription"),
 * 			SnsTopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			SourceIds: pulumi.StringArray{
 * 				exampleAwsDmsReplicationTask.ReplicationTaskId,
 * 			},
 * 			SourceType: pulumi.String("replication-task"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.EventSubscription;
 * import com.pulumi.aws.dms.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSubscription("example", EventSubscriptionArgs.builder()
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .name("my-favorite-event-subscription")
 *             .snsTopicArn(exampleAwsSnsTopic.arn())
 *             .sourceIds(exampleAwsDmsReplicationTask.replicationTaskId())
 *             .sourceType("replication-task")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dms:EventSubscription
 *     properties:
 *       enabled: true
 *       eventCategories:
 *         - creation
 *         - failure
 *       name: my-favorite-event-subscription
 *       snsTopicArn: ${exampleAwsSnsTopic.arn}
 *       sourceIds:
 *         - ${exampleAwsDmsReplicationTask.replicationTaskId}
 *       sourceType: replication-task
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import event subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:dms/eventSubscription:EventSubscription test my-awesome-event-subscription
 * ```
 * @property enabled Whether the event subscription should be enabled.
 * @property eventCategories List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
 * @property name Name of event subscription.
 * @property snsTopicArn SNS topic arn to send events on.
 * @property sourceIds Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
 * @property sourceType Type of source for events. Valid values: `replication-instance` or `replication-task`
 * @property tags Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.dms.EventSubscriptionArgs =
        com.pulumi.aws.dms.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether the event subscription should be enabled.
     */
    @JvmName("hqousnxmsohxbput")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("oebqbjwmedjqokjw")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("hccwdogeexsqufwa")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("ylwxrswuusnncuct")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value Name of event subscription.
     */
    @JvmName("hikfmoqhvkmmcpee")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SNS topic arn to send events on.
     */
    @JvmName("velqdfhekrppknkg")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
     */
    @JvmName("dfkhumclrxoxngvc")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("mljqokbqhvhyjofq")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
     */
    @JvmName("qmvwvjhtqqokonvn")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value Type of source for events. Valid values: `replication-instance` or `replication-task`
     */
    @JvmName("uaroxmkclnaknbuk")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eemwkamrgdvnbaqv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether the event subscription should be enabled.
     */
    @JvmName("hrjkntdssjtajsqp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("trmlnqddftslmycy")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("jmmbjxiuvxewawyu")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value Name of event subscription.
     */
    @JvmName("abaakrvotwbavcyq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SNS topic arn to send events on.
     */
    @JvmName("esjohagclkqcpaiu")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
     */
    @JvmName("maijowwfpuogjlwt")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
     */
    @JvmName("yjhmgieylsfmcods")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value Type of source for events. Valid values: `replication-instance` or `replication-task`
     */
    @JvmName("klujptmnbjgtkrnj")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("buctvkrwnfosocwh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmdgbhkkowmlnkwu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
