@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.kotlin.outputs.ReplicationConfigComputeConfig
import com.pulumi.aws.dms.kotlin.outputs.ReplicationConfigComputeConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReplicationConfig].
 */
@PulumiTagMarker
public class ReplicationConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationConfigArgs = ReplicationConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationConfigArgsBuilder.() -> Unit) {
        val builder = ReplicationConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationConfig {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationConfig(builtJavaResource)
    }
}

/**
 * Provides a DMS Serverless replication config resource.
 * > **NOTE:** Changing most arguments will stop the replication if it is running. You can set `start_replication` to resume the replication afterwards.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const name = new aws.dms.ReplicationConfig("name", {
 *     replicationConfigIdentifier: "test-dms-serverless-replication-tf",
 *     resourceIdentifier: "test-dms-serverless-replication-tf",
 *     replicationType: "cdc",
 *     sourceEndpointArn: source.endpointArn,
 *     targetEndpointArn: target.endpointArn,
 *     tableMappings: `  {
 *     "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
 *   }
 * `,
 *     startReplication: true,
 *     computeConfig: {
 *         replicationSubnetGroupId: _default.replicationSubnetGroupId,
 *         maxCapacityUnits: 64,
 *         minCapacityUnits: 2,
 *         preferredMaintenanceWindow: "sun:23:45-mon:00:30",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * name = aws.dms.ReplicationConfig("name",
 *     replication_config_identifier="test-dms-serverless-replication-tf",
 *     resource_identifier="test-dms-serverless-replication-tf",
 *     replication_type="cdc",
 *     source_endpoint_arn=source["endpointArn"],
 *     target_endpoint_arn=target["endpointArn"],
 *     table_mappings="""  {
 *     "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
 *   }
 * """,
 *     start_replication=True,
 *     compute_config={
 *         "replication_subnet_group_id": default["replicationSubnetGroupId"],
 *         "max_capacity_units": 64,
 *         "min_capacity_units": 2,
 *         "preferred_maintenance_window": "sun:23:45-mon:00:30",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var name = new Aws.Dms.ReplicationConfig("name", new()
 *     {
 *         ReplicationConfigIdentifier = "test-dms-serverless-replication-tf",
 *         ResourceIdentifier = "test-dms-serverless-replication-tf",
 *         ReplicationType = "cdc",
 *         SourceEndpointArn = source.EndpointArn,
 *         TargetEndpointArn = target.EndpointArn,
 *         TableMappings = @"  {
 *     ""rules"":[{""rule-type"":""selection"",""rule-id"":""1"",""rule-name"":""1"",""rule-action"":""include"",""object-locator"":{""schema-name"":""%%"",""table-name"":""%%""}}]
 *   }
 * ",
 *         StartReplication = true,
 *         ComputeConfig = new Aws.Dms.Inputs.ReplicationConfigComputeConfigArgs
 *         {
 *             ReplicationSubnetGroupId = @default.ReplicationSubnetGroupId,
 *             MaxCapacityUnits = 64,
 *             MinCapacityUnits = 2,
 *             PreferredMaintenanceWindow = "sun:23:45-mon:00:30",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewReplicationConfig(ctx, "name", &dms.ReplicationConfigArgs{
 * 			ReplicationConfigIdentifier: pulumi.String("test-dms-serverless-replication-tf"),
 * 			ResourceIdentifier:          pulumi.String("test-dms-serverless-replication-tf"),
 * 			ReplicationType:             pulumi.String("cdc"),
 * 			SourceEndpointArn:           pulumi.Any(source.EndpointArn),
 * 			TargetEndpointArn:           pulumi.Any(target.EndpointArn),
 * 			TableMappings:               pulumi.String("  {\n    \"rules\":[{\"rule-type\":\"selection\",\"rule-id\":\"1\",\"rule-name\":\"1\",\"rule-action\":\"include\",\"object-locator\":{\"schema-name\":\"%%\",\"table-name\":\"%%\"}}]\n  }\n"),
 * 			StartReplication:            pulumi.Bool(true),
 * 			ComputeConfig: &dms.ReplicationConfigComputeConfigArgs{
 * 				ReplicationSubnetGroupId:   pulumi.Any(_default.ReplicationSubnetGroupId),
 * 				MaxCapacityUnits:           pulumi.Int(64),
 * 				MinCapacityUnits:           pulumi.Int(2),
 * 				PreferredMaintenanceWindow: pulumi.String("sun:23:45-mon:00:30"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationConfig;
 * import com.pulumi.aws.dms.ReplicationConfigArgs;
 * import com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var name = new ReplicationConfig("name", ReplicationConfigArgs.builder()
 *             .replicationConfigIdentifier("test-dms-serverless-replication-tf")
 *             .resourceIdentifier("test-dms-serverless-replication-tf")
 *             .replicationType("cdc")
 *             .sourceEndpointArn(source.endpointArn())
 *             .targetEndpointArn(target.endpointArn())
 *             .tableMappings("""
 *   {
 *     "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
 *   }
 *             """)
 *             .startReplication(true)
 *             .computeConfig(ReplicationConfigComputeConfigArgs.builder()
 *                 .replicationSubnetGroupId(default_.replicationSubnetGroupId())
 *                 .maxCapacityUnits("64")
 *                 .minCapacityUnits("2")
 *                 .preferredMaintenanceWindow("sun:23:45-mon:00:30")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   name:
 *     type: aws:dms:ReplicationConfig
 *     properties:
 *       replicationConfigIdentifier: test-dms-serverless-replication-tf
 *       resourceIdentifier: test-dms-serverless-replication-tf
 *       replicationType: cdc
 *       sourceEndpointArn: ${source.endpointArn}
 *       targetEndpointArn: ${target.endpointArn}
 *       tableMappings: |2
 *           {
 *             "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
 *           }
 *       startReplication: true
 *       computeConfig:
 *         replicationSubnetGroupId: ${default.replicationSubnetGroupId}
 *         maxCapacityUnits: '64'
 *         minCapacityUnits: '2'
 *         preferredMaintenanceWindow: sun:23:45-mon:00:30
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a replication config using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:dms/replicationConfig:ReplicationConfig example arn:aws:dms:us-east-1:123456789012:replication-config:UX6OL6MHMMJKFFOXE3H7LLJCMEKBDUG4ZV7DRSI
 * ```
 */
public class ReplicationConfig internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationConfig,
) : KotlinCustomResource(javaResource, ReplicationConfigMapper) {
    /**
     * The Amazon Resource Name (ARN) for the serverless replication config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for provisioning an DMS Serverless replication.
     */
    public val computeConfig: Output<ReplicationConfigComputeConfig>
        get() = javaResource.computeConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Unique identifier that you want to use to create the config.
     */
    public val replicationConfigIdentifier: Output<String>
        get() = javaResource.replicationConfigIdentifier().applyValue({ args0 -> args0 })

    /**
     * An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
     */
    public val replicationSettings: Output<String>
        get() = javaResource.replicationSettings().applyValue({ args0 -> args0 })

    /**
     * The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    public val replicationType: Output<String>
        get() = javaResource.replicationType().applyValue({ args0 -> args0 })

    /**
     * Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
     */
    public val resourceIdentifier: Output<String>
        get() = javaResource.resourceIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    public val sourceEndpointArn: Output<String>
        get() = javaResource.sourceEndpointArn().applyValue({ args0 -> args0 })

    /**
     * Whether to run or stop the serverless replication, default is false.
     */
    public val startReplication: Output<Boolean>?
        get() = javaResource.startReplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
     */
    public val supplementalSettings: Output<String>?
        get() = javaResource.supplementalSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    public val tableMappings: Output<String>
        get() = javaResource.tableMappings().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    public val targetEndpointArn: Output<String>
        get() = javaResource.targetEndpointArn().applyValue({ args0 -> args0 })
}

public object ReplicationConfigMapper : ResourceMapper<ReplicationConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationConfig::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationConfig = ReplicationConfig(
        javaResource as
            com.pulumi.aws.dms.ReplicationConfig,
    )
}

/**
 * @see [ReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationConfig].
 */
public suspend fun replicationConfig(
    name: String,
    block: suspend ReplicationConfigResourceBuilder.() -> Unit,
): ReplicationConfig {
    val builder = ReplicationConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationConfig(name: String): ReplicationConfig {
    val builder = ReplicationConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
