@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationInstance].
 */
@PulumiTagMarker
public class ReplicationInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationInstanceArgs = ReplicationInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationInstanceArgsBuilder.() -> Unit) {
        val builder = ReplicationInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationInstance {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationInstance(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) replication instance resource. DMS replication instances can be created, updated, deleted, and imported.
 * ## Example Usage
 * Create required roles and then create a DMS instance, setting the depends_on to the required role policy attachments.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Database Migration Service requires the below IAM Roles to be created before
 * // replication instances can be created. See the DMS Documentation for
 * // additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 * //  * dms-vpc-role
 * //  * dms-cloudwatch-logs-role
 * //  * dms-access-for-endpoint
 * const dmsAssumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             identifiers: ["dms&#46;amazonaws&#46;com"],
 *             type: "Service",
 *         }],
 *     }],
 * });
 * const dms_access_for_endpoint = new aws.iam.Role("dms-access-for-endpoint", {
 *     assumeRolePolicy: dmsAssumeRole.then(dmsAssumeRole => dmsAssumeRole.json),
 *     name: "dms-access-for-endpoint",
 * });
 * const dms_access_for_endpoint_AmazonDMSRedshiftS3Role = new aws.iam.RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role",
 *     role: dms_access_for_endpoint.name,
 * });
 * const dms_cloudwatch_logs_role = new aws.iam.Role("dms-cloudwatch-logs-role", {
 *     assumeRolePolicy: dmsAssumeRole.then(dmsAssumeRole => dmsAssumeRole.json),
 *     name: "dms-cloudwatch-logs-role",
 * });
 * const dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole = new aws.iam.RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole",
 *     role: dms_cloudwatch_logs_role.name,
 * });
 * const dms_vpc_role = new aws.iam.Role("dms-vpc-role", {
 *     assumeRolePolicy: dmsAssumeRole.then(dmsAssumeRole => dmsAssumeRole.json),
 *     name: "dms-vpc-role",
 * });
 * const dms_vpc_role_AmazonDMSVPCManagementRole = new aws.iam.RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 *     role: dms_vpc_role.name,
 * });
 * // Create a new replication instance
 * const test = new aws.dms.ReplicationInstance("test", {
 *     allocatedStorage: 20,
 *     applyImmediately: true,
 *     autoMinorVersionUpgrade: true,
 *     availabilityZone: "us-west-2c",
 *     engineVersion: "3.1.4",
 *     kmsKeyArn: "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     multiAz: false,
 *     preferredMaintenanceWindow: "sun:10:30-sun:14:30",
 *     publiclyAccessible: true,
 *     replicationInstanceClass: "dms.t2.micro",
 *     replicationInstanceId: "test-dms-replication-instance-tf",
 *     replicationSubnetGroupId: test_dms_replication_subnet_group_tf.id,
 *     tags: {
 *         Name: "test",
 *     },
 *     vpcSecurityGroupIds: ["sg-12345678"],
 * }, {
 *     dependsOn: [
 *         dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 *         dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 *         dms_vpc_role_AmazonDMSVPCManagementRole,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Database Migration Service requires the below IAM Roles to be created before
 * # replication instances can be created. See the DMS Documentation for
 * # additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 * #  * dms-vpc-role
 * #  * dms-cloudwatch-logs-role
 * #  * dms-access-for-endpoint
 * dms_assume_role = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "identifiers": ["dms&#46;amazonaws&#46;com"],
 *         "type": "Service",
 *     }],
 * }])
 * dms_access_for_endpoint = aws.iam.Role("dms-access-for-endpoint",
 *     assume_role_policy=dms_assume_role.json,
 *     name="dms-access-for-endpoint")
 * dms_access_for_endpoint__amazon_dms_redshift_s3_role = aws.iam.RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role",
 *     role=dms_access_for_endpoint.name)
 * dms_cloudwatch_logs_role = aws.iam.Role("dms-cloudwatch-logs-role",
 *     assume_role_policy=dms_assume_role.json,
 *     name="dms-cloudwatch-logs-role")
 * dms_cloudwatch_logs_role__amazon_dms_cloud_watch_logs_role = aws.iam.RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole",
 *     role=dms_cloudwatch_logs_role.name)
 * dms_vpc_role = aws.iam.Role("dms-vpc-role",
 *     assume_role_policy=dms_assume_role.json,
 *     name="dms-vpc-role")
 * dms_vpc_role__amazon_dmsvpc_management_role = aws.iam.RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 *     role=dms_vpc_role.name)
 * # Create a new replication instance
 * test = aws.dms.ReplicationInstance("test",
 *     allocated_storage=20,
 *     apply_immediately=True,
 *     auto_minor_version_upgrade=True,
 *     availability_zone="us-west-2c",
 *     engine_version="3.1.4",
 *     kms_key_arn="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     multi_az=False,
 *     preferred_maintenance_window="sun:10:30-sun:14:30",
 *     publicly_accessible=True,
 *     replication_instance_class="dms.t2.micro",
 *     replication_instance_id="test-dms-replication-instance-tf",
 *     replication_subnet_group_id=test_dms_replication_subnet_group_tf["id"],
 *     tags={
 *         "Name": "test",
 *     },
 *     vpc_security_group_ids=["sg-12345678"],
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             dms_access_for_endpoint__amazon_dms_redshift_s3_role,
 *             dms_cloudwatch_logs_role__amazon_dms_cloud_watch_logs_role,
 *             dms_vpc_role__amazon_dmsvpc_management_role,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Database Migration Service requires the below IAM Roles to be created before
 *     // replication instances can be created. See the DMS Documentation for
 *     // additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 *     //  * dms-vpc-role
 *     //  * dms-cloudwatch-logs-role
 *     //  * dms-access-for-endpoint
 *     var dmsAssumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Identifiers = new[]
 *                         {
 *                             "dms.amazonaws.com",
 *                         },
 *                         Type = "Service",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var dms_access_for_endpoint = new Aws.Iam.Role("dms-access-for-endpoint", new()
 *     {
 *         AssumeRolePolicy = dmsAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Name = "dms-access-for-endpoint",
 *     });
 *     var dms_access_for_endpoint_AmazonDMSRedshiftS3Role = new Aws.Iam.RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role",
 *         Role = dms_access_for_endpoint.Name,
 *     });
 *     var dms_cloudwatch_logs_role = new Aws.Iam.Role("dms-cloudwatch-logs-role", new()
 *     {
 *         AssumeRolePolicy = dmsAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Name = "dms-cloudwatch-logs-role",
 *     });
 *     var dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole = new Aws.Iam.RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole",
 *         Role = dms_cloudwatch_logs_role.Name,
 *     });
 *     var dms_vpc_role = new Aws.Iam.Role("dms-vpc-role", new()
 *     {
 *         AssumeRolePolicy = dmsAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Name = "dms-vpc-role",
 *     });
 *     var dms_vpc_role_AmazonDMSVPCManagementRole = new Aws.Iam.RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 *         Role = dms_vpc_role.Name,
 *     });
 *     // Create a new replication instance
 *     var test = new Aws.Dms.ReplicationInstance("test", new()
 *     {
 *         AllocatedStorage = 20,
 *         ApplyImmediately = true,
 *         AutoMinorVersionUpgrade = true,
 *         AvailabilityZone = "us-west-2c",
 *         EngineVersion = "3.1.4",
 *         KmsKeyArn = "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *         MultiAz = false,
 *         PreferredMaintenanceWindow = "sun:10:30-sun:14:30",
 *         PubliclyAccessible = true,
 *         ReplicationInstanceClass = "dms.t2.micro",
 *         ReplicationInstanceId = "test-dms-replication-instance-tf",
 *         ReplicationSubnetGroupId = test_dms_replication_subnet_group_tf.Id,
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *         VpcSecurityGroupIds = new[]
 *         {
 *             "sg-12345678",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 *             dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 *             dms_vpc_role_AmazonDMSVPCManagementRole,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Database Migration Service requires the below IAM Roles to be created before
 * 		// replication instances can be created. See the DMS Documentation for
 * 		// additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 * 		//   - dms-vpc-role
 * 		//   - dms-cloudwatch-logs-role
 * 		//   - dms-access-for-endpoint
 * 		dmsAssumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Identifiers: []string{
 * 								"dms.amazonaws.com",
 * 							},
 * 							Type: "Service",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRole(ctx, "dms-access-for-endpoint", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(dmsAssumeRole.Json),
 * 			Name:             pulumi.String("dms-access-for-endpoint"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "dms-access-for-endpoint-AmazonDMSRedshiftS3Role", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role"),
 * 			Role:      dms_access_for_endpoint.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRole(ctx, "dms-cloudwatch-logs-role", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(dmsAssumeRole.Json),
 * 			Name:             pulumi.String("dms-cloudwatch-logs-role"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole"),
 * 			Role:      dms_cloudwatch_logs_role.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRole(ctx, "dms-vpc-role", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(dmsAssumeRole.Json),
 * 			Name:             pulumi.String("dms-vpc-role"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "dms-vpc-role-AmazonDMSVPCManagementRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole"),
 * 			Role:      dms_vpc_role.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Create a new replication instance
 * 		_, err = dms.NewReplicationInstance(ctx, "test", &dms.ReplicationInstanceArgs{
 * 			AllocatedStorage:           pulumi.Int(20),
 * 			ApplyImmediately:           pulumi.Bool(true),
 * 			AutoMinorVersionUpgrade:    pulumi.Bool(true),
 * 			AvailabilityZone:           pulumi.String("us-west-2c"),
 * 			EngineVersion:              pulumi.String("3.1.4"),
 * 			KmsKeyArn:                  pulumi.String("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"),
 * 			MultiAz:                    pulumi.Bool(false),
 * 			PreferredMaintenanceWindow: pulumi.String("sun:10:30-sun:14:30"),
 * 			PubliclyAccessible:         pulumi.Bool(true),
 * 			ReplicationInstanceClass:   pulumi.String("dms.t2.micro"),
 * 			ReplicationInstanceId:      pulumi.String("test-dms-replication-instance-tf"),
 * 			ReplicationSubnetGroupId:   pulumi.Any(test_dms_replication_subnet_group_tf.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 			VpcSecurityGroupIds: pulumi.StringArray{
 * 				pulumi.String("sg-12345678"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 * 			dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 * 			dms_vpc_role_AmazonDMSVPCManagementRole,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationInstance;
 * import com.pulumi.aws.dms.ReplicationInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Database Migration Service requires the below IAM Roles to be created before
 *         // replication instances can be created. See the DMS Documentation for
 *         // additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 *         //  * dms-vpc-role
 *         //  * dms-cloudwatch-logs-role
 *         //  * dms-access-for-endpoint
 *         final var dmsAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("dms.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var dms_access_for_endpoint = new Role("dms-access-for-endpoint", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .name("dms-access-for-endpoint")
 *             .build());
 *         var dms_access_for_endpoint_AmazonDMSRedshiftS3Role = new RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role")
 *             .role(dms_access_for_endpoint.name())
 *             .build());
 *         var dms_cloudwatch_logs_role = new Role("dms-cloudwatch-logs-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .name("dms-cloudwatch-logs-role")
 *             .build());
 *         var dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole = new RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole")
 *             .role(dms_cloudwatch_logs_role.name())
 *             .build());
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .name("dms-vpc-role")
 *             .build());
 *         var dms_vpc_role_AmazonDMSVPCManagementRole = new RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .role(dms_vpc_role.name())
 *             .build());
 *         // Create a new replication instance
 *         var test = new ReplicationInstance("test", ReplicationInstanceArgs.builder()
 *             .allocatedStorage(20)
 *             .applyImmediately(true)
 *             .autoMinorVersionUpgrade(true)
 *             .availabilityZone("us-west-2c")
 *             .engineVersion("3.1.4")
 *             .kmsKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .multiAz(false)
 *             .preferredMaintenanceWindow("sun:10:30-sun:14:30")
 *             .publiclyAccessible(true)
 *             .replicationInstanceClass("dms.t2.micro")
 *             .replicationInstanceId("test-dms-replication-instance-tf")
 *             .replicationSubnetGroupId(test_dms_replication_subnet_group_tf.id())
 *             .tags(Map.of("Name", "test"))
 *             .vpcSecurityGroupIds("sg-12345678")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 *                     dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 *                     dms_vpc_role_AmazonDMSVPCManagementRole)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dms-access-for-endpoint:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${dmsAssumeRole.json}
 *       name: dms-access-for-endpoint
 *   dms-access-for-endpoint-AmazonDMSRedshiftS3Role:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role
 *       role: ${["dms-access-for-endpoint"].name}
 *   dms-cloudwatch-logs-role:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${dmsAssumeRole.json}
 *       name: dms-cloudwatch-logs-role
 *   dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole
 *       role: ${["dms-cloudwatch-logs-role"].name}
 *   dms-vpc-role:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${dmsAssumeRole.json}
 *       name: dms-vpc-role
 *   dms-vpc-role-AmazonDMSVPCManagementRole:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole
 *       role: ${["dms-vpc-role"].name}
 *   # Create a new replication instance
 *   test:
 *     type: aws:dms:ReplicationInstance
 *     properties:
 *       allocatedStorage: 20
 *       applyImmediately: true
 *       autoMinorVersionUpgrade: true
 *       availabilityZone: us-west-2c
 *       engineVersion: 3.1.4
 *       kmsKeyArn: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
 *       multiAz: false
 *       preferredMaintenanceWindow: sun:10:30-sun:14:30
 *       publiclyAccessible: true
 *       replicationInstanceClass: dms.t2.micro
 *       replicationInstanceId: test-dms-replication-instance-tf
 *       replicationSubnetGroupId: ${["test-dms-replication-subnet-group-tf"].id}
 *       tags:
 *         Name: test
 *       vpcSecurityGroupIds:
 *         - sg-12345678
 *     options:
 *       dependson:
 *         - ${["dms-access-for-endpoint-AmazonDMSRedshiftS3Role"]}
 *         - ${["dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole"]}
 *         - ${["dms-vpc-role-AmazonDMSVPCManagementRole"]}
 * variables:
 *   # Database Migration Service requires the below IAM Roles to be created before
 *   # replication instances can be created. See the DMS Documentation for
 *   # additional information: https://docs.aws.amazon.com/dms/latest/userguide/security-iam.html#CHAP_Security.APIRole
 *   #  * dms-vpc-role
 *   #  * dms-cloudwatch-logs-role
 *   #  * dms-access-for-endpoint
 *   dmsAssumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - identifiers:
 *                   - dms.amazonaws.com
 *                 type: Service
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import replication instances using the `replication_instance_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/replicationInstance:ReplicationInstance test test-dms-replication-instance-tf
 * ```
 */
public class ReplicationInstance internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationInstance,
) : KotlinCustomResource(javaResource, ReplicationInstanceMapper) {
    /**
     * The amount of storage (in gigabytes) to be initially allocated for the replication instance.
     */
    public val allocatedStorage: Output<Int>
        get() = javaResource.allocatedStorage().applyValue({ args0 -> args0 })

    /**
     * Indicates that major version upgrades are allowed.
     */
    public val allowMajorVersionUpgrade: Output<Boolean>?
        get() = javaResource.allowMajorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the changes should be applied immediately or during the next maintenance window. Only used when updating an existing resource.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 -> args0 })

    /**
     * The EC2 Availability Zone that the replication instance will be created in.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The engine version number of the replication instance.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    /**
     * The type of IP address protocol used by a replication instance. Valid values: `IPV4`, `DUAL`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
     */
    public val publiclyAccessible: Output<Boolean>
        get() = javaResource.publiclyAccessible().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the replication instance.
     */
    public val replicationInstanceArn: Output<String>
        get() = javaResource.replicationInstanceArn().applyValue({ args0 -> args0 })

    /**
     * The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for available instance sizes and advice on which one to choose.
     */
    public val replicationInstanceClass: Output<String>
        get() = javaResource.replicationInstanceClass().applyValue({ args0 -> args0 })

    /**
     * The replication instance identifier. This parameter is stored as a lowercase string.
     * - Must contain from 1 to 63 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen
     * - Cannot contain two consecutive hyphens.
     */
    public val replicationInstanceId: Output<String>
        get() = javaResource.replicationInstanceId().applyValue({ args0 -> args0 })

    /**
     * A list of the private IP addresses of the replication instance.
     */
    public val replicationInstancePrivateIps: Output<List<String>>
        get() = javaResource.replicationInstancePrivateIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A list of the public IP addresses of the replication instance.
     */
    public val replicationInstancePublicIps: Output<List<String>>
        get() = javaResource.replicationInstancePublicIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A subnet group to associate with the replication instance.
     */
    public val replicationSubnetGroupId: Output<String>
        get() = javaResource.replicationSubnetGroupId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ReplicationInstanceMapper : ResourceMapper<ReplicationInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationInstance::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationInstance = ReplicationInstance(
        javaResource
            as com.pulumi.aws.dms.ReplicationInstance,
    )
}

/**
 * @see [ReplicationInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationInstance].
 */
public suspend fun replicationInstance(
    name: String,
    block: suspend ReplicationInstanceResourceBuilder.() -> Unit,
): ReplicationInstance {
    val builder = ReplicationInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationInstance(name: String): ReplicationInstance {
    val builder = ReplicationInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
