@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationSubnetGroup].
 */
@PulumiTagMarker
public class ReplicationSubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationSubnetGroupArgs = ReplicationSubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationSubnetGroupArgsBuilder.() -> Unit) {
        val builder = ReplicationSubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationSubnetGroup {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationSubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationSubnetGroup(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) replication subnet group resource. DMS replication subnet groups can be created, updated, deleted, and imported.
 * > **Note:** AWS requires a special IAM role called `dms-vpc-role` when using this resource. See the example below to create it as part of your configuration.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new replication subnet group
 * const example = new aws.dms.ReplicationSubnetGroup("example", {
 *     replicationSubnetGroupDescription: "Example replication subnet group",
 *     replicationSubnetGroupId: "example-dms-replication-subnet-group-tf",
 *     subnetIds: [
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new replication subnet group
 * example = aws.dms.ReplicationSubnetGroup("example",
 *     replication_subnet_group_description="Example replication subnet group",
 *     replication_subnet_group_id="example-dms-replication-subnet-group-tf",
 *     subnet_ids=[
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new replication subnet group
 *     var example = new Aws.Dms.ReplicationSubnetGroup("example", new()
 *     {
 *         ReplicationSubnetGroupDescription = "Example replication subnet group",
 *         ReplicationSubnetGroupId = "example-dms-replication-subnet-group-tf",
 *         SubnetIds = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-12345679",
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new replication subnet group
 * 		_, err := dms.NewReplicationSubnetGroup(ctx, "example", &dms.ReplicationSubnetGroupArgs{
 * 			ReplicationSubnetGroupDescription: pulumi.String("Example replication subnet group"),
 * 			ReplicationSubnetGroupId:          pulumi.String("example-dms-replication-subnet-group-tf"),
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-12345679"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new replication subnet group
 *         var example = new ReplicationSubnetGroup("example", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example replication subnet group")
 *             .replicationSubnetGroupId("example-dms-replication-subnet-group-tf")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new replication subnet group
 *   example:
 *     type: aws:dms:ReplicationSubnetGroup
 *     properties:
 *       replicationSubnetGroupDescription: Example replication subnet group
 *       replicationSubnetGroupId: example-dms-replication-subnet-group-tf
 *       subnetIds:
 *         - subnet-12345678
 *         - subnet-12345679
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Creating special IAM role
 * If your account does not already include the `dms-vpc-role` IAM role, you will need to create it to allow DMS to manage subnets in the VPC.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dms_vpc_role = new aws.iam.Role("dms-vpc-role", {
 *     name: "dms-vpc-role",
 *     description: "Allows DMS to manage VPC",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "dms.amazonaws.com",
 *             },
 *             Action: "sts:AssumeRole",
 *         }],
 *     }),
 * });
 * const example = new aws.iam.RolePolicyAttachment("example", {
 *     role: dms_vpc_role.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 * });
 * const exampleReplicationSubnetGroup = new aws.dms.ReplicationSubnetGroup("example", {
 *     replicationSubnetGroupDescription: "Example",
 *     replicationSubnetGroupId: "example-id",
 *     subnetIds: [
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags: {
 *         Name: "example-id",
 *     },
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * dms_vpc_role = aws.iam.Role("dms-vpc-role",
 *     name="dms-vpc-role",
 *     description="Allows DMS to manage VPC",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "dms.amazonaws.com",
 *             },
 *             "Action": "sts:AssumeRole",
 *         }],
 *     }))
 * example = aws.iam.RolePolicyAttachment("example",
 *     role=dms_vpc_role.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 * example_replication_subnet_group = aws.dms.ReplicationSubnetGroup("example",
 *     replication_subnet_group_description="Example",
 *     replication_subnet_group_id="example-id",
 *     subnet_ids=[
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags={
 *         "Name": "example-id",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dms_vpc_role = new Aws.Iam.Role("dms-vpc-role", new()
 *     {
 *         Name = "dms-vpc-role",
 *         Description = "Allows DMS to manage VPC",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "dms.amazonaws.com",
 *                     },
 *                     ["Action"] = "sts:AssumeRole",
 *                 },
 *             },
 *         }),
 *     });
 *     var example = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = dms_vpc_role.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 *     });
 *     var exampleReplicationSubnetGroup = new Aws.Dms.ReplicationSubnetGroup("example", new()
 *     {
 *         ReplicationSubnetGroupDescription = "Example",
 *         ReplicationSubnetGroupId = "example-id",
 *         SubnetIds = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-12345679",
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-id" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "dms.amazonaws.com",
 * 					},
 * 					"Action": "sts:AssumeRole",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewRole(ctx, "dms-vpc-role", &iam.RoleArgs{
 * 			Name:             pulumi.String("dms-vpc-role"),
 * 			Description:      pulumi.String("Allows DMS to manage VPC"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      dms_vpc_role.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewReplicationSubnetGroup(ctx, "example", &dms.ReplicationSubnetGroupArgs{
 * 			ReplicationSubnetGroupDescription: pulumi.String("Example"),
 * 			ReplicationSubnetGroupId:          pulumi.String("example-id"),
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-12345679"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-id"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .name("dms-vpc-role")
 *             .description("Allows DMS to manage VPC")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "dms.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var example = new RolePolicyAttachment("example", RolePolicyAttachmentArgs.builder()
 *             .role(dms_vpc_role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .build());
 *         var exampleReplicationSubnetGroup = new ReplicationSubnetGroup("exampleReplicationSubnetGroup", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example")
 *             .replicationSubnetGroupId("example-id")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example-id"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dms-vpc-role:
 *     type: aws:iam:Role
 *     properties:
 *       name: dms-vpc-role
 *       description: Allows DMS to manage VPC
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Principal:
 *                 Service: dms.amazonaws.com
 *               Action: sts:AssumeRole
 *   example:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${["dms-vpc-role"].name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole
 *   exampleReplicationSubnetGroup:
 *     type: aws:dms:ReplicationSubnetGroup
 *     name: example
 *     properties:
 *       replicationSubnetGroupDescription: Example
 *       replicationSubnetGroupId: example-id
 *       subnetIds:
 *         - subnet-12345678
 *         - subnet-12345679
 *       tags:
 *         Name: example-id
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import replication subnet groups using the `replication_subnet_group_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/replicationSubnetGroup:ReplicationSubnetGroup test test-dms-replication-subnet-group-tf
 * ```
 */
public class ReplicationSubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationSubnetGroup,
) : KotlinCustomResource(javaResource, ReplicationSubnetGroupMapper) {
    public val replicationSubnetGroupArn: Output<String>
        get() = javaResource.replicationSubnetGroupArn().applyValue({ args0 -> args0 })

    /**
     * Description for the subnet group.
     */
    public val replicationSubnetGroupDescription: Output<String>
        get() = javaResource.replicationSubnetGroupDescription().applyValue({ args0 -> args0 })

    /**
     * Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    public val replicationSubnetGroupId: Output<String>
        get() = javaResource.replicationSubnetGroupId().applyValue({ args0 -> args0 })

    /**
     * List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC the subnet group is in.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ReplicationSubnetGroupMapper : ResourceMapper<ReplicationSubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationSubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationSubnetGroup =
        ReplicationSubnetGroup(javaResource as com.pulumi.aws.dms.ReplicationSubnetGroup)
}

/**
 * @see [ReplicationSubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationSubnetGroup].
 */
public suspend fun replicationSubnetGroup(
    name: String,
    block: suspend ReplicationSubnetGroupResourceBuilder.() -> Unit,
): ReplicationSubnetGroup {
    val builder = ReplicationSubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationSubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationSubnetGroup(name: String): ReplicationSubnetGroup {
    val builder = ReplicationSubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
