@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.ReplicationSubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) replication subnet group resource. DMS replication subnet groups can be created, updated, deleted, and imported.
 * > **Note:** AWS requires a special IAM role called `dms-vpc-role` when using this resource. See the example below to create it as part of your configuration.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new replication subnet group
 * const example = new aws.dms.ReplicationSubnetGroup("example", {
 *     replicationSubnetGroupDescription: "Example replication subnet group",
 *     replicationSubnetGroupId: "example-dms-replication-subnet-group-tf",
 *     subnetIds: [
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new replication subnet group
 * example = aws.dms.ReplicationSubnetGroup("example",
 *     replication_subnet_group_description="Example replication subnet group",
 *     replication_subnet_group_id="example-dms-replication-subnet-group-tf",
 *     subnet_ids=[
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new replication subnet group
 *     var example = new Aws.Dms.ReplicationSubnetGroup("example", new()
 *     {
 *         ReplicationSubnetGroupDescription = "Example replication subnet group",
 *         ReplicationSubnetGroupId = "example-dms-replication-subnet-group-tf",
 *         SubnetIds = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-12345679",
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new replication subnet group
 * 		_, err := dms.NewReplicationSubnetGroup(ctx, "example", &dms.ReplicationSubnetGroupArgs{
 * 			ReplicationSubnetGroupDescription: pulumi.String("Example replication subnet group"),
 * 			ReplicationSubnetGroupId:          pulumi.String("example-dms-replication-subnet-group-tf"),
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-12345679"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new replication subnet group
 *         var example = new ReplicationSubnetGroup("example", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example replication subnet group")
 *             .replicationSubnetGroupId("example-dms-replication-subnet-group-tf")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new replication subnet group
 *   example:
 *     type: aws:dms:ReplicationSubnetGroup
 *     properties:
 *       replicationSubnetGroupDescription: Example replication subnet group
 *       replicationSubnetGroupId: example-dms-replication-subnet-group-tf
 *       subnetIds:
 *         - subnet-12345678
 *         - subnet-12345679
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Creating special IAM role
 * If your account does not already include the `dms-vpc-role` IAM role, you will need to create it to allow DMS to manage subnets in the VPC.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dms_vpc_role = new aws.iam.Role("dms-vpc-role", {
 *     name: "dms-vpc-role",
 *     description: "Allows DMS to manage VPC",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "dms.amazonaws.com",
 *             },
 *             Action: "sts:AssumeRole",
 *         }],
 *     }),
 * });
 * const example = new aws.iam.RolePolicyAttachment("example", {
 *     role: dms_vpc_role.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 * });
 * const exampleReplicationSubnetGroup = new aws.dms.ReplicationSubnetGroup("example", {
 *     replicationSubnetGroupDescription: "Example",
 *     replicationSubnetGroupId: "example-id",
 *     subnetIds: [
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags: {
 *         Name: "example-id",
 *     },
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * dms_vpc_role = aws.iam.Role("dms-vpc-role",
 *     name="dms-vpc-role",
 *     description="Allows DMS to manage VPC",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "dms.amazonaws.com",
 *             },
 *             "Action": "sts:AssumeRole",
 *         }],
 *     }))
 * example = aws.iam.RolePolicyAttachment("example",
 *     role=dms_vpc_role.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 * example_replication_subnet_group = aws.dms.ReplicationSubnetGroup("example",
 *     replication_subnet_group_description="Example",
 *     replication_subnet_group_id="example-id",
 *     subnet_ids=[
 *         "subnet-12345678",
 *         "subnet-12345679",
 *     ],
 *     tags={
 *         "Name": "example-id",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dms_vpc_role = new Aws.Iam.Role("dms-vpc-role", new()
 *     {
 *         Name = "dms-vpc-role",
 *         Description = "Allows DMS to manage VPC",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "dms.amazonaws.com",
 *                     },
 *                     ["Action"] = "sts:AssumeRole",
 *                 },
 *             },
 *         }),
 *     });
 *     var example = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = dms_vpc_role.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole",
 *     });
 *     var exampleReplicationSubnetGroup = new Aws.Dms.ReplicationSubnetGroup("example", new()
 *     {
 *         ReplicationSubnetGroupDescription = "Example",
 *         ReplicationSubnetGroupId = "example-id",
 *         SubnetIds = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-12345679",
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-id" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "dms.amazonaws.com",
 * 					},
 * 					"Action": "sts:AssumeRole",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewRole(ctx, "dms-vpc-role", &iam.RoleArgs{
 * 			Name:             pulumi.String("dms-vpc-role"),
 * 			Description:      pulumi.String("Allows DMS to manage VPC"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      dms_vpc_role.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewReplicationSubnetGroup(ctx, "example", &dms.ReplicationSubnetGroupArgs{
 * 			ReplicationSubnetGroupDescription: pulumi.String("Example"),
 * 			ReplicationSubnetGroupId:          pulumi.String("example-id"),
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-12345679"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-id"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .name("dms-vpc-role")
 *             .description("Allows DMS to manage VPC")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "dms.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var example = new RolePolicyAttachment("example", RolePolicyAttachmentArgs.builder()
 *             .role(dms_vpc_role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .build());
 *         var exampleReplicationSubnetGroup = new ReplicationSubnetGroup("exampleReplicationSubnetGroup", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example")
 *             .replicationSubnetGroupId("example-id")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example-id"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dms-vpc-role:
 *     type: aws:iam:Role
 *     properties:
 *       name: dms-vpc-role
 *       description: Allows DMS to manage VPC
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Principal:
 *                 Service: dms.amazonaws.com
 *               Action: sts:AssumeRole
 *   example:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${["dms-vpc-role"].name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole
 *   exampleReplicationSubnetGroup:
 *     type: aws:dms:ReplicationSubnetGroup
 *     name: example
 *     properties:
 *       replicationSubnetGroupDescription: Example
 *       replicationSubnetGroupId: example-id
 *       subnetIds:
 *         - subnet-12345678
 *         - subnet-12345679
 *       tags:
 *         Name: example-id
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import replication subnet groups using the `replication_subnet_group_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/replicationSubnetGroup:ReplicationSubnetGroup test test-dms-replication-subnet-group-tf
 * ```
 * @property replicationSubnetGroupDescription Description for the subnet group.
 * @property replicationSubnetGroupId Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
 * @property subnetIds List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReplicationSubnetGroupArgs(
    public val replicationSubnetGroupDescription: Output<String>? = null,
    public val replicationSubnetGroupId: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.ReplicationSubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.dms.ReplicationSubnetGroupArgs =
        com.pulumi.aws.dms.ReplicationSubnetGroupArgs.builder()
            .replicationSubnetGroupDescription(
                replicationSubnetGroupDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .replicationSubnetGroupId(replicationSubnetGroupId?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicationSubnetGroupArgs].
 */
@PulumiTagMarker
public class ReplicationSubnetGroupArgsBuilder internal constructor() {
    private var replicationSubnetGroupDescription: Output<String>? = null

    private var replicationSubnetGroupId: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("dgstlovbqegpkdjm")
    public suspend fun replicationSubnetGroupDescription(`value`: Output<String>) {
        this.replicationSubnetGroupDescription = value
    }

    /**
     * @param value Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    @JvmName("awlwxkdruamjhpbc")
    public suspend fun replicationSubnetGroupId(`value`: Output<String>) {
        this.replicationSubnetGroupId = value
    }

    /**
     * @param value List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("ngixtivngupyblcq")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ewuhyqvxoplitfuh")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("mjufjtknyoiecbho")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugddtgjrydgowsfk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("wlrhspogbmpxpdqy")
    public suspend fun replicationSubnetGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSubnetGroupDescription = mapped
    }

    /**
     * @param value Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    @JvmName("ntptbacjoupppiym")
    public suspend fun replicationSubnetGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSubnetGroupId = mapped
    }

    /**
     * @param value List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("xsnlibvjvcmacltd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("rpgbvqiavsvkvgpy")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mqjocadafqgaasjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ixyhseubbjkdmxmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicationSubnetGroupArgs = ReplicationSubnetGroupArgs(
        replicationSubnetGroupDescription = replicationSubnetGroupDescription,
        replicationSubnetGroupId = replicationSubnetGroupId,
        subnetIds = subnetIds,
        tags = tags,
    )
}
