@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.S3EndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) S3 endpoint resource. DMS S3 endpoints can be created, updated, deleted, and imported.
 * > **Note:** AWS is deprecating `extra_connection_attributes`, such as used with `aws.dms.Endpoint`. This resource is an alternative to `aws.dms.Endpoint` and does not use `extra_connection_attributes`. (AWS currently includes `extra_connection_attributes` in the raw responses to the AWS Provider requests and so they may be visible in the logs.)
 * > **Note:** Some of this resource's arguments have default values that come from the AWS Provider. Other default values are provided by AWS and subject to change without notice. When relying on AWS defaults, the provider state will often have a zero value. For example, the AWS Provider does not provide a default for `cdc_max_batch_interval` but the AWS default is `60` (seconds). However, the provider state will show `0` since this is the value return by AWS when no value is present. Below, we aim to flag the defaults that come from AWS (_e.g._, "AWS default...").
 * ## Example Usage
 * ### Minimal Configuration
 * This is the minimal configuration for an `aws.dms.S3Endpoint`. This endpoint will rely on the AWS Provider and AWS defaults.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dms.S3Endpoint("example", {
 *     endpointId: "donnedtipi",
 *     endpointType: "target",
 *     bucketName: "beckut_name",
 *     serviceAccessRoleArn: exampleAwsIamRole.arn,
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dms.S3Endpoint("example",
 *     endpoint_id="donnedtipi",
 *     endpoint_type="target",
 *     bucket_name="beckut_name",
 *     service_access_role_arn=example_aws_iam_role["arn"],
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dms.S3Endpoint("example", new()
 *     {
 *         EndpointId = "donnedtipi",
 *         EndpointType = "target",
 *         BucketName = "beckut_name",
 *         ServiceAccessRoleArn = exampleAwsIamRole.Arn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewS3Endpoint(ctx, "example", &dms.S3EndpointArgs{
 * 			EndpointId:           pulumi.String("donnedtipi"),
 * 			EndpointType:         pulumi.String("target"),
 * 			BucketName:           pulumi.String("beckut_name"),
 * 			ServiceAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint("example", S3EndpointArgs.builder()
 *             .endpointId("donnedtipi")
 *             .endpointType("target")
 *             .bucketName("beckut_name")
 *             .serviceAccessRoleArn(exampleAwsIamRole.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dms:S3Endpoint
 *     properties:
 *       endpointId: donnedtipi
 *       endpointType: target
 *       bucketName: beckut_name
 *       serviceAccessRoleArn: ${exampleAwsIamRole.arn}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicy}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Complete Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dms.S3Endpoint("example", {
 *     endpointId: "donnedtipi",
 *     endpointType: "target",
 *     sslMode: "none",
 *     tags: {
 *         Name: "donnedtipi",
 *         Update: "to-update",
 *         Remove: "to-remove",
 *     },
 *     addColumnName: true,
 *     addTrailingPaddingCharacter: false,
 *     bucketFolder: "folder",
 *     bucketName: "bucket_name",
 *     cannedAclForObjects: "private",
 *     cdcInsertsAndUpdates: true,
 *     cdcInsertsOnly: false,
 *     cdcMaxBatchInterval: 100,
 *     cdcMinFileSize: 16,
 *     cdcPath: "cdc/path",
 *     compressionType: "GZIP",
 *     csvDelimiter: ";",
 *     csvNoSupValue: "x",
 *     csvNullValue: "?",
 *     csvRowDelimiter: "\\r\\n",
 *     dataFormat: "parquet",
 *     dataPageSize: 1100000,
 *     datePartitionDelimiter: "UNDERSCORE",
 *     datePartitionEnabled: true,
 *     datePartitionSequence: "yyyymmddhh",
 *     datePartitionTimezone: "Asia/Seoul",
 *     dictPageSizeLimit: 1000000,
 *     enableStatistics: false,
 *     encodingType: "plain",
 *     encryptionMode: "SSE_S3",
 *     expectedBucketOwner: current.accountId,
 *     externalTableDefinition: "etd",
 *     ignoreHeaderRows: 1,
 *     includeOpForFullLoad: true,
 *     maxFileSize: 1000000,
 *     parquetTimestampInMillisecond: true,
 *     parquetVersion: "parquet-2-0",
 *     preserveTransactions: false,
 *     rfc4180: false,
 *     rowGroupLength: 11000,
 *     serverSideEncryptionKmsKeyId: exampleAwsKmsKey.arn,
 *     serviceAccessRoleArn: exampleAwsIamRole.arn,
 *     timestampColumnName: "tx_commit_time",
 *     useCsvNoSupValue: false,
 *     useTaskStartTimeForFullLoadTimestamp: true,
 *     glueCatalogGeneration: true,
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dms.S3Endpoint("example",
 *     endpoint_id="donnedtipi",
 *     endpoint_type="target",
 *     ssl_mode="none",
 *     tags={
 *         "Name": "donnedtipi",
 *         "Update": "to-update",
 *         "Remove": "to-remove",
 *     },
 *     add_column_name=True,
 *     add_trailing_padding_character=False,
 *     bucket_folder="folder",
 *     bucket_name="bucket_name",
 *     canned_acl_for_objects="private",
 *     cdc_inserts_and_updates=True,
 *     cdc_inserts_only=False,
 *     cdc_max_batch_interval=100,
 *     cdc_min_file_size=16,
 *     cdc_path="cdc/path",
 *     compression_type="GZIP",
 *     csv_delimiter=";",
 *     csv_no_sup_value="x",
 *     csv_null_value="?",
 *     csv_row_delimiter="\\r\\n",
 *     data_format="parquet",
 *     data_page_size=1100000,
 *     date_partition_delimiter="UNDERSCORE",
 *     date_partition_enabled=True,
 *     date_partition_sequence="yyyymmddhh",
 *     date_partition_timezone="Asia/Seoul",
 *     dict_page_size_limit=1000000,
 *     enable_statistics=False,
 *     encoding_type="plain",
 *     encryption_mode="SSE_S3",
 *     expected_bucket_owner=current["accountId"],
 *     external_table_definition="etd",
 *     ignore_header_rows=1,
 *     include_op_for_full_load=True,
 *     max_file_size=1000000,
 *     parquet_timestamp_in_millisecond=True,
 *     parquet_version="parquet-2-0",
 *     preserve_transactions=False,
 *     rfc4180=False,
 *     row_group_length=11000,
 *     server_side_encryption_kms_key_id=example_aws_kms_key["arn"],
 *     service_access_role_arn=example_aws_iam_role["arn"],
 *     timestamp_column_name="tx_commit_time",
 *     use_csv_no_sup_value=False,
 *     use_task_start_time_for_full_load_timestamp=True,
 *     glue_catalog_generation=True,
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dms.S3Endpoint("example", new()
 *     {
 *         EndpointId = "donnedtipi",
 *         EndpointType = "target",
 *         SslMode = "none",
 *         Tags =
 *         {
 *             { "Name", "donnedtipi" },
 *             { "Update", "to-update" },
 *             { "Remove", "to-remove" },
 *         },
 *         AddColumnName = true,
 *         AddTrailingPaddingCharacter = false,
 *         BucketFolder = "folder",
 *         BucketName = "bucket_name",
 *         CannedAclForObjects = "private",
 *         CdcInsertsAndUpdates = true,
 *         CdcInsertsOnly = false,
 *         CdcMaxBatchInterval = 100,
 *         CdcMinFileSize = 16,
 *         CdcPath = "cdc/path",
 *         CompressionType = "GZIP",
 *         CsvDelimiter = ";",
 *         CsvNoSupValue = "x",
 *         CsvNullValue = "?",
 *         CsvRowDelimiter = "\\r\\n",
 *         DataFormat = "parquet",
 *         DataPageSize = 1100000,
 *         DatePartitionDelimiter = "UNDERSCORE",
 *         DatePartitionEnabled = true,
 *         DatePartitionSequence = "yyyymmddhh",
 *         DatePartitionTimezone = "Asia/Seoul",
 *         DictPageSizeLimit = 1000000,
 *         EnableStatistics = false,
 *         EncodingType = "plain",
 *         EncryptionMode = "SSE_S3",
 *         ExpectedBucketOwner = current.AccountId,
 *         ExternalTableDefinition = "etd",
 *         IgnoreHeaderRows = 1,
 *         IncludeOpForFullLoad = true,
 *         MaxFileSize = 1000000,
 *         ParquetTimestampInMillisecond = true,
 *         ParquetVersion = "parquet-2-0",
 *         PreserveTransactions = false,
 *         Rfc4180 = false,
 *         RowGroupLength = 11000,
 *         ServerSideEncryptionKmsKeyId = exampleAwsKmsKey.Arn,
 *         ServiceAccessRoleArn = exampleAwsIamRole.Arn,
 *         TimestampColumnName = "tx_commit_time",
 *         UseCsvNoSupValue = false,
 *         UseTaskStartTimeForFullLoadTimestamp = true,
 *         GlueCatalogGeneration = true,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewS3Endpoint(ctx, "example", &dms.S3EndpointArgs{
 * 			EndpointId:   pulumi.String("donnedtipi"),
 * 			EndpointType: pulumi.String("target"),
 * 			SslMode:      pulumi.String("none"),
 * 			Tags: pulumi.StringMap{
 * 				"Name":   pulumi.String("donnedtipi"),
 * 				"Update": pulumi.String("to-update"),
 * 				"Remove": pulumi.String("to-remove"),
 * 			},
 * 			AddColumnName:                        pulumi.Bool(true),
 * 			AddTrailingPaddingCharacter:          pulumi.Bool(false),
 * 			BucketFolder:                         pulumi.String("folder"),
 * 			BucketName:                           pulumi.String("bucket_name"),
 * 			CannedAclForObjects:                  pulumi.String("private"),
 * 			CdcInsertsAndUpdates:                 pulumi.Bool(true),
 * 			CdcInsertsOnly:                       pulumi.Bool(false),
 * 			CdcMaxBatchInterval:                  pulumi.Int(100),
 * 			CdcMinFileSize:                       pulumi.Int(16),
 * 			CdcPath:                              pulumi.String("cdc/path"),
 * 			CompressionType:                      pulumi.String("GZIP"),
 * 			CsvDelimiter:                         pulumi.String(";"),
 * 			CsvNoSupValue:                        pulumi.String("x"),
 * 			CsvNullValue:                         pulumi.String("?"),
 * 			CsvRowDelimiter:                      pulumi.String("\\r\\n"),
 * 			DataFormat:                           pulumi.String("parquet"),
 * 			DataPageSize:                         pulumi.Int(1100000),
 * 			DatePartitionDelimiter:               pulumi.String("UNDERSCORE"),
 * 			DatePartitionEnabled:                 pulumi.Bool(true),
 * 			DatePartitionSequence:                pulumi.String("yyyymmddhh"),
 * 			DatePartitionTimezone:                pulumi.String("Asia/Seoul"),
 * 			DictPageSizeLimit:                    pulumi.Int(1000000),
 * 			EnableStatistics:                     pulumi.Bool(false),
 * 			EncodingType:                         pulumi.String("plain"),
 * 			EncryptionMode:                       pulumi.String("SSE_S3"),
 * 			ExpectedBucketOwner:                  pulumi.Any(current.AccountId),
 * 			ExternalTableDefinition:              pulumi.String("etd"),
 * 			IgnoreHeaderRows:                     pulumi.Int(1),
 * 			IncludeOpForFullLoad:                 pulumi.Bool(true),
 * 			MaxFileSize:                          pulumi.Int(1000000),
 * 			ParquetTimestampInMillisecond:        pulumi.Bool(true),
 * 			ParquetVersion:                       pulumi.String("parquet-2-0"),
 * 			PreserveTransactions:                 pulumi.Bool(false),
 * 			Rfc4180:                              pulumi.Bool(false),
 * 			RowGroupLength:                       pulumi.Int(11000),
 * 			ServerSideEncryptionKmsKeyId:         pulumi.Any(exampleAwsKmsKey.Arn),
 * 			ServiceAccessRoleArn:                 pulumi.Any(exampleAwsIamRole.Arn),
 * 			TimestampColumnName:                  pulumi.String("tx_commit_time"),
 * 			UseCsvNoSupValue:                     pulumi.Bool(false),
 * 			UseTaskStartTimeForFullLoadTimestamp: pulumi.Bool(true),
 * 			GlueCatalogGeneration:                pulumi.Bool(true),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint("example", S3EndpointArgs.builder()
 *             .endpointId("donnedtipi")
 *             .endpointType("target")
 *             .sslMode("none")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "donnedtipi"),
 *                 Map.entry("Update", "to-update"),
 *                 Map.entry("Remove", "to-remove")
 *             ))
 *             .addColumnName(true)
 *             .addTrailingPaddingCharacter(false)
 *             .bucketFolder("folder")
 *             .bucketName("bucket_name")
 *             .cannedAclForObjects("private")
 *             .cdcInsertsAndUpdates(true)
 *             .cdcInsertsOnly(false)
 *             .cdcMaxBatchInterval(100)
 *             .cdcMinFileSize(16)
 *             .cdcPath("cdc/path")
 *             .compressionType("GZIP")
 *             .csvDelimiter(";")
 *             .csvNoSupValue("x")
 *             .csvNullValue("?")
 *             .csvRowDelimiter("\\r\\n")
 *             .dataFormat("parquet")
 *             .dataPageSize(1100000)
 *             .datePartitionDelimiter("UNDERSCORE")
 *             .datePartitionEnabled(true)
 *             .datePartitionSequence("yyyymmddhh")
 *             .datePartitionTimezone("Asia/Seoul")
 *             .dictPageSizeLimit(1000000)
 *             .enableStatistics(false)
 *             .encodingType("plain")
 *             .encryptionMode("SSE_S3")
 *             .expectedBucketOwner(current.accountId())
 *             .externalTableDefinition("etd")
 *             .ignoreHeaderRows(1)
 *             .includeOpForFullLoad(true)
 *             .maxFileSize(1000000)
 *             .parquetTimestampInMillisecond(true)
 *             .parquetVersion("parquet-2-0")
 *             .preserveTransactions(false)
 *             .rfc4180(false)
 *             .rowGroupLength(11000)
 *             .serverSideEncryptionKmsKeyId(exampleAwsKmsKey.arn())
 *             .serviceAccessRoleArn(exampleAwsIamRole.arn())
 *             .timestampColumnName("tx_commit_time")
 *             .useCsvNoSupValue(false)
 *             .useTaskStartTimeForFullLoadTimestamp(true)
 *             .glueCatalogGeneration(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dms:S3Endpoint
 *     properties:
 *       endpointId: donnedtipi
 *       endpointType: target
 *       sslMode: none
 *       tags:
 *         Name: donnedtipi
 *         Update: to-update
 *         Remove: to-remove
 *       addColumnName: true
 *       addTrailingPaddingCharacter: false
 *       bucketFolder: folder
 *       bucketName: bucket_name
 *       cannedAclForObjects: private
 *       cdcInsertsAndUpdates: true
 *       cdcInsertsOnly: false
 *       cdcMaxBatchInterval: 100
 *       cdcMinFileSize: 16
 *       cdcPath: cdc/path
 *       compressionType: GZIP
 *       csvDelimiter: ;
 *       csvNoSupValue: x
 *       csvNullValue: '?'
 *       csvRowDelimiter: \r\n
 *       dataFormat: parquet
 *       dataPageSize: 1.1e+06
 *       datePartitionDelimiter: UNDERSCORE
 *       datePartitionEnabled: true
 *       datePartitionSequence: yyyymmddhh
 *       datePartitionTimezone: Asia/Seoul
 *       dictPageSizeLimit: 1e+06
 *       enableStatistics: false
 *       encodingType: plain
 *       encryptionMode: SSE_S3
 *       expectedBucketOwner: ${current.accountId}
 *       externalTableDefinition: etd
 *       ignoreHeaderRows: 1
 *       includeOpForFullLoad: true
 *       maxFileSize: 1e+06
 *       parquetTimestampInMillisecond: true
 *       parquetVersion: parquet-2-0
 *       preserveTransactions: false
 *       rfc4180: false
 *       rowGroupLength: 11000
 *       serverSideEncryptionKmsKeyId: ${exampleAwsKmsKey.arn}
 *       serviceAccessRoleArn: ${exampleAwsIamRole.arn}
 *       timestampColumnName: tx_commit_time
 *       useCsvNoSupValue: false
 *       useTaskStartTimeForFullLoadTimestamp: true
 *       glueCatalogGeneration: true
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicy}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import endpoints using the `endpoint_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/s3Endpoint:S3Endpoint example example-dms-endpoint-tf
 * ```
 * @property addColumnName Whether to add column name information to the .csv output file. Default is `false`.
 * @property addTrailingPaddingCharacter Whether to add padding. Default is `false`. (Ignored for source endpoints.)
 * @property bucketFolder S3 object prefix.
 * @property bucketName S3 bucket name.
 * @property cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
 * @property cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
 * @property cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
 * @property cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
 * @property cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
 * @property cdcPath Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
 * @property certificateArn ARN for the certificate.
 * @property compressionType Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
 * @property csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
 * @property csvNoSupValue Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
 * @property csvNullValue String to as null when writing to the target. (AWS default is `NULL`.)
 * @property csvRowDelimiter Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
 * @property dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
 * @property dataPageSize Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
 * @property datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
 * @property datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
 * @property datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
 * @property datePartitionTimezone Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
 * @property detachTargetOnLobLookupFailureParquet Undocumented argument for use as directed by AWS Support.
 * @property dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
 * @property enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
 * @property encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
 * @property encryptionMode Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
 * @property endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
 * @property endpointType Type of endpoint. Valid values are `source`, `target`.
 * @property expectedBucketOwner Bucket owner to prevent sniping. Value is an AWS account ID.
 * @property externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
 * @property glueCatalogGeneration Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
 * @property ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
 * @property includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
 * @property kmsKeyArn ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
 * @property maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
 * @property parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
 * @property parquetVersion Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
 * @property preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
 * @property rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
 * @property rowGroupLength Number of rows in a row group. (AWS default is `10000`.)
 * @property serverSideEncryptionKmsKeyId When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
 * @property serviceAccessRoleArn ARN of the IAM role with permissions to the S3 Bucket.
 * The following arguments are optional:
 * @property sslMode SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
 * @property useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
 * @property useTaskStartTimeForFullLoadTimestamp When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
 */
public data class S3EndpointArgs(
    public val addColumnName: Output<Boolean>? = null,
    public val addTrailingPaddingCharacter: Output<Boolean>? = null,
    public val bucketFolder: Output<String>? = null,
    public val bucketName: Output<String>? = null,
    public val cannedAclForObjects: Output<String>? = null,
    public val cdcInsertsAndUpdates: Output<Boolean>? = null,
    public val cdcInsertsOnly: Output<Boolean>? = null,
    public val cdcMaxBatchInterval: Output<Int>? = null,
    public val cdcMinFileSize: Output<Int>? = null,
    public val cdcPath: Output<String>? = null,
    public val certificateArn: Output<String>? = null,
    public val compressionType: Output<String>? = null,
    public val csvDelimiter: Output<String>? = null,
    public val csvNoSupValue: Output<String>? = null,
    public val csvNullValue: Output<String>? = null,
    public val csvRowDelimiter: Output<String>? = null,
    public val dataFormat: Output<String>? = null,
    public val dataPageSize: Output<Int>? = null,
    public val datePartitionDelimiter: Output<String>? = null,
    public val datePartitionEnabled: Output<Boolean>? = null,
    public val datePartitionSequence: Output<String>? = null,
    public val datePartitionTimezone: Output<String>? = null,
    public val detachTargetOnLobLookupFailureParquet: Output<Boolean>? = null,
    public val dictPageSizeLimit: Output<Int>? = null,
    public val enableStatistics: Output<Boolean>? = null,
    public val encodingType: Output<String>? = null,
    public val encryptionMode: Output<String>? = null,
    public val endpointId: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val externalTableDefinition: Output<String>? = null,
    public val glueCatalogGeneration: Output<Boolean>? = null,
    public val ignoreHeaderRows: Output<Int>? = null,
    public val includeOpForFullLoad: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val maxFileSize: Output<Int>? = null,
    public val parquetTimestampInMillisecond: Output<Boolean>? = null,
    public val parquetVersion: Output<String>? = null,
    public val preserveTransactions: Output<Boolean>? = null,
    public val rfc4180: Output<Boolean>? = null,
    public val rowGroupLength: Output<Int>? = null,
    public val serverSideEncryptionKmsKeyId: Output<String>? = null,
    public val serviceAccessRoleArn: Output<String>? = null,
    public val sslMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timestampColumnName: Output<String>? = null,
    public val useCsvNoSupValue: Output<Boolean>? = null,
    public val useTaskStartTimeForFullLoadTimestamp: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.S3EndpointArgs> {
    override fun toJava(): com.pulumi.aws.dms.S3EndpointArgs =
        com.pulumi.aws.dms.S3EndpointArgs.builder()
            .addColumnName(addColumnName?.applyValue({ args0 -> args0 }))
            .addTrailingPaddingCharacter(addTrailingPaddingCharacter?.applyValue({ args0 -> args0 }))
            .bucketFolder(bucketFolder?.applyValue({ args0 -> args0 }))
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .cannedAclForObjects(cannedAclForObjects?.applyValue({ args0 -> args0 }))
            .cdcInsertsAndUpdates(cdcInsertsAndUpdates?.applyValue({ args0 -> args0 }))
            .cdcInsertsOnly(cdcInsertsOnly?.applyValue({ args0 -> args0 }))
            .cdcMaxBatchInterval(cdcMaxBatchInterval?.applyValue({ args0 -> args0 }))
            .cdcMinFileSize(cdcMinFileSize?.applyValue({ args0 -> args0 }))
            .cdcPath(cdcPath?.applyValue({ args0 -> args0 }))
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .compressionType(compressionType?.applyValue({ args0 -> args0 }))
            .csvDelimiter(csvDelimiter?.applyValue({ args0 -> args0 }))
            .csvNoSupValue(csvNoSupValue?.applyValue({ args0 -> args0 }))
            .csvNullValue(csvNullValue?.applyValue({ args0 -> args0 }))
            .csvRowDelimiter(csvRowDelimiter?.applyValue({ args0 -> args0 }))
            .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
            .dataPageSize(dataPageSize?.applyValue({ args0 -> args0 }))
            .datePartitionDelimiter(datePartitionDelimiter?.applyValue({ args0 -> args0 }))
            .datePartitionEnabled(datePartitionEnabled?.applyValue({ args0 -> args0 }))
            .datePartitionSequence(datePartitionSequence?.applyValue({ args0 -> args0 }))
            .datePartitionTimezone(datePartitionTimezone?.applyValue({ args0 -> args0 }))
            .detachTargetOnLobLookupFailureParquet(
                detachTargetOnLobLookupFailureParquet?.applyValue({ args0 ->
                    args0
                }),
            )
            .dictPageSizeLimit(dictPageSizeLimit?.applyValue({ args0 -> args0 }))
            .enableStatistics(enableStatistics?.applyValue({ args0 -> args0 }))
            .encodingType(encodingType?.applyValue({ args0 -> args0 }))
            .encryptionMode(encryptionMode?.applyValue({ args0 -> args0 }))
            .endpointId(endpointId?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .externalTableDefinition(externalTableDefinition?.applyValue({ args0 -> args0 }))
            .glueCatalogGeneration(glueCatalogGeneration?.applyValue({ args0 -> args0 }))
            .ignoreHeaderRows(ignoreHeaderRows?.applyValue({ args0 -> args0 }))
            .includeOpForFullLoad(includeOpForFullLoad?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .maxFileSize(maxFileSize?.applyValue({ args0 -> args0 }))
            .parquetTimestampInMillisecond(parquetTimestampInMillisecond?.applyValue({ args0 -> args0 }))
            .parquetVersion(parquetVersion?.applyValue({ args0 -> args0 }))
            .preserveTransactions(preserveTransactions?.applyValue({ args0 -> args0 }))
            .rfc4180(rfc4180?.applyValue({ args0 -> args0 }))
            .rowGroupLength(rowGroupLength?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionKmsKeyId(serverSideEncryptionKmsKeyId?.applyValue({ args0 -> args0 }))
            .serviceAccessRoleArn(serviceAccessRoleArn?.applyValue({ args0 -> args0 }))
            .sslMode(sslMode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timestampColumnName(timestampColumnName?.applyValue({ args0 -> args0 }))
            .useCsvNoSupValue(useCsvNoSupValue?.applyValue({ args0 -> args0 }))
            .useTaskStartTimeForFullLoadTimestamp(
                useTaskStartTimeForFullLoadTimestamp?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [S3EndpointArgs].
 */
@PulumiTagMarker
public class S3EndpointArgsBuilder internal constructor() {
    private var addColumnName: Output<Boolean>? = null

    private var addTrailingPaddingCharacter: Output<Boolean>? = null

    private var bucketFolder: Output<String>? = null

    private var bucketName: Output<String>? = null

    private var cannedAclForObjects: Output<String>? = null

    private var cdcInsertsAndUpdates: Output<Boolean>? = null

    private var cdcInsertsOnly: Output<Boolean>? = null

    private var cdcMaxBatchInterval: Output<Int>? = null

    private var cdcMinFileSize: Output<Int>? = null

    private var cdcPath: Output<String>? = null

    private var certificateArn: Output<String>? = null

    private var compressionType: Output<String>? = null

    private var csvDelimiter: Output<String>? = null

    private var csvNoSupValue: Output<String>? = null

    private var csvNullValue: Output<String>? = null

    private var csvRowDelimiter: Output<String>? = null

    private var dataFormat: Output<String>? = null

    private var dataPageSize: Output<Int>? = null

    private var datePartitionDelimiter: Output<String>? = null

    private var datePartitionEnabled: Output<Boolean>? = null

    private var datePartitionSequence: Output<String>? = null

    private var datePartitionTimezone: Output<String>? = null

    private var detachTargetOnLobLookupFailureParquet: Output<Boolean>? = null

    private var dictPageSizeLimit: Output<Int>? = null

    private var enableStatistics: Output<Boolean>? = null

    private var encodingType: Output<String>? = null

    private var encryptionMode: Output<String>? = null

    private var endpointId: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var externalTableDefinition: Output<String>? = null

    private var glueCatalogGeneration: Output<Boolean>? = null

    private var ignoreHeaderRows: Output<Int>? = null

    private var includeOpForFullLoad: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    private var maxFileSize: Output<Int>? = null

    private var parquetTimestampInMillisecond: Output<Boolean>? = null

    private var parquetVersion: Output<String>? = null

    private var preserveTransactions: Output<Boolean>? = null

    private var rfc4180: Output<Boolean>? = null

    private var rowGroupLength: Output<Int>? = null

    private var serverSideEncryptionKmsKeyId: Output<String>? = null

    private var serviceAccessRoleArn: Output<String>? = null

    private var sslMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timestampColumnName: Output<String>? = null

    private var useCsvNoSupValue: Output<Boolean>? = null

    private var useTaskStartTimeForFullLoadTimestamp: Output<Boolean>? = null

    /**
     * @param value Whether to add column name information to the .csv output file. Default is `false`.
     */
    @JvmName("ivdfuggadvcnspcd")
    public suspend fun addColumnName(`value`: Output<Boolean>) {
        this.addColumnName = value
    }

    /**
     * @param value Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("ierkdoahddukknxs")
    public suspend fun addTrailingPaddingCharacter(`value`: Output<Boolean>) {
        this.addTrailingPaddingCharacter = value
    }

    /**
     * @param value S3 object prefix.
     */
    @JvmName("uelaohqknsebxcmx")
    public suspend fun bucketFolder(`value`: Output<String>) {
        this.bucketFolder = value
    }

    /**
     * @param value S3 bucket name.
     */
    @JvmName("giyledipygpetytu")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     */
    @JvmName("rspvxkjkfdvonlhk")
    public suspend fun cannedAclForObjects(`value`: Output<String>) {
        this.cannedAclForObjects = value
    }

    /**
     * @param value Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("lyvmuqatecxcgaeo")
    public suspend fun cdcInsertsAndUpdates(`value`: Output<Boolean>) {
        this.cdcInsertsAndUpdates = value
    }

    /**
     * @param value Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("tcrlerryqhtvqbgr")
    public suspend fun cdcInsertsOnly(`value`: Output<Boolean>) {
        this.cdcInsertsOnly = value
    }

    /**
     * @param value Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     */
    @JvmName("aixjoweyvqrepnmc")
    public suspend fun cdcMaxBatchInterval(`value`: Output<Int>) {
        this.cdcMaxBatchInterval = value
    }

    /**
     * @param value Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     */
    @JvmName("iqyxrpdrhiedcovj")
    public suspend fun cdcMinFileSize(`value`: Output<Int>) {
        this.cdcMinFileSize = value
    }

    /**
     * @param value Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     */
    @JvmName("nyyktippxbvbaujy")
    public suspend fun cdcPath(`value`: Output<String>) {
        this.cdcPath = value
    }

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("fkcqucrietsfjesv")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     */
    @JvmName("ceotticoyemcdwdc")
    public suspend fun compressionType(`value`: Output<String>) {
        this.compressionType = value
    }

    /**
     * @param value Delimiter used to separate columns in the source files. Default is `,`.
     */
    @JvmName("ebahkhgvfbpaogid")
    public suspend fun csvDelimiter(`value`: Output<String>) {
        this.csvDelimiter = value
    }

    /**
     * @param value Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     */
    @JvmName("ormwyxjkokqvsfcw")
    public suspend fun csvNoSupValue(`value`: Output<String>) {
        this.csvNoSupValue = value
    }

    /**
     * @param value String to as null when writing to the target. (AWS default is `NULL`.)
     */
    @JvmName("ghqbmcxxoaluicjg")
    public suspend fun csvNullValue(`value`: Output<String>) {
        this.csvNullValue = value
    }

    /**
     * @param value Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     */
    @JvmName("ornlhixxyeqhyfhh")
    public suspend fun csvRowDelimiter(`value`: Output<String>) {
        this.csvRowDelimiter = value
    }

    /**
     * @param value Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     */
    @JvmName("djmyjbidqjwhgrcy")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    @JvmName("qwoshvrqboxasxcl")
    public suspend fun dataPageSize(`value`: Output<Int>) {
        this.dataPageSize = value
    }

    /**
     * @param value Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     */
    @JvmName("pmvfjswmhdbfwmve")
    public suspend fun datePartitionDelimiter(`value`: Output<String>) {
        this.datePartitionDelimiter = value
    }

    /**
     * @param value Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("balrltmrpcrwekvt")
    public suspend fun datePartitionEnabled(`value`: Output<Boolean>) {
        this.datePartitionEnabled = value
    }

    /**
     * @param value Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     */
    @JvmName("obctnaqceusyverh")
    public suspend fun datePartitionSequence(`value`: Output<String>) {
        this.datePartitionSequence = value
    }

    /**
     * @param value Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     */
    @JvmName("uksmerymwprebuhu")
    public suspend fun datePartitionTimezone(`value`: Output<String>) {
        this.datePartitionTimezone = value
    }

    /**
     * @param value Undocumented argument for use as directed by AWS Support.
     */
    @JvmName("ppddrovaxotxohem")
    public suspend fun detachTargetOnLobLookupFailureParquet(`value`: Output<Boolean>) {
        this.detachTargetOnLobLookupFailureParquet = value
    }

    /**
     * @param value Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    @JvmName("botnncqhefqqwbpl")
    public suspend fun dictPageSizeLimit(`value`: Output<Int>) {
        this.dictPageSizeLimit = value
    }

    /**
     * @param value Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     */
    @JvmName("clbakjwfnfetbrse")
    public suspend fun enableStatistics(`value`: Output<Boolean>) {
        this.enableStatistics = value
    }

    /**
     * @param value Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     */
    @JvmName("ecjiiotklfevdxub")
    public suspend fun encodingType(`value`: Output<String>) {
        this.encodingType = value
    }

    /**
     * @param value Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     */
    @JvmName("jlepxivordfuamrf")
    public suspend fun encryptionMode(`value`: Output<String>) {
        this.encryptionMode = value
    }

    /**
     * @param value Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    @JvmName("yybusjeuikjblidr")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value Type of endpoint. Valid values are `source`, `target`.
     */
    @JvmName("eufaraoepjecqptl")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Bucket owner to prevent sniping. Value is an AWS account ID.
     */
    @JvmName("eqeugfonwwhjtpyn")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value JSON document that describes how AWS DMS should interpret the data.
     */
    @JvmName("qpbrcdqsyllscwle")
    public suspend fun externalTableDefinition(`value`: Output<String>) {
        this.externalTableDefinition = value
    }

    /**
     * @param value Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
     */
    @JvmName("ocifarrbtpsdlqdr")
    public suspend fun glueCatalogGeneration(`value`: Output<Boolean>) {
        this.glueCatalogGeneration = value
    }

    /**
     * @param value When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     */
    @JvmName("kehlgbonujvymsad")
    public suspend fun ignoreHeaderRows(`value`: Output<Int>) {
        this.ignoreHeaderRows = value
    }

    /**
     * @param value Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     */
    @JvmName("twvojnmxdqbpmput")
    public suspend fun includeOpForFullLoad(`value`: Output<Boolean>) {
        this.includeOpForFullLoad = value
    }

    /**
     * @param value ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    @JvmName("pfrmawigmcvpdqmg")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     */
    @JvmName("xpfeslkbwheukkye")
    public suspend fun maxFileSize(`value`: Output<Int>) {
        this.maxFileSize = value
    }

    /**
     * @param value Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("qrcwajeblcerlfgi")
    public suspend fun parquetTimestampInMillisecond(`value`: Output<Boolean>) {
        this.parquetTimestampInMillisecond = value
    }

    /**
     * @param value Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     */
    @JvmName("gtkknivgsmpkpmcc")
    public suspend fun parquetVersion(`value`: Output<String>) {
        this.parquetVersion = value
    }

    /**
     * @param value Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("pxyvjyhiscuyjtpy")
    public suspend fun preserveTransactions(`value`: Output<Boolean>) {
        this.preserveTransactions = value
    }

    /**
     * @param value For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     */
    @JvmName("ajgcaqqiettgsrxy")
    public suspend fun rfc4180(`value`: Output<Boolean>) {
        this.rfc4180 = value
    }

    /**
     * @param value Number of rows in a row group. (AWS default is `10000`.)
     */
    @JvmName("ptntjjpigewmojcp")
    public suspend fun rowGroupLength(`value`: Output<Int>) {
        this.rowGroupLength = value
    }

    /**
     * @param value When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     */
    @JvmName("xojxmopwidqmugqm")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: Output<String>) {
        this.serverSideEncryptionKmsKeyId = value
    }

    /**
     * @param value ARN of the IAM role with permissions to the S3 Bucket.
     * The following arguments are optional:
     */
    @JvmName("fmglnxkdxtlfolbx")
    public suspend fun serviceAccessRoleArn(`value`: Output<String>) {
        this.serviceAccessRoleArn = value
    }

    /**
     * @param value SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     */
    @JvmName("xplwptmxbkmtelkx")
    public suspend fun sslMode(`value`: Output<String>) {
        this.sslMode = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vstchoxkbyeqkmpl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     */
    @JvmName("cdvcfsdcyvbllsyx")
    public suspend fun timestampColumnName(`value`: Output<String>) {
        this.timestampColumnName = value
    }

    /**
     * @param value Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     */
    @JvmName("jhfrdgtumlfadste")
    public suspend fun useCsvNoSupValue(`value`: Output<Boolean>) {
        this.useCsvNoSupValue = value
    }

    /**
     * @param value When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     */
    @JvmName("rbtkwqrcxlqdcrkm")
    public suspend fun useTaskStartTimeForFullLoadTimestamp(`value`: Output<Boolean>) {
        this.useTaskStartTimeForFullLoadTimestamp = value
    }

    /**
     * @param value Whether to add column name information to the .csv output file. Default is `false`.
     */
    @JvmName("pumhulvfwwmmvplw")
    public suspend fun addColumnName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addColumnName = mapped
    }

    /**
     * @param value Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("hulrtqpqcvhsqont")
    public suspend fun addTrailingPaddingCharacter(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addTrailingPaddingCharacter = mapped
    }

    /**
     * @param value S3 object prefix.
     */
    @JvmName("oigtlmnvyebxihbt")
    public suspend fun bucketFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketFolder = mapped
    }

    /**
     * @param value S3 bucket name.
     */
    @JvmName("hbhnihevnrepamqh")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     */
    @JvmName("agukoddmyeqenuds")
    public suspend fun cannedAclForObjects(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cannedAclForObjects = mapped
    }

    /**
     * @param value Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("hbmwuvdjfkpcnxvx")
    public suspend fun cdcInsertsAndUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcInsertsAndUpdates = mapped
    }

    /**
     * @param value Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("sejgtrubgnhptmtu")
    public suspend fun cdcInsertsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcInsertsOnly = mapped
    }

    /**
     * @param value Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     */
    @JvmName("wqbuosmfvxtnboxp")
    public suspend fun cdcMaxBatchInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcMaxBatchInterval = mapped
    }

    /**
     * @param value Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     */
    @JvmName("lnplnjttjvmtbody")
    public suspend fun cdcMinFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcMinFileSize = mapped
    }

    /**
     * @param value Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     */
    @JvmName("tiglewjhcrhnblnp")
    public suspend fun cdcPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcPath = mapped
    }

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("ngrtfxfdvrihjlja")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     */
    @JvmName("yhdbwfpsrtgphgcf")
    public suspend fun compressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionType = mapped
    }

    /**
     * @param value Delimiter used to separate columns in the source files. Default is `,`.
     */
    @JvmName("vxovkgckiayhcsjp")
    public suspend fun csvDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvDelimiter = mapped
    }

    /**
     * @param value Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     */
    @JvmName("eapqycxlmnhasxfw")
    public suspend fun csvNoSupValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvNoSupValue = mapped
    }

    /**
     * @param value String to as null when writing to the target. (AWS default is `NULL`.)
     */
    @JvmName("eaigcgieoqkhltkv")
    public suspend fun csvNullValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvNullValue = mapped
    }

    /**
     * @param value Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     */
    @JvmName("dfipadjrnxblxguq")
    public suspend fun csvRowDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvRowDelimiter = mapped
    }

    /**
     * @param value Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     */
    @JvmName("matqxyoyrvtsvagb")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    @JvmName("pcxjmthhayrymijx")
    public suspend fun dataPageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPageSize = mapped
    }

    /**
     * @param value Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     */
    @JvmName("cjrrkqfweyvoqagn")
    public suspend fun datePartitionDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionDelimiter = mapped
    }

    /**
     * @param value Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("ddswflxobcutwxuk")
    public suspend fun datePartitionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionEnabled = mapped
    }

    /**
     * @param value Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     */
    @JvmName("qhvvaaqewmlxsegk")
    public suspend fun datePartitionSequence(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionSequence = mapped
    }

    /**
     * @param value Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     */
    @JvmName("sdggxbhhtfkealpo")
    public suspend fun datePartitionTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionTimezone = mapped
    }

    /**
     * @param value Undocumented argument for use as directed by AWS Support.
     */
    @JvmName("mhfyfihvygxqgfdq")
    public suspend fun detachTargetOnLobLookupFailureParquet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detachTargetOnLobLookupFailureParquet = mapped
    }

    /**
     * @param value Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    @JvmName("orbjtaousgbbxerg")
    public suspend fun dictPageSizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dictPageSizeLimit = mapped
    }

    /**
     * @param value Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     */
    @JvmName("xbmknqyjysmdrbsy")
    public suspend fun enableStatistics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStatistics = mapped
    }

    /**
     * @param value Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     */
    @JvmName("cpwpunncfeggwjqv")
    public suspend fun encodingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingType = mapped
    }

    /**
     * @param value Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     */
    @JvmName("cqlixqnvyqqlpnkp")
    public suspend fun encryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionMode = mapped
    }

    /**
     * @param value Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    @JvmName("iqujcbmgplvrples")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value Type of endpoint. Valid values are `source`, `target`.
     */
    @JvmName("yjjandtjuwgoaxhf")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Bucket owner to prevent sniping. Value is an AWS account ID.
     */
    @JvmName("wmuewlnsievmrjsc")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value JSON document that describes how AWS DMS should interpret the data.
     */
    @JvmName("uidwgxjoitmwiasj")
    public suspend fun externalTableDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTableDefinition = mapped
    }

    /**
     * @param value Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
     */
    @JvmName("iclnqgbqbrkliswj")
    public suspend fun glueCatalogGeneration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueCatalogGeneration = mapped
    }

    /**
     * @param value When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     */
    @JvmName("pdmhcoklepiixfcb")
    public suspend fun ignoreHeaderRows(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreHeaderRows = mapped
    }

    /**
     * @param value Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     */
    @JvmName("orgynvldleopqtkq")
    public suspend fun includeOpForFullLoad(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeOpForFullLoad = mapped
    }

    /**
     * @param value ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    @JvmName("xdqfbmyomqjrrbwq")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     */
    @JvmName("qwaiqbseccfkwkll")
    public suspend fun maxFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxFileSize = mapped
    }

    /**
     * @param value Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("qnwldwrkmiqxxtar")
    public suspend fun parquetTimestampInMillisecond(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parquetTimestampInMillisecond = mapped
    }

    /**
     * @param value Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     */
    @JvmName("tthuxpwmkrfpufqx")
    public suspend fun parquetVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parquetVersion = mapped
    }

    /**
     * @param value Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     */
    @JvmName("pllckbvohpmaagak")
    public suspend fun preserveTransactions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveTransactions = mapped
    }

    /**
     * @param value For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     */
    @JvmName("peisvnelqeftifso")
    public suspend fun rfc4180(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rfc4180 = mapped
    }

    /**
     * @param value Number of rows in a row group. (AWS default is `10000`.)
     */
    @JvmName("noolqujiufmhimnk")
    public suspend fun rowGroupLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowGroupLength = mapped
    }

    /**
     * @param value When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     */
    @JvmName("btbhtkkgcyjixler")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionKmsKeyId = mapped
    }

    /**
     * @param value ARN of the IAM role with permissions to the S3 Bucket.
     * The following arguments are optional:
     */
    @JvmName("voqowghwohsuyrhv")
    public suspend fun serviceAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessRoleArn = mapped
    }

    /**
     * @param value SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     */
    @JvmName("avdtwpopaehxuovl")
    public suspend fun sslMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslMode = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qbhdgkkdpfpbcwcv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rqqfojoivmietqfa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     */
    @JvmName("mtivghnvikcsywbv")
    public suspend fun timestampColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampColumnName = mapped
    }

    /**
     * @param value Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     */
    @JvmName("pqkpdgpbqkysikmo")
    public suspend fun useCsvNoSupValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCsvNoSupValue = mapped
    }

    /**
     * @param value When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     */
    @JvmName("ofclktmwqlwevebc")
    public suspend fun useTaskStartTimeForFullLoadTimestamp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTaskStartTimeForFullLoadTimestamp = mapped
    }

    internal fun build(): S3EndpointArgs = S3EndpointArgs(
        addColumnName = addColumnName,
        addTrailingPaddingCharacter = addTrailingPaddingCharacter,
        bucketFolder = bucketFolder,
        bucketName = bucketName,
        cannedAclForObjects = cannedAclForObjects,
        cdcInsertsAndUpdates = cdcInsertsAndUpdates,
        cdcInsertsOnly = cdcInsertsOnly,
        cdcMaxBatchInterval = cdcMaxBatchInterval,
        cdcMinFileSize = cdcMinFileSize,
        cdcPath = cdcPath,
        certificateArn = certificateArn,
        compressionType = compressionType,
        csvDelimiter = csvDelimiter,
        csvNoSupValue = csvNoSupValue,
        csvNullValue = csvNullValue,
        csvRowDelimiter = csvRowDelimiter,
        dataFormat = dataFormat,
        dataPageSize = dataPageSize,
        datePartitionDelimiter = datePartitionDelimiter,
        datePartitionEnabled = datePartitionEnabled,
        datePartitionSequence = datePartitionSequence,
        datePartitionTimezone = datePartitionTimezone,
        detachTargetOnLobLookupFailureParquet = detachTargetOnLobLookupFailureParquet,
        dictPageSizeLimit = dictPageSizeLimit,
        enableStatistics = enableStatistics,
        encodingType = encodingType,
        encryptionMode = encryptionMode,
        endpointId = endpointId,
        endpointType = endpointType,
        expectedBucketOwner = expectedBucketOwner,
        externalTableDefinition = externalTableDefinition,
        glueCatalogGeneration = glueCatalogGeneration,
        ignoreHeaderRows = ignoreHeaderRows,
        includeOpForFullLoad = includeOpForFullLoad,
        kmsKeyArn = kmsKeyArn,
        maxFileSize = maxFileSize,
        parquetTimestampInMillisecond = parquetTimestampInMillisecond,
        parquetVersion = parquetVersion,
        preserveTransactions = preserveTransactions,
        rfc4180 = rfc4180,
        rowGroupLength = rowGroupLength,
        serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId,
        serviceAccessRoleArn = serviceAccessRoleArn,
        sslMode = sslMode,
        tags = tags,
        timestampColumnName = timestampColumnName,
        useCsvNoSupValue = useCsvNoSupValue,
        useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp,
    )
}
