@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointElasticsearchSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointUri Endpoint for the OpenSearch cluster.
 * @property errorRetryDuration Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
 * @property fullLoadErrorPercentage Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to write to the OpenSearch cluster.
 * @property useNewMappingType Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
 */
public data class EndpointElasticsearchSettingsArgs(
    public val endpointUri: Output<String>,
    public val errorRetryDuration: Output<Int>? = null,
    public val fullLoadErrorPercentage: Output<Int>? = null,
    public val serviceAccessRoleArn: Output<String>,
    public val useNewMappingType: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointElasticsearchSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointElasticsearchSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointElasticsearchSettingsArgs.builder()
            .endpointUri(endpointUri.applyValue({ args0 -> args0 }))
            .errorRetryDuration(errorRetryDuration?.applyValue({ args0 -> args0 }))
            .fullLoadErrorPercentage(fullLoadErrorPercentage?.applyValue({ args0 -> args0 }))
            .serviceAccessRoleArn(serviceAccessRoleArn.applyValue({ args0 -> args0 }))
            .useNewMappingType(useNewMappingType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointElasticsearchSettingsArgs].
 */
@PulumiTagMarker
public class EndpointElasticsearchSettingsArgsBuilder internal constructor() {
    private var endpointUri: Output<String>? = null

    private var errorRetryDuration: Output<Int>? = null

    private var fullLoadErrorPercentage: Output<Int>? = null

    private var serviceAccessRoleArn: Output<String>? = null

    private var useNewMappingType: Output<Boolean>? = null

    /**
     * @param value Endpoint for the OpenSearch cluster.
     */
    @JvmName("egisahqajujdoykw")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
     */
    @JvmName("ugcumbfjcbvjjixh")
    public suspend fun errorRetryDuration(`value`: Output<Int>) {
        this.errorRetryDuration = value
    }

    /**
     * @param value Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
     */
    @JvmName("dhqhrsttvnelhfcp")
    public suspend fun fullLoadErrorPercentage(`value`: Output<Int>) {
        this.fullLoadErrorPercentage = value
    }

    /**
     * @param value ARN of the IAM Role with permissions to write to the OpenSearch cluster.
     */
    @JvmName("nubmhynmfvpbxiji")
    public suspend fun serviceAccessRoleArn(`value`: Output<String>) {
        this.serviceAccessRoleArn = value
    }

    /**
     * @param value Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
     */
    @JvmName("phdmynhvgmryptqo")
    public suspend fun useNewMappingType(`value`: Output<Boolean>) {
        this.useNewMappingType = value
    }

    /**
     * @param value Endpoint for the OpenSearch cluster.
     */
    @JvmName("scgjcecgfrpvviuu")
    public suspend fun endpointUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
     */
    @JvmName("kxvgxqikyhemocmm")
    public suspend fun errorRetryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorRetryDuration = mapped
    }

    /**
     * @param value Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
     */
    @JvmName("vchqwyqldoccqpsg")
    public suspend fun fullLoadErrorPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullLoadErrorPercentage = mapped
    }

    /**
     * @param value ARN of the IAM Role with permissions to write to the OpenSearch cluster.
     */
    @JvmName("lbcrydwmyhshempp")
    public suspend fun serviceAccessRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceAccessRoleArn = mapped
    }

    /**
     * @param value Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
     */
    @JvmName("sqdehkyftaqcjgyt")
    public suspend fun useNewMappingType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useNewMappingType = mapped
    }

    internal fun build(): EndpointElasticsearchSettingsArgs = EndpointElasticsearchSettingsArgs(
        endpointUri = endpointUri ?: throw PulumiNullFieldException("endpointUri"),
        errorRetryDuration = errorRetryDuration,
        fullLoadErrorPercentage = fullLoadErrorPercentage,
        serviceAccessRoleArn = serviceAccessRoleArn ?: throw
            PulumiNullFieldException("serviceAccessRoleArn"),
        useNewMappingType = useNewMappingType,
    )
}
