@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointKinesisSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
 * @property includeNullAndEmpty Include NULL and empty columns in the target. Default is `false`.
 * @property includePartitionValue Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
 * @property includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
 * @property includeTransactionDetails Provides detailed transaction information from the source database. Default is `false`.
 * @property messageFormat Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
 * @property partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to write to the Kinesis data stream.
 * @property streamArn ARN of the Kinesis data stream.
 */
public data class EndpointKinesisSettingsArgs(
    public val includeControlDetails: Output<Boolean>? = null,
    public val includeNullAndEmpty: Output<Boolean>? = null,
    public val includePartitionValue: Output<Boolean>? = null,
    public val includeTableAlterOperations: Output<Boolean>? = null,
    public val includeTransactionDetails: Output<Boolean>? = null,
    public val messageFormat: Output<String>? = null,
    public val partitionIncludeSchemaTable: Output<Boolean>? = null,
    public val serviceAccessRoleArn: Output<String>? = null,
    public val streamArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointKinesisSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointKinesisSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointKinesisSettingsArgs.builder()
            .includeControlDetails(includeControlDetails?.applyValue({ args0 -> args0 }))
            .includeNullAndEmpty(includeNullAndEmpty?.applyValue({ args0 -> args0 }))
            .includePartitionValue(includePartitionValue?.applyValue({ args0 -> args0 }))
            .includeTableAlterOperations(includeTableAlterOperations?.applyValue({ args0 -> args0 }))
            .includeTransactionDetails(includeTransactionDetails?.applyValue({ args0 -> args0 }))
            .messageFormat(messageFormat?.applyValue({ args0 -> args0 }))
            .partitionIncludeSchemaTable(partitionIncludeSchemaTable?.applyValue({ args0 -> args0 }))
            .serviceAccessRoleArn(serviceAccessRoleArn?.applyValue({ args0 -> args0 }))
            .streamArn(streamArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointKinesisSettingsArgs].
 */
@PulumiTagMarker
public class EndpointKinesisSettingsArgsBuilder internal constructor() {
    private var includeControlDetails: Output<Boolean>? = null

    private var includeNullAndEmpty: Output<Boolean>? = null

    private var includePartitionValue: Output<Boolean>? = null

    private var includeTableAlterOperations: Output<Boolean>? = null

    private var includeTransactionDetails: Output<Boolean>? = null

    private var messageFormat: Output<String>? = null

    private var partitionIncludeSchemaTable: Output<Boolean>? = null

    private var serviceAccessRoleArn: Output<String>? = null

    private var streamArn: Output<String>? = null

    /**
     * @param value Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
     */
    @JvmName("ladobdxhqdppkkof")
    public suspend fun includeControlDetails(`value`: Output<Boolean>) {
        this.includeControlDetails = value
    }

    /**
     * @param value Include NULL and empty columns in the target. Default is `false`.
     */
    @JvmName("warpsgvmneteneel")
    public suspend fun includeNullAndEmpty(`value`: Output<Boolean>) {
        this.includeNullAndEmpty = value
    }

    /**
     * @param value Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
     */
    @JvmName("ehmwvxlmdiiylwnr")
    public suspend fun includePartitionValue(`value`: Output<Boolean>) {
        this.includePartitionValue = value
    }

    /**
     * @param value Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
     */
    @JvmName("uffpxacvpeafbirj")
    public suspend fun includeTableAlterOperations(`value`: Output<Boolean>) {
        this.includeTableAlterOperations = value
    }

    /**
     * @param value Provides detailed transaction information from the source database. Default is `false`.
     */
    @JvmName("soidtyvooolhplmc")
    public suspend fun includeTransactionDetails(`value`: Output<Boolean>) {
        this.includeTransactionDetails = value
    }

    /**
     * @param value Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
     */
    @JvmName("svmkhoftpmqvajer")
    public suspend fun messageFormat(`value`: Output<String>) {
        this.messageFormat = value
    }

    /**
     * @param value Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
     */
    @JvmName("ppdfoioonjfhlqvm")
    public suspend fun partitionIncludeSchemaTable(`value`: Output<Boolean>) {
        this.partitionIncludeSchemaTable = value
    }

    /**
     * @param value ARN of the IAM Role with permissions to write to the Kinesis data stream.
     */
    @JvmName("oaxghygrnnjgwhtq")
    public suspend fun serviceAccessRoleArn(`value`: Output<String>) {
        this.serviceAccessRoleArn = value
    }

    /**
     * @param value ARN of the Kinesis data stream.
     */
    @JvmName("rkgjmewgcdsjrpmi")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
     */
    @JvmName("uxgspbjkirpfponm")
    public suspend fun includeControlDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeControlDetails = mapped
    }

    /**
     * @param value Include NULL and empty columns in the target. Default is `false`.
     */
    @JvmName("tfidypbttjbmuvdd")
    public suspend fun includeNullAndEmpty(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeNullAndEmpty = mapped
    }

    /**
     * @param value Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
     */
    @JvmName("plbtwunqyuadebgh")
    public suspend fun includePartitionValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includePartitionValue = mapped
    }

    /**
     * @param value Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
     */
    @JvmName("vklvwtrwufbeseot")
    public suspend fun includeTableAlterOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTableAlterOperations = mapped
    }

    /**
     * @param value Provides detailed transaction information from the source database. Default is `false`.
     */
    @JvmName("osbrioddynufdvvb")
    public suspend fun includeTransactionDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTransactionDetails = mapped
    }

    /**
     * @param value Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
     */
    @JvmName("rpijvejdofkvkfud")
    public suspend fun messageFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFormat = mapped
    }

    /**
     * @param value Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
     */
    @JvmName("btypwvdbtarefgxc")
    public suspend fun partitionIncludeSchemaTable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionIncludeSchemaTable = mapped
    }

    /**
     * @param value ARN of the IAM Role with permissions to write to the Kinesis data stream.
     */
    @JvmName("ljejstelvfpwfgoq")
    public suspend fun serviceAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessRoleArn = mapped
    }

    /**
     * @param value ARN of the Kinesis data stream.
     */
    @JvmName("ynbbvhealypvfwct")
    public suspend fun streamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): EndpointKinesisSettingsArgs = EndpointKinesisSettingsArgs(
        includeControlDetails = includeControlDetails,
        includeNullAndEmpty = includeNullAndEmpty,
        includePartitionValue = includePartitionValue,
        includeTableAlterOperations = includeTableAlterOperations,
        includeTransactionDetails = includeTransactionDetails,
        messageFormat = messageFormat,
        partitionIncludeSchemaTable = partitionIncludeSchemaTable,
        serviceAccessRoleArn = serviceAccessRoleArn,
        streamArn = streamArn,
    )
}
