@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointS3SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addColumnName Whether to add column name information to the .csv output file. Default is `false`.
 * @property bucketFolder S3 object prefix.
 * @property bucketName S3 bucket name.
 * @property cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
 * @property cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
 * @property cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
 * @property cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
 * @property cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
 * @property cdcPath Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
 * @property compressionType Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
 * @property csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
 * @property csvNoSupValue String to use for all columns not included in the supplemental log.
 * @property csvNullValue String to as null when writing to the target.
 * @property csvRowDelimiter Delimiter used to separate rows in the source files. Default is `\n`.
 * @property dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
 * @property dataPageSize Size of one data page in bytes. Default is `1048576` (1 MiB).
 * @property datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
 * @property datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`.
 * @property datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
 * @property dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
 * @property enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
 * @property encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
 * @property encryptionMode Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. Default is `SSE_S3`.
 * @property externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
 * @property glueCatalogGeneration Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
 * @property ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
 * @property includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
 * @property maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
 * @property parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
 * @property parquetVersion Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
 * @property preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
 * @property rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
 * @property rowGroupLength Number of rows in a row group. Default is `10000`.
 * @property serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to read from or write to the S3 Bucket.
 * @property timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
 * @property useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
 * @property useTaskStartTimeForFullLoadTimestamp When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
 */
public data class EndpointS3SettingsArgs(
    public val addColumnName: Output<Boolean>? = null,
    public val bucketFolder: Output<String>? = null,
    public val bucketName: Output<String>? = null,
    public val cannedAclForObjects: Output<String>? = null,
    public val cdcInsertsAndUpdates: Output<Boolean>? = null,
    public val cdcInsertsOnly: Output<Boolean>? = null,
    public val cdcMaxBatchInterval: Output<Int>? = null,
    public val cdcMinFileSize: Output<Int>? = null,
    public val cdcPath: Output<String>? = null,
    public val compressionType: Output<String>? = null,
    public val csvDelimiter: Output<String>? = null,
    public val csvNoSupValue: Output<String>? = null,
    public val csvNullValue: Output<String>? = null,
    public val csvRowDelimiter: Output<String>? = null,
    public val dataFormat: Output<String>? = null,
    public val dataPageSize: Output<Int>? = null,
    public val datePartitionDelimiter: Output<String>? = null,
    public val datePartitionEnabled: Output<Boolean>? = null,
    public val datePartitionSequence: Output<String>? = null,
    public val dictPageSizeLimit: Output<Int>? = null,
    public val enableStatistics: Output<Boolean>? = null,
    public val encodingType: Output<String>? = null,
    public val encryptionMode: Output<String>? = null,
    public val externalTableDefinition: Output<String>? = null,
    public val glueCatalogGeneration: Output<Boolean>? = null,
    public val ignoreHeaderRows: Output<Int>? = null,
    public val includeOpForFullLoad: Output<Boolean>? = null,
    public val maxFileSize: Output<Int>? = null,
    public val parquetTimestampInMillisecond: Output<Boolean>? = null,
    public val parquetVersion: Output<String>? = null,
    public val preserveTransactions: Output<Boolean>? = null,
    public val rfc4180: Output<Boolean>? = null,
    public val rowGroupLength: Output<Int>? = null,
    public val serverSideEncryptionKmsKeyId: Output<String>? = null,
    public val serviceAccessRoleArn: Output<String>? = null,
    public val timestampColumnName: Output<String>? = null,
    public val useCsvNoSupValue: Output<Boolean>? = null,
    public val useTaskStartTimeForFullLoadTimestamp: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointS3SettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointS3SettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointS3SettingsArgs.builder()
            .addColumnName(addColumnName?.applyValue({ args0 -> args0 }))
            .bucketFolder(bucketFolder?.applyValue({ args0 -> args0 }))
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .cannedAclForObjects(cannedAclForObjects?.applyValue({ args0 -> args0 }))
            .cdcInsertsAndUpdates(cdcInsertsAndUpdates?.applyValue({ args0 -> args0 }))
            .cdcInsertsOnly(cdcInsertsOnly?.applyValue({ args0 -> args0 }))
            .cdcMaxBatchInterval(cdcMaxBatchInterval?.applyValue({ args0 -> args0 }))
            .cdcMinFileSize(cdcMinFileSize?.applyValue({ args0 -> args0 }))
            .cdcPath(cdcPath?.applyValue({ args0 -> args0 }))
            .compressionType(compressionType?.applyValue({ args0 -> args0 }))
            .csvDelimiter(csvDelimiter?.applyValue({ args0 -> args0 }))
            .csvNoSupValue(csvNoSupValue?.applyValue({ args0 -> args0 }))
            .csvNullValue(csvNullValue?.applyValue({ args0 -> args0 }))
            .csvRowDelimiter(csvRowDelimiter?.applyValue({ args0 -> args0 }))
            .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
            .dataPageSize(dataPageSize?.applyValue({ args0 -> args0 }))
            .datePartitionDelimiter(datePartitionDelimiter?.applyValue({ args0 -> args0 }))
            .datePartitionEnabled(datePartitionEnabled?.applyValue({ args0 -> args0 }))
            .datePartitionSequence(datePartitionSequence?.applyValue({ args0 -> args0 }))
            .dictPageSizeLimit(dictPageSizeLimit?.applyValue({ args0 -> args0 }))
            .enableStatistics(enableStatistics?.applyValue({ args0 -> args0 }))
            .encodingType(encodingType?.applyValue({ args0 -> args0 }))
            .encryptionMode(encryptionMode?.applyValue({ args0 -> args0 }))
            .externalTableDefinition(externalTableDefinition?.applyValue({ args0 -> args0 }))
            .glueCatalogGeneration(glueCatalogGeneration?.applyValue({ args0 -> args0 }))
            .ignoreHeaderRows(ignoreHeaderRows?.applyValue({ args0 -> args0 }))
            .includeOpForFullLoad(includeOpForFullLoad?.applyValue({ args0 -> args0 }))
            .maxFileSize(maxFileSize?.applyValue({ args0 -> args0 }))
            .parquetTimestampInMillisecond(parquetTimestampInMillisecond?.applyValue({ args0 -> args0 }))
            .parquetVersion(parquetVersion?.applyValue({ args0 -> args0 }))
            .preserveTransactions(preserveTransactions?.applyValue({ args0 -> args0 }))
            .rfc4180(rfc4180?.applyValue({ args0 -> args0 }))
            .rowGroupLength(rowGroupLength?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionKmsKeyId(serverSideEncryptionKmsKeyId?.applyValue({ args0 -> args0 }))
            .serviceAccessRoleArn(serviceAccessRoleArn?.applyValue({ args0 -> args0 }))
            .timestampColumnName(timestampColumnName?.applyValue({ args0 -> args0 }))
            .useCsvNoSupValue(useCsvNoSupValue?.applyValue({ args0 -> args0 }))
            .useTaskStartTimeForFullLoadTimestamp(
                useTaskStartTimeForFullLoadTimestamp?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EndpointS3SettingsArgs].
 */
@PulumiTagMarker
public class EndpointS3SettingsArgsBuilder internal constructor() {
    private var addColumnName: Output<Boolean>? = null

    private var bucketFolder: Output<String>? = null

    private var bucketName: Output<String>? = null

    private var cannedAclForObjects: Output<String>? = null

    private var cdcInsertsAndUpdates: Output<Boolean>? = null

    private var cdcInsertsOnly: Output<Boolean>? = null

    private var cdcMaxBatchInterval: Output<Int>? = null

    private var cdcMinFileSize: Output<Int>? = null

    private var cdcPath: Output<String>? = null

    private var compressionType: Output<String>? = null

    private var csvDelimiter: Output<String>? = null

    private var csvNoSupValue: Output<String>? = null

    private var csvNullValue: Output<String>? = null

    private var csvRowDelimiter: Output<String>? = null

    private var dataFormat: Output<String>? = null

    private var dataPageSize: Output<Int>? = null

    private var datePartitionDelimiter: Output<String>? = null

    private var datePartitionEnabled: Output<Boolean>? = null

    private var datePartitionSequence: Output<String>? = null

    private var dictPageSizeLimit: Output<Int>? = null

    private var enableStatistics: Output<Boolean>? = null

    private var encodingType: Output<String>? = null

    private var encryptionMode: Output<String>? = null

    private var externalTableDefinition: Output<String>? = null

    private var glueCatalogGeneration: Output<Boolean>? = null

    private var ignoreHeaderRows: Output<Int>? = null

    private var includeOpForFullLoad: Output<Boolean>? = null

    private var maxFileSize: Output<Int>? = null

    private var parquetTimestampInMillisecond: Output<Boolean>? = null

    private var parquetVersion: Output<String>? = null

    private var preserveTransactions: Output<Boolean>? = null

    private var rfc4180: Output<Boolean>? = null

    private var rowGroupLength: Output<Int>? = null

    private var serverSideEncryptionKmsKeyId: Output<String>? = null

    private var serviceAccessRoleArn: Output<String>? = null

    private var timestampColumnName: Output<String>? = null

    private var useCsvNoSupValue: Output<Boolean>? = null

    private var useTaskStartTimeForFullLoadTimestamp: Output<Boolean>? = null

    /**
     * @param value Whether to add column name information to the .csv output file. Default is `false`.
     */
    @JvmName("xfqiwbarowgnxkhr")
    public suspend fun addColumnName(`value`: Output<Boolean>) {
        this.addColumnName = value
    }

    /**
     * @param value S3 object prefix.
     */
    @JvmName("dxxqnaofpjnokxew")
    public suspend fun bucketFolder(`value`: Output<String>) {
        this.bucketFolder = value
    }

    /**
     * @param value S3 bucket name.
     */
    @JvmName("akyruguhbvtctguk")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     */
    @JvmName("ehwjolusmtudwtve")
    public suspend fun cannedAclForObjects(`value`: Output<String>) {
        this.cannedAclForObjects = value
    }

    /**
     * @param value Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("ngobkecfjtpjxtis")
    public suspend fun cdcInsertsAndUpdates(`value`: Output<Boolean>) {
        this.cdcInsertsAndUpdates = value
    }

    /**
     * @param value Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("cxgntfrpuvmflkly")
    public suspend fun cdcInsertsOnly(`value`: Output<Boolean>) {
        this.cdcInsertsOnly = value
    }

    /**
     * @param value Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
     */
    @JvmName("fxbvfglwspmklmqg")
    public suspend fun cdcMaxBatchInterval(`value`: Output<Int>) {
        this.cdcMaxBatchInterval = value
    }

    /**
     * @param value Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
     */
    @JvmName("kbcemahbuvnrmtby")
    public suspend fun cdcMinFileSize(`value`: Output<Int>) {
        this.cdcMinFileSize = value
    }

    /**
     * @param value Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     */
    @JvmName("shncdlphhdsxdrtx")
    public suspend fun cdcPath(`value`: Output<String>) {
        this.cdcPath = value
    }

    /**
     * @param value Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
     */
    @JvmName("nxhdnakrvscxhggk")
    public suspend fun compressionType(`value`: Output<String>) {
        this.compressionType = value
    }

    /**
     * @param value Delimiter used to separate columns in the source files. Default is `,`.
     */
    @JvmName("ubwhetroapqmhktc")
    public suspend fun csvDelimiter(`value`: Output<String>) {
        this.csvDelimiter = value
    }

    /**
     * @param value String to use for all columns not included in the supplemental log.
     */
    @JvmName("ythvdheknixsvktx")
    public suspend fun csvNoSupValue(`value`: Output<String>) {
        this.csvNoSupValue = value
    }

    /**
     * @param value String to as null when writing to the target.
     */
    @JvmName("pneuaarusjcngboa")
    public suspend fun csvNullValue(`value`: Output<String>) {
        this.csvNullValue = value
    }

    /**
     * @param value Delimiter used to separate rows in the source files. Default is `\n`.
     */
    @JvmName("wftarbuicogjrjtu")
    public suspend fun csvRowDelimiter(`value`: Output<String>) {
        this.csvRowDelimiter = value
    }

    /**
     * @param value Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
     */
    @JvmName("mqhuonrjcsiqsolr")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value Size of one data page in bytes. Default is `1048576` (1 MiB).
     */
    @JvmName("reoyoxueqrtiisdb")
    public suspend fun dataPageSize(`value`: Output<Int>) {
        this.dataPageSize = value
    }

    /**
     * @param value Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
     */
    @JvmName("xugypbofqwqbfwyn")
    public suspend fun datePartitionDelimiter(`value`: Output<String>) {
        this.datePartitionDelimiter = value
    }

    /**
     * @param value Partition S3 bucket folders based on transaction commit dates. Default is `false`.
     */
    @JvmName("xxbcgyyucmxhfacl")
    public suspend fun datePartitionEnabled(`value`: Output<Boolean>) {
        this.datePartitionEnabled = value
    }

    /**
     * @param value Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
     */
    @JvmName("cgngtdwedjhxyctv")
    public suspend fun datePartitionSequence(`value`: Output<String>) {
        this.datePartitionSequence = value
    }

    /**
     * @param value Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
     */
    @JvmName("exsgxytfekmksvqc")
    public suspend fun dictPageSizeLimit(`value`: Output<Int>) {
        this.dictPageSizeLimit = value
    }

    /**
     * @param value Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     */
    @JvmName("gejvjypsyyfepuxf")
    public suspend fun enableStatistics(`value`: Output<Boolean>) {
        this.enableStatistics = value
    }

    /**
     * @param value Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
     */
    @JvmName("jppihlsbjtqsrirs")
    public suspend fun encodingType(`value`: Output<String>) {
        this.encodingType = value
    }

    /**
     * @param value Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. Default is `SSE_S3`.
     */
    @JvmName("ovxgwatvaoyvpnsy")
    public suspend fun encryptionMode(`value`: Output<String>) {
        this.encryptionMode = value
    }

    /**
     * @param value JSON document that describes how AWS DMS should interpret the data.
     */
    @JvmName("htbghqlurgpiylhv")
    public suspend fun externalTableDefinition(`value`: Output<String>) {
        this.externalTableDefinition = value
    }

    /**
     * @param value Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
     */
    @JvmName("qdsbjtuwasnrstno")
    public suspend fun glueCatalogGeneration(`value`: Output<Boolean>) {
        this.glueCatalogGeneration = value
    }

    /**
     * @param value When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
     */
    @JvmName("vklbitpednougtet")
    public suspend fun ignoreHeaderRows(`value`: Output<Int>) {
        this.ignoreHeaderRows = value
    }

    /**
     * @param value Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     */
    @JvmName("ehkhtrjkpgkknbwh")
    public suspend fun includeOpForFullLoad(`value`: Output<Boolean>) {
        this.includeOpForFullLoad = value
    }

    /**
     * @param value Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
     */
    @JvmName("vxwcmlwedxoloeym")
    public suspend fun maxFileSize(`value`: Output<Int>) {
        this.maxFileSize = value
    }

    /**
     * @param value Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
     */
    @JvmName("cyybvegnkpnoehxj")
    public suspend fun parquetTimestampInMillisecond(`value`: Output<Boolean>) {
        this.parquetTimestampInMillisecond = value
    }

    /**
     * @param value Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
     */
    @JvmName("mvfagkbweanrhhth")
    public suspend fun parquetVersion(`value`: Output<String>) {
        this.parquetVersion = value
    }

    /**
     * @param value Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
     */
    @JvmName("ggtwyyawiomxjelm")
    public suspend fun preserveTransactions(`value`: Output<Boolean>) {
        this.preserveTransactions = value
    }

    /**
     * @param value For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     */
    @JvmName("uidkbtuqxmspcojl")
    public suspend fun rfc4180(`value`: Output<Boolean>) {
        this.rfc4180 = value
    }

    /**
     * @param value Number of rows in a row group. Default is `10000`.
     */
    @JvmName("ybjrlecjklmodsps")
    public suspend fun rowGroupLength(`value`: Output<Int>) {
        this.rowGroupLength = value
    }

    /**
     * @param value ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     */
    @JvmName("klcvraomhjjockye")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: Output<String>) {
        this.serverSideEncryptionKmsKeyId = value
    }

    /**
     * @param value ARN of the IAM Role with permissions to read from or write to the S3 Bucket.
     */
    @JvmName("onrhajcvyfwcobsy")
    public suspend fun serviceAccessRoleArn(`value`: Output<String>) {
        this.serviceAccessRoleArn = value
    }

    /**
     * @param value Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     */
    @JvmName("shaloqjmvhlhnivk")
    public suspend fun timestampColumnName(`value`: Output<String>) {
        this.timestampColumnName = value
    }

    /**
     * @param value Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
     */
    @JvmName("dwhqwkcvvewlfrap")
    public suspend fun useCsvNoSupValue(`value`: Output<Boolean>) {
        this.useCsvNoSupValue = value
    }

    /**
     * @param value When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     */
    @JvmName("qovjtwllvynnjdjf")
    public suspend fun useTaskStartTimeForFullLoadTimestamp(`value`: Output<Boolean>) {
        this.useTaskStartTimeForFullLoadTimestamp = value
    }

    /**
     * @param value Whether to add column name information to the .csv output file. Default is `false`.
     */
    @JvmName("qsjymmimjgvxbnat")
    public suspend fun addColumnName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addColumnName = mapped
    }

    /**
     * @param value S3 object prefix.
     */
    @JvmName("tyodejtiemqnwteh")
    public suspend fun bucketFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketFolder = mapped
    }

    /**
     * @param value S3 bucket name.
     */
    @JvmName("emwbnuutapluyuqu")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     */
    @JvmName("nxwoggajcylndcha")
    public suspend fun cannedAclForObjects(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cannedAclForObjects = mapped
    }

    /**
     * @param value Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("ptnicnntwgkesyxa")
    public suspend fun cdcInsertsAndUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcInsertsAndUpdates = mapped
    }

    /**
     * @param value Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     */
    @JvmName("jbhijjbcbbsdtisx")
    public suspend fun cdcInsertsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcInsertsOnly = mapped
    }

    /**
     * @param value Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
     */
    @JvmName("gsrrwkbrunorhkbs")
    public suspend fun cdcMaxBatchInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcMaxBatchInterval = mapped
    }

    /**
     * @param value Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
     */
    @JvmName("sagqgjdxfulocoel")
    public suspend fun cdcMinFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcMinFileSize = mapped
    }

    /**
     * @param value Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     */
    @JvmName("okohptbrcetqaqhj")
    public suspend fun cdcPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcPath = mapped
    }

    /**
     * @param value Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
     */
    @JvmName("cwrviffvpwbtfuml")
    public suspend fun compressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionType = mapped
    }

    /**
     * @param value Delimiter used to separate columns in the source files. Default is `,`.
     */
    @JvmName("sqkahqjgplbefphm")
    public suspend fun csvDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvDelimiter = mapped
    }

    /**
     * @param value String to use for all columns not included in the supplemental log.
     */
    @JvmName("jeoeoqrlijrbjuoq")
    public suspend fun csvNoSupValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvNoSupValue = mapped
    }

    /**
     * @param value String to as null when writing to the target.
     */
    @JvmName("onkfhvkclhnatspf")
    public suspend fun csvNullValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvNullValue = mapped
    }

    /**
     * @param value Delimiter used to separate rows in the source files. Default is `\n`.
     */
    @JvmName("wiruuvjybkmoybmh")
    public suspend fun csvRowDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvRowDelimiter = mapped
    }

    /**
     * @param value Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
     */
    @JvmName("edynqijvbbkmxcel")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Size of one data page in bytes. Default is `1048576` (1 MiB).
     */
    @JvmName("ptgjnavuljstcsxu")
    public suspend fun dataPageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPageSize = mapped
    }

    /**
     * @param value Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
     */
    @JvmName("bsonwfvotssqxbjo")
    public suspend fun datePartitionDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionDelimiter = mapped
    }

    /**
     * @param value Partition S3 bucket folders based on transaction commit dates. Default is `false`.
     */
    @JvmName("luvwclqdaoqqwemn")
    public suspend fun datePartitionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionEnabled = mapped
    }

    /**
     * @param value Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
     */
    @JvmName("wqqhybkguvwacjow")
    public suspend fun datePartitionSequence(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datePartitionSequence = mapped
    }

    /**
     * @param value Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
     */
    @JvmName("vvhkoxcxyfefjfdv")
    public suspend fun dictPageSizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dictPageSizeLimit = mapped
    }

    /**
     * @param value Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     */
    @JvmName("rxeatihdcdddlepb")
    public suspend fun enableStatistics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStatistics = mapped
    }

    /**
     * @param value Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
     */
    @JvmName("rhxjfeydxkogjtld")
    public suspend fun encodingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingType = mapped
    }

    /**
     * @param value Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. Default is `SSE_S3`.
     */
    @JvmName("kankkqictxvongrh")
    public suspend fun encryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionMode = mapped
    }

    /**
     * @param value JSON document that describes how AWS DMS should interpret the data.
     */
    @JvmName("uupeimuvnekpkmvd")
    public suspend fun externalTableDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTableDefinition = mapped
    }

    /**
     * @param value Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
     */
    @JvmName("rdkyukpllqnmjhef")
    public suspend fun glueCatalogGeneration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueCatalogGeneration = mapped
    }

    /**
     * @param value When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
     */
    @JvmName("jlrekgxkvrswgdjc")
    public suspend fun ignoreHeaderRows(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreHeaderRows = mapped
    }

    /**
     * @param value Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     */
    @JvmName("poynfpdthufdhcaq")
    public suspend fun includeOpForFullLoad(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeOpForFullLoad = mapped
    }

    /**
     * @param value Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
     */
    @JvmName("tldywqbswmxlxovj")
    public suspend fun maxFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxFileSize = mapped
    }

    /**
     * @param value Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
     */
    @JvmName("eiociudpeayvyylf")
    public suspend fun parquetTimestampInMillisecond(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parquetTimestampInMillisecond = mapped
    }

    /**
     * @param value Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
     */
    @JvmName("fgpvntidjnumautq")
    public suspend fun parquetVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parquetVersion = mapped
    }

    /**
     * @param value Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
     */
    @JvmName("aalunnmbtshuqhao")
    public suspend fun preserveTransactions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveTransactions = mapped
    }

    /**
     * @param value For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     */
    @JvmName("lohngunrsqvxfmdw")
    public suspend fun rfc4180(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rfc4180 = mapped
    }

    /**
     * @param value Number of rows in a row group. Default is `10000`.
     */
    @JvmName("crbdtgtcaxewhcyo")
    public suspend fun rowGroupLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowGroupLength = mapped
    }

    /**
     * @param value ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     */
    @JvmName("sudjlkpmllpcjthd")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionKmsKeyId = mapped
    }

    /**
     * @param value ARN of the IAM Role with permissions to read from or write to the S3 Bucket.
     */
    @JvmName("ykhllrpyrykkgxjs")
    public suspend fun serviceAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessRoleArn = mapped
    }

    /**
     * @param value Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     */
    @JvmName("xekrautyeywtshrx")
    public suspend fun timestampColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampColumnName = mapped
    }

    /**
     * @param value Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
     */
    @JvmName("ruksnnlmghnxqhkk")
    public suspend fun useCsvNoSupValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCsvNoSupValue = mapped
    }

    /**
     * @param value When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     */
    @JvmName("euvstghwgkiuksrl")
    public suspend fun useTaskStartTimeForFullLoadTimestamp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTaskStartTimeForFullLoadTimestamp = mapped
    }

    internal fun build(): EndpointS3SettingsArgs = EndpointS3SettingsArgs(
        addColumnName = addColumnName,
        bucketFolder = bucketFolder,
        bucketName = bucketName,
        cannedAclForObjects = cannedAclForObjects,
        cdcInsertsAndUpdates = cdcInsertsAndUpdates,
        cdcInsertsOnly = cdcInsertsOnly,
        cdcMaxBatchInterval = cdcMaxBatchInterval,
        cdcMinFileSize = cdcMinFileSize,
        cdcPath = cdcPath,
        compressionType = compressionType,
        csvDelimiter = csvDelimiter,
        csvNoSupValue = csvNoSupValue,
        csvNullValue = csvNullValue,
        csvRowDelimiter = csvRowDelimiter,
        dataFormat = dataFormat,
        dataPageSize = dataPageSize,
        datePartitionDelimiter = datePartitionDelimiter,
        datePartitionEnabled = datePartitionEnabled,
        datePartitionSequence = datePartitionSequence,
        dictPageSizeLimit = dictPageSizeLimit,
        enableStatistics = enableStatistics,
        encodingType = encodingType,
        encryptionMode = encryptionMode,
        externalTableDefinition = externalTableDefinition,
        glueCatalogGeneration = glueCatalogGeneration,
        ignoreHeaderRows = ignoreHeaderRows,
        includeOpForFullLoad = includeOpForFullLoad,
        maxFileSize = maxFileSize,
        parquetTimestampInMillisecond = parquetTimestampInMillisecond,
        parquetVersion = parquetVersion,
        preserveTransactions = preserveTransactions,
        rfc4180 = rfc4180,
        rowGroupLength = rowGroupLength,
        serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId,
        serviceAccessRoleArn = serviceAccessRoleArn,
        timestampColumnName = timestampColumnName,
        useCsvNoSupValue = useCsvNoSupValue,
        useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp,
    )
}
