@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.GetReplicationInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationInstance.
 * @property replicationInstanceId The replication instance identifier.
 * @property tags
 */
public data class GetReplicationInstancePlainArgs(
    public val replicationInstanceId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.GetReplicationInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.GetReplicationInstancePlainArgs =
        com.pulumi.aws.dms.inputs.GetReplicationInstancePlainArgs.builder()
            .replicationInstanceId(replicationInstanceId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReplicationInstancePlainArgs].
 */
@PulumiTagMarker
public class GetReplicationInstancePlainArgsBuilder internal constructor() {
    private var replicationInstanceId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The replication instance identifier.
     */
    @JvmName("bmpobdegssngqgnq")
    public suspend fun replicationInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationInstanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("aogpiditctgebfad")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("dlcwhalemdfkitty")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReplicationInstancePlainArgs = GetReplicationInstancePlainArgs(
        replicationInstanceId = replicationInstanceId ?: throw
            PulumiNullFieldException("replicationInstanceId"),
        tags = tags,
    )
}
