@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.GetReplicationSubnetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationSubnetGroup.
 * @property replicationSubnetGroupId Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
 * @property tags
 */
public data class GetReplicationSubnetGroupPlainArgs(
    public val replicationSubnetGroupId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.GetReplicationSubnetGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.GetReplicationSubnetGroupPlainArgs =
        com.pulumi.aws.dms.inputs.GetReplicationSubnetGroupPlainArgs.builder()
            .replicationSubnetGroupId(replicationSubnetGroupId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReplicationSubnetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationSubnetGroupPlainArgsBuilder internal constructor() {
    private var replicationSubnetGroupId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    @JvmName("pngxmkuqtewtfxrj")
    public suspend fun replicationSubnetGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationSubnetGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("djgahyjsdfyoabot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("pdaoqatgksmomkdh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReplicationSubnetGroupPlainArgs = GetReplicationSubnetGroupPlainArgs(
        replicationSubnetGroupId = replicationSubnetGroupId ?: throw
            PulumiNullFieldException("replicationSubnetGroupId"),
        tags = tags,
    )
}
