@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
 * @property includeNullAndEmpty Include NULL and empty columns in the target. Default is `false`.
 * @property includePartitionValue Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
 * @property includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
 * @property includeTransactionDetails Provides detailed transaction information from the source database. Default is `false`.
 * @property messageFormat Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
 * @property partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to write to the Kinesis data stream.
 * @property streamArn ARN of the Kinesis data stream.
 */
public data class EndpointKinesisSettings(
    public val includeControlDetails: Boolean? = null,
    public val includeNullAndEmpty: Boolean? = null,
    public val includePartitionValue: Boolean? = null,
    public val includeTableAlterOperations: Boolean? = null,
    public val includeTransactionDetails: Boolean? = null,
    public val messageFormat: String? = null,
    public val partitionIncludeSchemaTable: Boolean? = null,
    public val serviceAccessRoleArn: String? = null,
    public val streamArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointKinesisSettings): EndpointKinesisSettings = EndpointKinesisSettings(
            includeControlDetails = javaType.includeControlDetails().map({ args0 -> args0 }).orElse(null),
            includeNullAndEmpty = javaType.includeNullAndEmpty().map({ args0 -> args0 }).orElse(null),
            includePartitionValue = javaType.includePartitionValue().map({ args0 -> args0 }).orElse(null),
            includeTableAlterOperations = javaType.includeTableAlterOperations().map({ args0 ->
                args0
            }).orElse(null),
            includeTransactionDetails = javaType.includeTransactionDetails().map({ args0 ->
                args0
            }).orElse(null),
            messageFormat = javaType.messageFormat().map({ args0 -> args0 }).orElse(null),
            partitionIncludeSchemaTable = javaType.partitionIncludeSchemaTable().map({ args0 ->
                args0
            }).orElse(null),
            serviceAccessRoleArn = javaType.serviceAccessRoleArn().map({ args0 -> args0 }).orElse(null),
            streamArn = javaType.streamArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
