@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property afterConnectScript For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
 * @property babelfishDatabaseName The Babelfish for Aurora PostgreSQL database name for the endpoint.
 * @property captureDdls To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
 * @property databaseMode Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
 * @property ddlArtifactsSchema Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
 * @property executeTimeout Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
 * @property failTasksOnLobTruncation When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
 * @property heartbeatEnable The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
 * @property heartbeatFrequency Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
 * @property heartbeatSchema Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
 * @property mapBooleanAsBoolean You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
 * @property mapJsonbAsClob Optional When true, DMS migrates JSONB values as CLOB.
 * @property mapLongVarcharAs Optional When true, DMS migrates LONG values as VARCHAR.
 * @property maxFileSize Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
 * @property pluginName Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
 * @property slotName Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
 */
public data class EndpointPostgresSettings(
    public val afterConnectScript: String? = null,
    public val babelfishDatabaseName: String? = null,
    public val captureDdls: Boolean? = null,
    public val databaseMode: String? = null,
    public val ddlArtifactsSchema: String? = null,
    public val executeTimeout: Int? = null,
    public val failTasksOnLobTruncation: Boolean? = null,
    public val heartbeatEnable: Boolean? = null,
    public val heartbeatFrequency: Int? = null,
    public val heartbeatSchema: String? = null,
    public val mapBooleanAsBoolean: Boolean? = null,
    public val mapJsonbAsClob: Boolean? = null,
    public val mapLongVarcharAs: String? = null,
    public val maxFileSize: Int? = null,
    public val pluginName: String? = null,
    public val slotName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointPostgresSettings): EndpointPostgresSettings = EndpointPostgresSettings(
            afterConnectScript = javaType.afterConnectScript().map({ args0 -> args0 }).orElse(null),
            babelfishDatabaseName = javaType.babelfishDatabaseName().map({ args0 -> args0 }).orElse(null),
            captureDdls = javaType.captureDdls().map({ args0 -> args0 }).orElse(null),
            databaseMode = javaType.databaseMode().map({ args0 -> args0 }).orElse(null),
            ddlArtifactsSchema = javaType.ddlArtifactsSchema().map({ args0 -> args0 }).orElse(null),
            executeTimeout = javaType.executeTimeout().map({ args0 -> args0 }).orElse(null),
            failTasksOnLobTruncation = javaType.failTasksOnLobTruncation().map({ args0 -> args0 }).orElse(null),
            heartbeatEnable = javaType.heartbeatEnable().map({ args0 -> args0 }).orElse(null),
            heartbeatFrequency = javaType.heartbeatFrequency().map({ args0 -> args0 }).orElse(null),
            heartbeatSchema = javaType.heartbeatSchema().map({ args0 -> args0 }).orElse(null),
            mapBooleanAsBoolean = javaType.mapBooleanAsBoolean().map({ args0 -> args0 }).orElse(null),
            mapJsonbAsClob = javaType.mapJsonbAsClob().map({ args0 -> args0 }).orElse(null),
            mapLongVarcharAs = javaType.mapLongVarcharAs().map({ args0 -> args0 }).orElse(null),
            maxFileSize = javaType.maxFileSize().map({ args0 -> args0 }).orElse(null),
            pluginName = javaType.pluginName().map({ args0 -> args0 }).orElse(null),
            slotName = javaType.slotName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
