@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authPassword The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
 * @property authType The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
 * @property authUserName The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
 * @property port Transmission Control Protocol (TCP) port for the endpoint.
 * @property serverName Fully qualified domain name of the endpoint.
 * @property sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
 * @property sslSecurityProtocol The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
 */
public data class EndpointRedisSettings(
    public val authPassword: String? = null,
    public val authType: String,
    public val authUserName: String? = null,
    public val port: Int,
    public val serverName: String,
    public val sslCaCertificateArn: String? = null,
    public val sslSecurityProtocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointRedisSettings): EndpointRedisSettings = EndpointRedisSettings(
            authPassword = javaType.authPassword().map({ args0 -> args0 }).orElse(null),
            authType = javaType.authType(),
            authUserName = javaType.authUserName().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            serverName = javaType.serverName(),
            sslCaCertificateArn = javaType.sslCaCertificateArn().map({ args0 -> args0 }).orElse(null),
            sslSecurityProtocol = javaType.sslSecurityProtocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
