@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getCertificate.
 * @property certificateArn The Amazon Resource Name (ARN) for the certificate.
 * @property certificateCreationDate The date that the certificate was created.
 * @property certificateId
 * @property certificateOwner The owner of the certificate.
 * @property certificatePem The contents of a .pem file, which contains an X.509 certificate.
 * @property certificateWallet The owner of the certificate.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyLength The key length of the cryptographic algorithm being used.
 * @property signingAlgorithm The algorithm for the certificate.
 * @property tags
 * @property validFromDate The beginning date that the certificate is valid.
 * @property validToDate The final date that the certificate is valid.
 */
public data class GetCertificateResult(
    public val certificateArn: String,
    public val certificateCreationDate: String,
    public val certificateId: String,
    public val certificateOwner: String,
    public val certificatePem: String,
    public val certificateWallet: String,
    public val id: String,
    public val keyLength: Int,
    public val signingAlgorithm: String,
    public val tags: Map<String, String>,
    public val validFromDate: String,
    public val validToDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            certificateArn = javaType.certificateArn(),
            certificateCreationDate = javaType.certificateCreationDate(),
            certificateId = javaType.certificateId(),
            certificateOwner = javaType.certificateOwner(),
            certificatePem = javaType.certificatePem(),
            certificateWallet = javaType.certificateWallet(),
            id = javaType.id(),
            keyLength = javaType.keyLength(),
            signingAlgorithm = javaType.signingAlgorithm(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            validFromDate = javaType.validFromDate(),
            validToDate = javaType.validToDate(),
        )
    }
}
