@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addColumnName
 * @property bucketFolder
 * @property bucketName
 * @property cannedAclForObjects
 * @property cdcInsertsAndUpdates
 * @property cdcInsertsOnly
 * @property cdcMaxBatchInterval
 * @property cdcMinFileSize
 * @property cdcPath
 * @property compressionType
 * @property csvDelimiter
 * @property csvNoSupValue
 * @property csvNullValue
 * @property csvRowDelimiter
 * @property dataFormat
 * @property dataPageSize
 * @property datePartitionDelimiter
 * @property datePartitionEnabled
 * @property datePartitionSequence
 * @property dictPageSizeLimit
 * @property enableStatistics
 * @property encodingType
 * @property encryptionMode
 * @property externalTableDefinition
 * @property glueCatalogGeneration
 * @property ignoreHeaderRows
 * @property ignoreHeadersRow
 * @property includeOpForFullLoad
 * @property maxFileSize
 * @property parquetTimestampInMillisecond
 * @property parquetVersion
 * @property preserveTransactions
 * @property rfc4180
 * @property rowGroupLength
 * @property serverSideEncryptionKmsKeyId
 * @property serviceAccessRoleArn
 * @property timestampColumnName
 * @property useCsvNoSupValue
 * @property useTaskStartTimeForFullLoadTimestamp
 */
public data class GetEndpointS3Setting(
    public val addColumnName: Boolean,
    public val bucketFolder: String,
    public val bucketName: String,
    public val cannedAclForObjects: String,
    public val cdcInsertsAndUpdates: Boolean,
    public val cdcInsertsOnly: Boolean,
    public val cdcMaxBatchInterval: Int,
    public val cdcMinFileSize: Int,
    public val cdcPath: String,
    public val compressionType: String,
    public val csvDelimiter: String,
    public val csvNoSupValue: String,
    public val csvNullValue: String,
    public val csvRowDelimiter: String,
    public val dataFormat: String,
    public val dataPageSize: Int,
    public val datePartitionDelimiter: String,
    public val datePartitionEnabled: Boolean,
    public val datePartitionSequence: String,
    public val dictPageSizeLimit: Int,
    public val enableStatistics: Boolean,
    public val encodingType: String,
    public val encryptionMode: String,
    public val externalTableDefinition: String,
    public val glueCatalogGeneration: Boolean,
    public val ignoreHeaderRows: Int,
    public val ignoreHeadersRow: Int,
    public val includeOpForFullLoad: Boolean,
    public val maxFileSize: Int,
    public val parquetTimestampInMillisecond: Boolean,
    public val parquetVersion: String,
    public val preserveTransactions: Boolean,
    public val rfc4180: Boolean,
    public val rowGroupLength: Int,
    public val serverSideEncryptionKmsKeyId: String,
    public val serviceAccessRoleArn: String,
    public val timestampColumnName: String,
    public val useCsvNoSupValue: Boolean,
    public val useTaskStartTimeForFullLoadTimestamp: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetEndpointS3Setting): GetEndpointS3Setting = GetEndpointS3Setting(
            addColumnName = javaType.addColumnName(),
            bucketFolder = javaType.bucketFolder(),
            bucketName = javaType.bucketName(),
            cannedAclForObjects = javaType.cannedAclForObjects(),
            cdcInsertsAndUpdates = javaType.cdcInsertsAndUpdates(),
            cdcInsertsOnly = javaType.cdcInsertsOnly(),
            cdcMaxBatchInterval = javaType.cdcMaxBatchInterval(),
            cdcMinFileSize = javaType.cdcMinFileSize(),
            cdcPath = javaType.cdcPath(),
            compressionType = javaType.compressionType(),
            csvDelimiter = javaType.csvDelimiter(),
            csvNoSupValue = javaType.csvNoSupValue(),
            csvNullValue = javaType.csvNullValue(),
            csvRowDelimiter = javaType.csvRowDelimiter(),
            dataFormat = javaType.dataFormat(),
            dataPageSize = javaType.dataPageSize(),
            datePartitionDelimiter = javaType.datePartitionDelimiter(),
            datePartitionEnabled = javaType.datePartitionEnabled(),
            datePartitionSequence = javaType.datePartitionSequence(),
            dictPageSizeLimit = javaType.dictPageSizeLimit(),
            enableStatistics = javaType.enableStatistics(),
            encodingType = javaType.encodingType(),
            encryptionMode = javaType.encryptionMode(),
            externalTableDefinition = javaType.externalTableDefinition(),
            glueCatalogGeneration = javaType.glueCatalogGeneration(),
            ignoreHeaderRows = javaType.ignoreHeaderRows(),
            ignoreHeadersRow = javaType.ignoreHeadersRow(),
            includeOpForFullLoad = javaType.includeOpForFullLoad(),
            maxFileSize = javaType.maxFileSize(),
            parquetTimestampInMillisecond = javaType.parquetTimestampInMillisecond(),
            parquetVersion = javaType.parquetVersion(),
            preserveTransactions = javaType.preserveTransactions(),
            rfc4180 = javaType.rfc4180(),
            rowGroupLength = javaType.rowGroupLength(),
            serverSideEncryptionKmsKeyId = javaType.serverSideEncryptionKmsKeyId(),
            serviceAccessRoleArn = javaType.serviceAccessRoleArn(),
            timestampColumnName = javaType.timestampColumnName(),
            useCsvNoSupValue = javaType.useCsvNoSupValue(),
            useTaskStartTimeForFullLoadTimestamp = javaType.useTaskStartTimeForFullLoadTimestamp(),
        )
    }
}
