@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
 * @property dnsNameServers A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
 * @property kmsKeyId An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
 * @property maxCapacityUnits Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
 * @property minCapacityUnits Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS scans the current activity of available source tables to identify an optimum setting for this parameter.
 * @property multiAz Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
 * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
 * - Format: `ddd:hh24:mi-ddd:hh24:mi`
 * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
 * - Constraints: Minimum 30-minute window.
 * @property replicationSubnetGroupId Specifies a subnet group identifier to associate with the DMS Serverless replication.
 * @property vpcSecurityGroupIds Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
 */
public data class ReplicationConfigComputeConfig(
    public val availabilityZone: String? = null,
    public val dnsNameServers: String? = null,
    public val kmsKeyId: String? = null,
    public val maxCapacityUnits: Int? = null,
    public val minCapacityUnits: Int? = null,
    public val multiAz: Boolean? = null,
    public val preferredMaintenanceWindow: String? = null,
    public val replicationSubnetGroupId: String,
    public val vpcSecurityGroupIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.ReplicationConfigComputeConfig): ReplicationConfigComputeConfig = ReplicationConfigComputeConfig(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            dnsNameServers = javaType.dnsNameServers().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            maxCapacityUnits = javaType.maxCapacityUnits().map({ args0 -> args0 }).orElse(null),
            minCapacityUnits = javaType.minCapacityUnits().map({ args0 -> args0 }).orElse(null),
            multiAz = javaType.multiAz().map({ args0 -> args0 }).orElse(null),
            preferredMaintenanceWindow = javaType.preferredMaintenanceWindow().map({ args0 ->
                args0
            }).orElse(null),
            replicationSubnetGroupId = javaType.replicationSubnetGroupId(),
            vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
