@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClusterInstance].
 */
@PulumiTagMarker
public class ClusterInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterInstanceArgs = ClusterInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterInstanceArgsBuilder.() -> Unit) {
        val builder = ClusterInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterInstance {
        val builtJavaResource = com.pulumi.aws.docdb.ClusterInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterInstance(builtJavaResource)
    }
}

/**
 * Provides an DocumentDB Cluster Resource Instance. A Cluster Instance Resource defines
 * attributes that are specific to a single instance in a [DocumentDB Cluster][1].
 * You do not designate a primary and subsequent replicas. Instead, you simply add DocumentDB
 * Instances and DocumentDB manages the replication. You can use the [count][3]
 * meta-parameter to make multiple instances and join them all to the same DocumentDB
 * Cluster, or you may specify different Cluster Instance resources with various
 * `instance_class` sizes.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.docdb.Cluster("default", {
 *     clusterIdentifier: "docdb-cluster-demo",
 *     availabilityZones: [
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     masterUsername: "foo",
 *     masterPassword: "barbut8chars",
 * });
 * const clusterInstances: aws.docdb.ClusterInstance[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     clusterInstances.push(new aws.docdb.ClusterInstance(`cluster_instances-${range.value}`, {
 *         identifier: `docdb-cluster-demo-${range.value}`,
 *         clusterIdentifier: _default.id,
 *         instanceClass: "db.r5.large",
 *     }));
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.docdb.Cluster("default",
 *     cluster_identifier="docdb-cluster-demo",
 *     availability_zones=[
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     master_username="foo",
 *     master_password="barbut8chars")
 * cluster_instances = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     cluster_instances.append(aws.docdb.ClusterInstance(f"cluster_instances-{range['value']}",
 *         identifier=f"docdb-cluster-demo-{range['value']}",
 *         cluster_identifier=default.id,
 *         instance_class="db.r5.large"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.DocDB.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "docdb-cluster-demo",
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *             "us-west-2b",
 *             "us-west-2c",
 *         },
 *         MasterUsername = "foo",
 *         MasterPassword = "barbut8chars",
 *     });
 *     var clusterInstances = new List<Aws.DocDB.ClusterInstance>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         clusterInstances.Add(new Aws.DocDB.ClusterInstance($"cluster_instances-{range.Value}", new()
 *         {
 *             Identifier = $"docdb-cluster-demo-{range.Value}",
 *             ClusterIdentifier = @default.Id,
 *             InstanceClass = "db.r5.large",
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := docdb.NewCluster(ctx, "default", &docdb.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("docdb-cluster-demo"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 				pulumi.String("us-west-2b"),
 * 				pulumi.String("us-west-2c"),
 * 			},
 * 			MasterUsername: pulumi.String("foo"),
 * 			MasterPassword: pulumi.String("barbut8chars"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var clusterInstances []*docdb.ClusterInstance
 * 		for index := 0; index < 2; index++ {
 * 			key0 := index
 * 			val0 := index
 * 			__res, err := docdb.NewClusterInstance(ctx, fmt.Sprintf("cluster_instances-%v", key0), &docdb.ClusterInstanceArgs{
 * 				Identifier:        pulumi.Sprintf("docdb-cluster-demo-%v", val0),
 * 				ClusterIdentifier: _default.ID(),
 * 				InstanceClass:     pulumi.String("db.r5.large"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			clusterInstances = append(clusterInstances, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.docdb.ClusterInstance;
 * import com.pulumi.aws.docdb.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("docdb-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .masterUsername("foo")
 *             .masterPassword("barbut8chars")
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new ClusterInstance("clusterInstances-" + i, ClusterInstanceArgs.builder()
 *                 .identifier(String.format("docdb-cluster-demo-%s", range.value()))
 *                 .clusterIdentifier(default_.id())
 *                 .instanceClass("db.r5.large")
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   clusterInstances:
 *     type: aws:docdb:ClusterInstance
 *     name: cluster_instances
 *     properties:
 *       identifier: docdb-cluster-demo-${range.value}
 *       clusterIdentifier: ${default.id}
 *       instanceClass: db.r5.large
 *     options: {}
 *   default:
 *     type: aws:docdb:Cluster
 *     properties:
 *       clusterIdentifier: docdb-cluster-demo
 *       availabilityZones:
 *         - us-west-2a
 *         - us-west-2b
 *         - us-west-2c
 *       masterUsername: foo
 *       masterPassword: barbut8chars
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DocumentDB Cluster Instances using the `identifier`. For example:
 * ```sh
 * $ pulumi import aws:docdb/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
 * ```
 */
public class ClusterInstance internal constructor(
    override val javaResource: com.pulumi.aws.docdb.ClusterInstance,
) : KotlinCustomResource(javaResource, ClusterInstanceMapper) {
    /**
     * Specifies whether any database modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of cluster instance
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The identifier of the certificate authority (CA) certificate for the DB instance.
     */
    public val caCertIdentifier: Output<String>
        get() = javaResource.caCertIdentifier().applyValue({ args0 -> args0 })

    /**
     * The identifier of the `aws.docdb.Cluster` in which to launch this instance.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Copy all DB instance `tags` to snapshots. Default is `false`.
     */
    public val copyTagsToSnapshot: Output<Boolean>?
        get() = javaResource.copyTagsToSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DB subnet group to associate with this DB instance.
     */
    public val dbSubnetGroupName: Output<String>
        get() = javaResource.dbSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * The region-unique, immutable identifier for the DB instance.
     */
    public val dbiResourceId: Output<String>
        get() = javaResource.dbiResourceId().applyValue({ args0 -> args0 })

    /**
     * A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
     */
    public val enablePerformanceInsights: Output<Boolean>?
        get() = javaResource.enablePerformanceInsights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS address for this instance. May not be writable
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
     */
    public val engine: Output<String>?
        get() = javaResource.engine().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The database engine version
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    public val identifierPrefix: Output<String>
        get() = javaResource.identifierPrefix().applyValue({ args0 -> args0 })

    /**
     * The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
     * DocumentDB currently supports the below instance classes.
     * Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
     * - db.r6g.large
     * - db.r6g.xlarge
     * - db.r6g.2xlarge
     * - db.r6g.4xlarge
     * - db.r6g.8xlarge
     * - db.r6g.12xlarge
     * - db.r6g.16xlarge
     * - db.r5.large
     * - db.r5.xlarge
     * - db.r5.2xlarge
     * - db.r5.4xlarge
     * - db.r5.12xlarge
     * - db.r5.24xlarge
     * - db.r4.large
     * - db.r4.xlarge
     * - db.r4.2xlarge
     * - db.r4.4xlarge
     * - db.r4.8xlarge
     * - db.r4.16xlarge
     * - db.t4g.medium
     * - db.t3.medium
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key if one is set to the cluster.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
     */
    public val performanceInsightsKmsKeyId: Output<String>
        get() = javaResource.performanceInsightsKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The database port
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The daily time range during which automated backups are created if automated backups are enabled.
     */
    public val preferredBackupWindow: Output<String>
        get() = javaResource.preferredBackupWindow().applyValue({ args0 -> args0 })

    /**
     * The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    public val promotionTier: Output<Int>?
        get() = javaResource.promotionTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val publiclyAccessible: Output<Boolean>
        get() = javaResource.publiclyAccessible().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB cluster is encrypted.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     */
    public val writer: Output<Boolean>
        get() = javaResource.writer().applyValue({ args0 -> args0 })
}

public object ClusterInstanceMapper : ResourceMapper<ClusterInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.docdb.ClusterInstance::class == javaResource::class

    override fun map(javaResource: Resource): ClusterInstance = ClusterInstance(
        javaResource as
            com.pulumi.aws.docdb.ClusterInstance,
    )
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterInstance].
 */
public suspend fun clusterInstance(
    name: String,
    block: suspend ClusterInstanceResourceBuilder.() -> Unit,
): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterInstance(name: String): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
