@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ClusterSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a DocumentDB database cluster snapshot for DocumentDB clusters.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.ClusterSnapshot("example", {
 *     dbClusterIdentifier: exampleAwsDocdbCluster.id,
 *     dbClusterSnapshotIdentifier: "resourcetestsnapshot1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.ClusterSnapshot("example",
 *     db_cluster_identifier=example_aws_docdb_cluster["id"],
 *     db_cluster_snapshot_identifier="resourcetestsnapshot1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.ClusterSnapshot("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsDocdbCluster.Id,
 *         DbClusterSnapshotIdentifier = "resourcetestsnapshot1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := docdb.NewClusterSnapshot(ctx, "example", &docdb.ClusterSnapshotArgs{
 * 			DbClusterIdentifier:         pulumi.Any(exampleAwsDocdbCluster.Id),
 * 			DbClusterSnapshotIdentifier: pulumi.String("resourcetestsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ClusterSnapshot;
 * import com.pulumi.aws.docdb.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(exampleAwsDocdbCluster.id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:ClusterSnapshot
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsDocdbCluster.id}
 *       dbClusterSnapshotIdentifier: resourcetestsnapshot1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_docdb_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:docdb/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 * @property dbClusterIdentifier The DocumentDB Cluster Identifier from which to take the snapshot.
 * @property dbClusterSnapshotIdentifier The Identifier for the snapshot.
 */
public data class ClusterSnapshotArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbClusterSnapshotIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ClusterSnapshotArgs =
        com.pulumi.aws.docdb.ClusterSnapshotArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbClusterSnapshotIdentifier: Output<String>? = null

    /**
     * @param value The DocumentDB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("hqbcuqdvhqacwuel")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("ygfyxkostmbcdvjc")
    public suspend fun dbClusterSnapshotIdentifier(`value`: Output<String>) {
        this.dbClusterSnapshotIdentifier = value
    }

    /**
     * @param value The DocumentDB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("pcngvymkqhpffcad")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("mkslpnbqobswldcv")
    public suspend fun dbClusterSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterSnapshotIdentifier = mapped
    }

    internal fun build(): ClusterSnapshotArgs = ClusterSnapshotArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
    )
}
