@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.DocdbFunctions.getEngineVersionPlain
import com.pulumi.aws.docdb.DocdbFunctions.getOrderableDbInstancePlain
import com.pulumi.aws.docdb.kotlin.inputs.GetEngineVersionPlainArgs
import com.pulumi.aws.docdb.kotlin.inputs.GetEngineVersionPlainArgsBuilder
import com.pulumi.aws.docdb.kotlin.inputs.GetOrderableDbInstancePlainArgs
import com.pulumi.aws.docdb.kotlin.inputs.GetOrderableDbInstancePlainArgsBuilder
import com.pulumi.aws.docdb.kotlin.outputs.GetEngineVersionResult
import com.pulumi.aws.docdb.kotlin.outputs.GetOrderableDbInstanceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.docdb.kotlin.outputs.GetEngineVersionResult.Companion.toKotlin as getEngineVersionResultToKotlin
import com.pulumi.aws.docdb.kotlin.outputs.GetOrderableDbInstanceResult.Companion.toKotlin as getOrderableDbInstanceResultToKotlin

public object DocdbFunctions {
    /**
     * Information about a DocumentDB engine version.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.docdb.getEngineVersion({
     *     version: "3.6.0",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.docdb.get_engine_version(version="3.6.0")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.DocDB.GetEngineVersion.Invoke(new()
     *     {
     *         Version = "3.6.0",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := docdb.GetEngineVersion(ctx, &docdb.GetEngineVersionArgs{
     * 			Version: pulumi.StringRef("3.6.0"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.docdb.DocdbFunctions;
     * import com.pulumi.aws.docdb.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DocdbFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .version("3.6.0")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:docdb:getEngineVersion
     *       Arguments:
     *         version: 3.6.0
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEngineVersion.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: GetEngineVersionPlainArgs): GetEngineVersionResult =
        getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())

    /**
     * @see [getEngineVersion].
     * @param engine DB engine. (Default: `docdb`)
     * @param parameterGroupFamily Name of a specific DB parameter group family. An example parameter group family is `docdb3.6`.
     * @param preferredVersions Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @param version Version of the DB engine. For example, `3.6.0`. If `version` and `preferred_versions` are not set, the data source will provide information for the AWS-defined default version. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(
        engine: String? = null,
        parameterGroupFamily: String? = null,
        preferredVersions: List<String>? = null,
        version: String? = null,
    ): GetEngineVersionResult {
        val argument = GetEngineVersionPlainArgs(
            engine = engine,
            parameterGroupFamily = parameterGroupFamily,
            preferredVersions = preferredVersions,
            version = version,
        )
        return getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEngineVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;docdb&#46;kotlin&#46;inputs&#46;GetEngineVersionPlainArgs].
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: suspend GetEngineVersionPlainArgsBuilder.() -> Unit): GetEngineVersionResult {
        val builder = GetEngineVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEngineVersionResultToKotlin(getEngineVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about DocumentDB orderable DB instances.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.docdb.getOrderableDbInstance({
     *     engine: "docdb",
     *     engineVersion: "3.6.0",
     *     licenseModel: "na",
     *     preferredInstanceClasses: [
     *         "db.r5.large",
     *         "db.r4.large",
     *         "db.t3.medium",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.docdb.get_orderable_db_instance(engine="docdb",
     *     engine_version="3.6.0",
     *     license_model="na",
     *     preferred_instance_classes=[
     *         "db.r5.large",
     *         "db.r4.large",
     *         "db.t3.medium",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.DocDB.GetOrderableDbInstance.Invoke(new()
     *     {
     *         Engine = "docdb",
     *         EngineVersion = "3.6.0",
     *         LicenseModel = "na",
     *         PreferredInstanceClasses = new[]
     *         {
     *             "db.r5.large",
     *             "db.r4.large",
     *             "db.t3.medium",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := docdb.GetOrderableDbInstance(ctx, &docdb.GetOrderableDbInstanceArgs{
     * 			Engine:        pulumi.StringRef("docdb"),
     * 			EngineVersion: pulumi.StringRef("3.6.0"),
     * 			LicenseModel:  pulumi.StringRef("na"),
     * 			PreferredInstanceClasses: []string{
     * 				"db.r5.large",
     * 				"db.r4.large",
     * 				"db.t3.medium",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.docdb.DocdbFunctions;
     * import com.pulumi.aws.docdb.inputs.GetOrderableDbInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DocdbFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
     *             .engine("docdb")
     *             .engineVersion("3.6.0")
     *             .licenseModel("na")
     *             .preferredInstanceClasses(
     *                 "db.r5.large",
     *                 "db.r4.large",
     *                 "db.t3.medium")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:docdb:getOrderableDbInstance
     *       Arguments:
     *         engine: docdb
     *         engineVersion: 3.6.0
     *         licenseModel: na
     *         preferredInstanceClasses:
     *           - db.r5.large
     *           - db.r4.large
     *           - db.t3.medium
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOrderableDbInstance.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: GetOrderableDbInstancePlainArgs): GetOrderableDbInstanceResult =
        getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())

    /**
     * @see [getOrderableDbInstance].
     * @param engine DB engine. Default: `docdb`
     * @param engineVersion Version of the DB engine.
     * @param instanceClass DB instance class. Examples of classes are `db.r5.12xlarge`, `db.r5.24xlarge`, `db.r5.2xlarge`, `db.r5.4xlarge`, `db.r5.large`, `db.r5.xlarge`, and `db.t3.medium`. (Conflicts with `preferred_instance_classes`.)
     * @param licenseModel License model. Default: `na`
     * @param preferredInstanceClasses Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
     * @param vpc Enable to show only VPC.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(
        engine: String? = null,
        engineVersion: String? = null,
        instanceClass: String? = null,
        licenseModel: String? = null,
        preferredInstanceClasses: List<String>? = null,
        vpc: Boolean? = null,
    ): GetOrderableDbInstanceResult {
        val argument = GetOrderableDbInstancePlainArgs(
            engine = engine,
            engineVersion = engineVersion,
            instanceClass = instanceClass,
            licenseModel = licenseModel,
            preferredInstanceClasses = preferredInstanceClasses,
            vpc = vpc,
        )
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableDbInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;docdb&#46;kotlin&#46;inputs&#46;GetOrderableDbInstancePlainArgs].
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: suspend GetOrderableDbInstancePlainArgsBuilder.() -> Unit): GetOrderableDbInstanceResult {
        val builder = GetOrderableDbInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(builtArgument.toJava()).await())
    }
}
