@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.kotlin.outputs.ElasticClusterTimeouts
import com.pulumi.aws.docdb.kotlin.outputs.ElasticClusterTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ElasticCluster].
 */
@PulumiTagMarker
public class ElasticClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ElasticClusterArgs = ElasticClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ElasticClusterArgsBuilder.() -> Unit) {
        val builder = ElasticClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ElasticCluster {
        val builtJavaResource = com.pulumi.aws.docdb.ElasticCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ElasticCluster(builtJavaResource)
    }
}

/**
 * Manages an AWS DocDB (DocumentDB) Elastic Cluster.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.ElasticCluster("example", {
 *     name: "my-docdb-cluster",
 *     adminUserName: "foo",
 *     adminUserPassword: "mustbeeightchars",
 *     authType: "PLAIN_TEXT",
 *     shardCapacity: 2,
 *     shardCount: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.ElasticCluster("example",
 *     name="my-docdb-cluster",
 *     admin_user_name="foo",
 *     admin_user_password="mustbeeightchars",
 *     auth_type="PLAIN_TEXT",
 *     shard_capacity=2,
 *     shard_count=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.ElasticCluster("example", new()
 *     {
 *         Name = "my-docdb-cluster",
 *         AdminUserName = "foo",
 *         AdminUserPassword = "mustbeeightchars",
 *         AuthType = "PLAIN_TEXT",
 *         ShardCapacity = 2,
 *         ShardCount = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := docdb.NewElasticCluster(ctx, "example", &docdb.ElasticClusterArgs{
 * 			Name:              pulumi.String("my-docdb-cluster"),
 * 			AdminUserName:     pulumi.String("foo"),
 * 			AdminUserPassword: pulumi.String("mustbeeightchars"),
 * 			AuthType:          pulumi.String("PLAIN_TEXT"),
 * 			ShardCapacity:     pulumi.Int(2),
 * 			ShardCount:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ElasticCluster;
 * import com.pulumi.aws.docdb.ElasticClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ElasticCluster("example", ElasticClusterArgs.builder()
 *             .name("my-docdb-cluster")
 *             .adminUserName("foo")
 *             .adminUserPassword("mustbeeightchars")
 *             .authType("PLAIN_TEXT")
 *             .shardCapacity(2)
 *             .shardCount(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:ElasticCluster
 *     properties:
 *       name: my-docdb-cluster
 *       adminUserName: foo
 *       adminUserPassword: mustbeeightchars
 *       authType: PLAIN_TEXT
 *       shardCapacity: 2
 *       shardCount: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DocDB (DocumentDB) Elastic Cluster using the `arn` argument. For example,
 * ```sh
 * $ pulumi import aws:docdb/elasticCluster:ElasticCluster example arn:aws:docdb-elastic:us-east-1:000011112222:cluster/12345678-7abc-def0-1234-56789abcdef
 * ```
 */
public class ElasticCluster internal constructor(
    override val javaResource: com.pulumi.aws.docdb.ElasticCluster,
) : KotlinCustomResource(javaResource, ElasticClusterMapper) {
    /**
     * Name of the Elastic DocumentDB cluster administrator
     */
    public val adminUserName: Output<String>
        get() = javaResource.adminUserName().applyValue({ args0 -> args0 })

    /**
     * Password for the Elastic DocumentDB cluster administrator. Can contain any printable ASCII characters. Must be at least 8 characters
     */
    public val adminUserPassword: Output<String>
        get() = javaResource.adminUserPassword().applyValue({ args0 -> args0 })

    /**
     * ARN of the DocumentDB Elastic Cluster
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication type for the Elastic DocumentDB cluster. Valid values are `PLAIN_TEXT` and `SECRET_ARN`
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * The DNS address of the DocDB instance
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * ARN of a KMS key that is used to encrypt the Elastic DocumentDB cluster. If not specified, the default encryption key that KMS creates for your account is used.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Name of the Elastic DocumentDB cluster
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Weekly time range during which system maintenance can occur in UTC. Format: `ddd:hh24:mi-ddd:hh24:mi`. If not specified, AWS will choose a random 30-minute window on a random day of the week.
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64
     */
    public val shardCapacity: Output<Int>
        get() = javaResource.shardCapacity().applyValue({ args0 -> args0 })

    /**
     * Number of shards assigned to the elastic cluster. Maximum is 32
     * The following arguments are optional:
     */
    public val shardCount: Output<Int>
        get() = javaResource.shardCount().applyValue({ args0 -> args0 })

    /**
     * IDs of subnets in which the Elastic DocumentDB Cluster operates.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ElasticClusterTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of VPC security groups to associate with the Elastic DocumentDB Cluster
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ElasticClusterMapper : ResourceMapper<ElasticCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.docdb.ElasticCluster::class == javaResource::class

    override fun map(javaResource: Resource): ElasticCluster = ElasticCluster(
        javaResource as
            com.pulumi.aws.docdb.ElasticCluster,
    )
}

/**
 * @see [ElasticCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ElasticCluster].
 */
public suspend fun elasticCluster(
    name: String,
    block: suspend ElasticClusterResourceBuilder.() -> Unit,
): ElasticCluster {
    val builder = ElasticClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ElasticCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun elasticCluster(name: String): ElasticCluster {
    val builder = ElasticClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
