@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ElasticClusterArgs.builder
import com.pulumi.aws.docdb.kotlin.inputs.ElasticClusterTimeoutsArgs
import com.pulumi.aws.docdb.kotlin.inputs.ElasticClusterTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DocDB (DocumentDB) Elastic Cluster.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.ElasticCluster("example", {
 *     name: "my-docdb-cluster",
 *     adminUserName: "foo",
 *     adminUserPassword: "mustbeeightchars",
 *     authType: "PLAIN_TEXT",
 *     shardCapacity: 2,
 *     shardCount: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.ElasticCluster("example",
 *     name="my-docdb-cluster",
 *     admin_user_name="foo",
 *     admin_user_password="mustbeeightchars",
 *     auth_type="PLAIN_TEXT",
 *     shard_capacity=2,
 *     shard_count=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.ElasticCluster("example", new()
 *     {
 *         Name = "my-docdb-cluster",
 *         AdminUserName = "foo",
 *         AdminUserPassword = "mustbeeightchars",
 *         AuthType = "PLAIN_TEXT",
 *         ShardCapacity = 2,
 *         ShardCount = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := docdb.NewElasticCluster(ctx, "example", &docdb.ElasticClusterArgs{
 * 			Name:              pulumi.String("my-docdb-cluster"),
 * 			AdminUserName:     pulumi.String("foo"),
 * 			AdminUserPassword: pulumi.String("mustbeeightchars"),
 * 			AuthType:          pulumi.String("PLAIN_TEXT"),
 * 			ShardCapacity:     pulumi.Int(2),
 * 			ShardCount:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ElasticCluster;
 * import com.pulumi.aws.docdb.ElasticClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ElasticCluster("example", ElasticClusterArgs.builder()
 *             .name("my-docdb-cluster")
 *             .adminUserName("foo")
 *             .adminUserPassword("mustbeeightchars")
 *             .authType("PLAIN_TEXT")
 *             .shardCapacity(2)
 *             .shardCount(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:ElasticCluster
 *     properties:
 *       name: my-docdb-cluster
 *       adminUserName: foo
 *       adminUserPassword: mustbeeightchars
 *       authType: PLAIN_TEXT
 *       shardCapacity: 2
 *       shardCount: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DocDB (DocumentDB) Elastic Cluster using the `arn` argument. For example,
 * ```sh
 * $ pulumi import aws:docdb/elasticCluster:ElasticCluster example arn:aws:docdb-elastic:us-east-1:000011112222:cluster/12345678-7abc-def0-1234-56789abcdef
 * ```
 * @property adminUserName Name of the Elastic DocumentDB cluster administrator
 * @property adminUserPassword Password for the Elastic DocumentDB cluster administrator. Can contain any printable ASCII characters. Must be at least 8 characters
 * @property authType Authentication type for the Elastic DocumentDB cluster. Valid values are `PLAIN_TEXT` and `SECRET_ARN`
 * @property kmsKeyId ARN of a KMS key that is used to encrypt the Elastic DocumentDB cluster. If not specified, the default encryption key that KMS creates for your account is used.
 * @property name Name of the Elastic DocumentDB cluster
 * @property preferredMaintenanceWindow Weekly time range during which system maintenance can occur in UTC. Format: `ddd:hh24:mi-ddd:hh24:mi`. If not specified, AWS will choose a random 30-minute window on a random day of the week.
 * @property shardCapacity Number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64
 * @property shardCount Number of shards assigned to the elastic cluster. Maximum is 32
 * The following arguments are optional:
 * @property subnetIds IDs of subnets in which the Elastic DocumentDB Cluster operates.
 * @property tags A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property vpcSecurityGroupIds List of VPC security groups to associate with the Elastic DocumentDB Cluster
 */
public data class ElasticClusterArgs(
    public val adminUserName: Output<String>? = null,
    public val adminUserPassword: Output<String>? = null,
    public val authType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val shardCapacity: Output<Int>? = null,
    public val shardCount: Output<Int>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ElasticClusterTimeoutsArgs>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ElasticClusterArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ElasticClusterArgs =
        com.pulumi.aws.docdb.ElasticClusterArgs.builder()
            .adminUserName(adminUserName?.applyValue({ args0 -> args0 }))
            .adminUserPassword(adminUserPassword?.applyValue({ args0 -> args0 }))
            .authType(authType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .shardCapacity(shardCapacity?.applyValue({ args0 -> args0 }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ElasticClusterArgs].
 */
@PulumiTagMarker
public class ElasticClusterArgsBuilder internal constructor() {
    private var adminUserName: Output<String>? = null

    private var adminUserPassword: Output<String>? = null

    private var authType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var shardCapacity: Output<Int>? = null

    private var shardCount: Output<Int>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ElasticClusterTimeoutsArgs>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value Name of the Elastic DocumentDB cluster administrator
     */
    @JvmName("evqkcecqqcwjoxfn")
    public suspend fun adminUserName(`value`: Output<String>) {
        this.adminUserName = value
    }

    /**
     * @param value Password for the Elastic DocumentDB cluster administrator. Can contain any printable ASCII characters. Must be at least 8 characters
     */
    @JvmName("guvtimumarvykmyq")
    public suspend fun adminUserPassword(`value`: Output<String>) {
        this.adminUserPassword = value
    }

    /**
     * @param value Authentication type for the Elastic DocumentDB cluster. Valid values are `PLAIN_TEXT` and `SECRET_ARN`
     */
    @JvmName("tjiytxllobmesreg")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value ARN of a KMS key that is used to encrypt the Elastic DocumentDB cluster. If not specified, the default encryption key that KMS creates for your account is used.
     */
    @JvmName("akfxxucfyriqmdfa")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the Elastic DocumentDB cluster
     */
    @JvmName("bxpmkhhjivxpjdqp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Weekly time range during which system maintenance can occur in UTC. Format: `ddd:hh24:mi-ddd:hh24:mi`. If not specified, AWS will choose a random 30-minute window on a random day of the week.
     */
    @JvmName("wcdnkarbntnvoydc")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64
     */
    @JvmName("xmyevyaeccoxwnyp")
    public suspend fun shardCapacity(`value`: Output<Int>) {
        this.shardCapacity = value
    }

    /**
     * @param value Number of shards assigned to the elastic cluster. Maximum is 32
     * The following arguments are optional:
     */
    @JvmName("vqxcttwiwkyfxykx")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value IDs of subnets in which the Elastic DocumentDB Cluster operates.
     */
    @JvmName("bbfmyqfkeqfkrdgn")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("qgarbkkpekfwvrye")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values IDs of subnets in which the Elastic DocumentDB Cluster operates.
     */
    @JvmName("xwoykystjxdgyodo")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ttfdhjdrekhbcfgs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("osmufvxdlxhxytcb")
    public suspend fun timeouts(`value`: Output<ElasticClusterTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value List of VPC security groups to associate with the Elastic DocumentDB Cluster
     */
    @JvmName("alrcbcvhaydnokru")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("vywhddvhkskxhqcq")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC security groups to associate with the Elastic DocumentDB Cluster
     */
    @JvmName("qhrfdunwdgigurni")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value Name of the Elastic DocumentDB cluster administrator
     */
    @JvmName("hvonfylgbxmktmdo")
    public suspend fun adminUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserName = mapped
    }

    /**
     * @param value Password for the Elastic DocumentDB cluster administrator. Can contain any printable ASCII characters. Must be at least 8 characters
     */
    @JvmName("ohgyiprosfqptipv")
    public suspend fun adminUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserPassword = mapped
    }

    /**
     * @param value Authentication type for the Elastic DocumentDB cluster. Valid values are `PLAIN_TEXT` and `SECRET_ARN`
     */
    @JvmName("gxnlbnbnpialtvpy")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value ARN of a KMS key that is used to encrypt the Elastic DocumentDB cluster. If not specified, the default encryption key that KMS creates for your account is used.
     */
    @JvmName("hynnjhunwjhanffc")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the Elastic DocumentDB cluster
     */
    @JvmName("dyatswsmqiuqpibg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Weekly time range during which system maintenance can occur in UTC. Format: `ddd:hh24:mi-ddd:hh24:mi`. If not specified, AWS will choose a random 30-minute window on a random day of the week.
     */
    @JvmName("rrxiybfbhsvvfywb")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64
     */
    @JvmName("qvkunhplyqmmuigq")
    public suspend fun shardCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCapacity = mapped
    }

    /**
     * @param value Number of shards assigned to the elastic cluster. Maximum is 32
     * The following arguments are optional:
     */
    @JvmName("attmrcpadpihnlga")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    /**
     * @param value IDs of subnets in which the Elastic DocumentDB Cluster operates.
     */
    @JvmName("vddcviunmdthqgoq")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values IDs of subnets in which the Elastic DocumentDB Cluster operates.
     */
    @JvmName("gnsflhmnkkdmqbix")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("itwiclsqimvuluat")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xmulriyaooxtjsxo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("tyhhfiwpaogacroh")
    public suspend fun timeouts(`value`: ElasticClusterTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ffyxjeaiejmboyem")
    public suspend fun timeouts(argument: suspend ElasticClusterTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ElasticClusterTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value List of VPC security groups to associate with the Elastic DocumentDB Cluster
     */
    @JvmName("dlnslxftuneejlco")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of VPC security groups to associate with the Elastic DocumentDB Cluster
     */
    @JvmName("lcvptpuitotufnuc")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ElasticClusterArgs = ElasticClusterArgs(
        adminUserName = adminUserName,
        adminUserPassword = adminUserPassword,
        authType = authType,
        kmsKeyId = kmsKeyId,
        name = name,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        shardCapacity = shardCapacity,
        shardCount = shardCount,
        subnetIds = subnetIds,
        tags = tags,
        timeouts = timeouts,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
