@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DocumentDB event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.Cluster("example", {
 *     clusterIdentifier: "example",
 *     availabilityZones: [
 *         available.names[0],
 *         available.names[1],
 *         available.names[2],
 *     ],
 *     masterUsername: "foo",
 *     masterPassword: "mustbeeightcharaters",
 *     skipFinalSnapshot: true,
 * });
 * const exampleTopic = new aws.sns.Topic("example", {name: "example-events"});
 * const exampleEventSubscription = new aws.docdb.EventSubscription("example", {
 *     name: "example",
 *     enabled: true,
 *     eventCategories: [
 *         "creation",
 *         "failure",
 *     ],
 *     sourceType: "db-cluster",
 *     sourceIds: [example&#46;id],
 *     snsTopicArn: exampleTopic.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.Cluster("example",
 *     cluster_identifier="example",
 *     availability_zones=[
 *         available["names"],
 *         available["names"],
 *         available["names"],
 *     ],
 *     master_username="foo",
 *     master_password="mustbeeightcharaters",
 *     skip_final_snapshot=True)
 * example_topic = aws.sns.Topic("example", name="example-events")
 * example_event_subscription = aws.docdb.EventSubscription("example",
 *     name="example",
 *     enabled=True,
 *     event_categories=[
 *         "creation",
 *         "failure",
 *     ],
 *     source_type="db-cluster",
 *     source_ids=[example&#46;id],
 *     sns_topic_arn=example_topic.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "example",
 *         AvailabilityZones = new[]
 *         {
 *             available.Names[0],
 *             available.Names[1],
 *             available.Names[2],
 *         },
 *         MasterUsername = "foo",
 *         MasterPassword = "mustbeeightcharaters",
 *         SkipFinalSnapshot = true,
 *     });
 *     var exampleTopic = new Aws.Sns.Topic("example", new()
 *     {
 *         Name = "example-events",
 *     });
 *     var exampleEventSubscription = new Aws.DocDB.EventSubscription("example", new()
 *     {
 *         Name = "example",
 *         Enabled = true,
 *         EventCategories = new[]
 *         {
 *             "creation",
 *             "failure",
 *         },
 *         SourceType = "db-cluster",
 *         SourceIds = new[]
 *         {
 *             example.Id,
 *         },
 *         SnsTopicArn = exampleTopic.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := docdb.NewCluster(ctx, "example", &docdb.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("example"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				available.Names[0],
 * 				available.Names[1],
 * 				available.Names[2],
 * 			},
 * 			MasterUsername:    pulumi.String("foo"),
 * 			MasterPassword:    pulumi.String("mustbeeightcharaters"),
 * 			SkipFinalSnapshot: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTopic, err := sns.NewTopic(ctx, "example", &sns.TopicArgs{
 * 			Name: pulumi.String("example-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = docdb.NewEventSubscription(ctx, "example", &docdb.EventSubscriptionArgs{
 * 			Name:    pulumi.String("example"),
 * 			Enabled: pulumi.Bool(true),
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("creation"),
 * 				pulumi.String("failure"),
 * 			},
 * 			SourceType: pulumi.String("db-cluster"),
 * 			SourceIds: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 			SnsTopicArn: exampleTopic.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.docdb.EventSubscription;
 * import com.pulumi.aws.docdb.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .clusterIdentifier("example")
 *             .availabilityZones(
 *                 available.names()[0],
 *                 available.names()[1],
 *                 available.names()[2])
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleTopic = new Topic("exampleTopic", TopicArgs.builder()
 *             .name("example-events")
 *             .build());
 *         var exampleEventSubscription = new EventSubscription("exampleEventSubscription", EventSubscriptionArgs.builder()
 *             .name("example")
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .sourceType("db-cluster")
 *             .sourceIds(example.id())
 *             .snsTopicArn(exampleTopic.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:Cluster
 *     properties:
 *       clusterIdentifier: example
 *       availabilityZones:
 *         - ${available.names[0]}
 *         - ${available.names[1]}
 *         - ${available.names[2]}
 *       masterUsername: foo
 *       masterPassword: mustbeeightcharaters
 *       skipFinalSnapshot: true
 *   exampleTopic:
 *     type: aws:sns:Topic
 *     name: example
 *     properties:
 *       name: example-events
 *   exampleEventSubscription:
 *     type: aws:docdb:EventSubscription
 *     name: example
 *     properties:
 *       name: example
 *       enabled: true
 *       eventCategories:
 *         - creation
 *         - failure
 *       sourceType: db-cluster
 *       sourceIds:
 *         - ${example.id}
 *       snsTopicArn: ${exampleTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DocumentDB Event Subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:docdb/eventSubscription:EventSubscription example event-sub
 * ```
 * @property enabled A boolean flag to enable/disable the subscription. Defaults to true.
 * @property eventCategories A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
 * @property name The name of the DocumentDB event subscription. By default generated by this provider.
 * @property namePrefix The name of the DocumentDB event subscription. Conflicts with `name`.
 * @property snsTopicArn
 * @property sourceIds A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
 * @property sourceType The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.docdb.EventSubscriptionArgs =
        com.pulumi.aws.docdb.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("vfgcviamwpmvvhdv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("fcftlnqibfenmwme")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("eulgggxqaixllrmb")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("kcdjrlrghswpgnnb")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value The name of the DocumentDB event subscription. By default generated by this provider.
     */
    @JvmName("wbnaoxrktydceotr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the DocumentDB event subscription. Conflicts with `name`.
     */
    @JvmName("rfhfbqahnnmpvejc")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("koucctpntcbjripq")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("srnemxrwgxprsxis")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("kiksbvifcqhfyhoq")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("olfgqtoakoxqhhbo")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("knakvrakpuffwstt")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uommtlnbtxrfyqga")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("lhnuswonavlilyog")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("igpuwdspbplkvwpg")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("ltoaciesndjyqlpc")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value The name of the DocumentDB event subscription. By default generated by this provider.
     */
    @JvmName("ehwxffskkhanhogm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the DocumentDB event subscription. Conflicts with `name`.
     */
    @JvmName("rigkoolqrsyhfift")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfpokvueowlpmmbj")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("kfvhyovqkmucvbya")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("ucvqkardxmmuqrna")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("loxmiljwyfneljij")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tmnfsjlxpbwvndbu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ttcrctaografjhbx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        namePrefix = namePrefix,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
