@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.GlobalClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an DocumentDB Global Cluster. A global cluster consists of one primary region and up to five read-only secondary regions. You issue write operations directly to the primary cluster in the primary region and Amazon DocumentDB automatically replicates the data to the secondary regions using dedicated infrastructure.
 * More information about DocumentDB Global Clusters can be found in the [DocumentDB Developer Guide](https://docs.aws.amazon.com/documentdb/latest/developerguide/global-clusters.html).
 * ## Example Usage
 * ### New DocumentDB Global Cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.GlobalCluster("example", {
 *     globalClusterIdentifier: "global-test",
 *     engine: "docdb",
 *     engineVersion: "4.0.0",
 * });
 * const primary = new aws.docdb.Cluster("primary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-primary-cluster",
 *     masterUsername: "username",
 *     masterPassword: "somepass123",
 *     globalClusterIdentifier: example.id,
 *     dbSubnetGroupName: "default",
 * });
 * const primaryClusterInstance = new aws.docdb.ClusterInstance("primary", {
 *     engine: example.engine,
 *     identifier: "test-primary-cluster-instance",
 *     clusterIdentifier: primary.id,
 *     instanceClass: "db.r5.large",
 * });
 * const secondary = new aws.docdb.Cluster("secondary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-secondary-cluster",
 *     globalClusterIdentifier: example.id,
 *     dbSubnetGroupName: "default",
 * }, {
 *     dependsOn: [primary],
 * });
 * const secondaryClusterInstance = new aws.docdb.ClusterInstance("secondary", {
 *     engine: example.engine,
 *     identifier: "test-secondary-cluster-instance",
 *     clusterIdentifier: secondary.id,
 *     instanceClass: "db.r5.large",
 * }, {
 *     dependsOn: [primaryClusterInstance],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.GlobalCluster("example",
 *     global_cluster_identifier="global-test",
 *     engine="docdb",
 *     engine_version="4.0.0")
 * primary = aws.docdb.Cluster("primary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-primary-cluster",
 *     master_username="username",
 *     master_password="somepass123",
 *     global_cluster_identifier=example.id,
 *     db_subnet_group_name="default")
 * primary_cluster_instance = aws.docdb.ClusterInstance("primary",
 *     engine=example.engine,
 *     identifier="test-primary-cluster-instance",
 *     cluster_identifier=primary.id,
 *     instance_class="db.r5.large")
 * secondary = aws.docdb.Cluster("secondary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-secondary-cluster",
 *     global_cluster_identifier=example.id,
 *     db_subnet_group_name="default",
 *     opts = pulumi.ResourceOptions(depends_on=[primary]))
 * secondary_cluster_instance = aws.docdb.ClusterInstance("secondary",
 *     engine=example.engine,
 *     identifier="test-secondary-cluster-instance",
 *     cluster_identifier=secondary.id,
 *     instance_class="db.r5.large",
 *     opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.GlobalCluster("example", new()
 *     {
 *         GlobalClusterIdentifier = "global-test",
 *         Engine = "docdb",
 *         EngineVersion = "4.0.0",
 *     });
 *     var primary = new Aws.DocDB.Cluster("primary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-primary-cluster",
 *         MasterUsername = "username",
 *         MasterPassword = "somepass123",
 *         GlobalClusterIdentifier = example.Id,
 *         DbSubnetGroupName = "default",
 *     });
 *     var primaryClusterInstance = new Aws.DocDB.ClusterInstance("primary", new()
 *     {
 *         Engine = example.Engine,
 *         Identifier = "test-primary-cluster-instance",
 *         ClusterIdentifier = primary.Id,
 *         InstanceClass = "db.r5.large",
 *     });
 *     var secondary = new Aws.DocDB.Cluster("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-secondary-cluster",
 *         GlobalClusterIdentifier = example.Id,
 *         DbSubnetGroupName = "default",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primary,
 *         },
 *     });
 *     var secondaryClusterInstance = new Aws.DocDB.ClusterInstance("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         Identifier = "test-secondary-cluster-instance",
 *         ClusterIdentifier = secondary.Id,
 *         InstanceClass = "db.r5.large",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primaryClusterInstance,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := docdb.NewGlobalCluster(ctx, "example", &docdb.GlobalClusterArgs{
 * 			GlobalClusterIdentifier: pulumi.String("global-test"),
 * 			Engine:                  pulumi.String("docdb"),
 * 			EngineVersion:           pulumi.String("4.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primary, err := docdb.NewCluster(ctx, "primary", &docdb.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-primary-cluster"),
 * 			MasterUsername:          pulumi.String("username"),
 * 			MasterPassword:          pulumi.String("somepass123"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primaryClusterInstance, err := docdb.NewClusterInstance(ctx, "primary", &docdb.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			Identifier:        pulumi.String("test-primary-cluster-instance"),
 * 			ClusterIdentifier: primary.ID(),
 * 			InstanceClass:     pulumi.String("db.r5.large"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		secondary, err := docdb.NewCluster(ctx, "secondary", &docdb.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-secondary-cluster"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primary,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = docdb.NewClusterInstance(ctx, "secondary", &docdb.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			Identifier:        pulumi.String("test-secondary-cluster-instance"),
 * 			ClusterIdentifier: secondary.ID(),
 * 			InstanceClass:     pulumi.String("db.r5.large"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primaryClusterInstance,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.GlobalCluster;
 * import com.pulumi.aws.docdb.GlobalClusterArgs;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.docdb.ClusterInstance;
 * import com.pulumi.aws.docdb.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("docdb")
 *             .engineVersion("4.0.0")
 *             .build());
 *         var primary = new Cluster("primary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primary.id())
 *             .instanceClass("db.r5.large")
 *             .build());
 *         var secondary = new Cluster("secondary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primary)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondary.id())
 *             .instanceClass("db.r5.large")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:GlobalCluster
 *     properties:
 *       globalClusterIdentifier: global-test
 *       engine: docdb
 *       engineVersion: 4.0.0
 *   primary:
 *     type: aws:docdb:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-primary-cluster
 *       masterUsername: username
 *       masterPassword: somepass123
 *       globalClusterIdentifier: ${example.id}
 *       dbSubnetGroupName: default
 *   primaryClusterInstance:
 *     type: aws:docdb:ClusterInstance
 *     name: primary
 *     properties:
 *       engine: ${example.engine}
 *       identifier: test-primary-cluster-instance
 *       clusterIdentifier: ${primary.id}
 *       instanceClass: db.r5.large
 *   secondary:
 *     type: aws:docdb:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-secondary-cluster
 *       globalClusterIdentifier: ${example.id}
 *       dbSubnetGroupName: default
 *     options:
 *       dependson:
 *         - ${primary}
 *   secondaryClusterInstance:
 *     type: aws:docdb:ClusterInstance
 *     name: secondary
 *     properties:
 *       engine: ${example.engine}
 *       identifier: test-secondary-cluster-instance
 *       clusterIdentifier: ${secondary.id}
 *       instanceClass: db.r5.large
 *     options:
 *       dependson:
 *         - ${primaryClusterInstance}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### New Global Cluster From Existing DB Cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.docdb.Cluster("example", {});
 * const exampleGlobalCluster = new aws.docdb.GlobalCluster("example", {
 *     globalClusterIdentifier: "example",
 *     sourceDbClusterIdentifier: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.docdb.Cluster("example")
 * example_global_cluster = aws.docdb.GlobalCluster("example",
 *     global_cluster_identifier="example",
 *     source_db_cluster_identifier=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DocDB.Cluster("example");
 *     var exampleGlobalCluster = new Aws.DocDB.GlobalCluster("example", new()
 *     {
 *         GlobalClusterIdentifier = "example",
 *         SourceDbClusterIdentifier = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/docdb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := docdb.NewCluster(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = docdb.NewGlobalCluster(ctx, "example", &docdb.GlobalClusterArgs{
 * 			GlobalClusterIdentifier:   pulumi.String("example"),
 * 			SourceDbClusterIdentifier: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.GlobalCluster;
 * import com.pulumi.aws.docdb.GlobalClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example");
 *         var exampleGlobalCluster = new GlobalCluster("exampleGlobalCluster", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("example")
 *             .sourceDbClusterIdentifier(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:docdb:Cluster
 *   exampleGlobalCluster:
 *     type: aws:docdb:GlobalCluster
 *     name: example
 *     properties:
 *       globalClusterIdentifier: example
 *       sourceDbClusterIdentifier: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_docdb_global_cluster` using the Global Cluster identifier. For example:
 * ```sh
 * $ pulumi import aws:docdb/globalCluster:GlobalCluster example example
 * ```
 * Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property databaseName Name for an automatically created database on cluster creation.
 * @property deletionProtection If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
 * @property engine Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
 * @property engineVersion Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
 * * **NOTE:** Upgrading major versions is not supported.
 * @property globalClusterIdentifier The global cluster identifier.
 * @property sourceDbClusterIdentifier Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
 * @property storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
 */
public data class GlobalClusterArgs(
    public val databaseName: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val globalClusterIdentifier: Output<String>? = null,
    public val sourceDbClusterIdentifier: Output<String>? = null,
    public val storageEncrypted: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.GlobalClusterArgs> {
    override fun toJava(): com.pulumi.aws.docdb.GlobalClusterArgs =
        com.pulumi.aws.docdb.GlobalClusterArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .globalClusterIdentifier(globalClusterIdentifier?.applyValue({ args0 -> args0 }))
            .sourceDbClusterIdentifier(sourceDbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .storageEncrypted(storageEncrypted?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalClusterArgs].
 */
@PulumiTagMarker
public class GlobalClusterArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var globalClusterIdentifier: Output<String>? = null

    private var sourceDbClusterIdentifier: Output<String>? = null

    private var storageEncrypted: Output<Boolean>? = null

    /**
     * @param value Name for an automatically created database on cluster creation.
     */
    @JvmName("pdejbhpcnupijgda")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    @JvmName("myhioxlsynbodyjf")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
     */
    @JvmName("jlycwgyyboydwcmd")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
     * * **NOTE:** Upgrading major versions is not supported.
     */
    @JvmName("adfjurrvbsphfsoi")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The global cluster identifier.
     */
    @JvmName("betbhkvrmklxmvan")
    public suspend fun globalClusterIdentifier(`value`: Output<String>) {
        this.globalClusterIdentifier = value
    }

    /**
     * @param value Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    @JvmName("xlxjhbjyawhkxmkf")
    public suspend fun sourceDbClusterIdentifier(`value`: Output<String>) {
        this.sourceDbClusterIdentifier = value
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("rbspjxlkgxjlkxcq")
    public suspend fun storageEncrypted(`value`: Output<Boolean>) {
        this.storageEncrypted = value
    }

    /**
     * @param value Name for an automatically created database on cluster creation.
     */
    @JvmName("ihwvfddyvtkovape")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    @JvmName("lkhokablemkbyqgt")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
     */
    @JvmName("leyouebqxuunimxt")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
     * * **NOTE:** Upgrading major versions is not supported.
     */
    @JvmName("mpyaersviukfsule")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The global cluster identifier.
     */
    @JvmName("cmyxxtlovhtaxjqx")
    public suspend fun globalClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalClusterIdentifier = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    @JvmName("sujvwsawlywjeguf")
    public suspend fun sourceDbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbClusterIdentifier = mapped
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("bxjnytjqjsppbdew")
    public suspend fun storageEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEncrypted = mapped
    }

    internal fun build(): GlobalClusterArgs = GlobalClusterArgs(
        databaseName = databaseName,
        deletionProtection = deletionProtection,
        engine = engine,
        engineVersion = engineVersion,
        globalClusterIdentifier = globalClusterIdentifier,
        sourceDbClusterIdentifier = sourceDbClusterIdentifier,
        storageEncrypted = storageEncrypted,
    )
}
