@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.inputs

import com.pulumi.aws.docdb.inputs.ClusterRestoreToPointInTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property restoreToTime The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
 * @property restoreType The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
 * @property sourceClusterIdentifier The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
 * @property useLatestRestorableTime A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
 */
public data class ClusterRestoreToPointInTimeArgs(
    public val restoreToTime: Output<String>? = null,
    public val restoreType: Output<String>? = null,
    public val sourceClusterIdentifier: Output<String>,
    public val useLatestRestorableTime: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.inputs.ClusterRestoreToPointInTimeArgs> {
    override fun toJava(): com.pulumi.aws.docdb.inputs.ClusterRestoreToPointInTimeArgs =
        com.pulumi.aws.docdb.inputs.ClusterRestoreToPointInTimeArgs.builder()
            .restoreToTime(restoreToTime?.applyValue({ args0 -> args0 }))
            .restoreType(restoreType?.applyValue({ args0 -> args0 }))
            .sourceClusterIdentifier(sourceClusterIdentifier.applyValue({ args0 -> args0 }))
            .useLatestRestorableTime(useLatestRestorableTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterRestoreToPointInTimeArgs].
 */
@PulumiTagMarker
public class ClusterRestoreToPointInTimeArgsBuilder internal constructor() {
    private var restoreToTime: Output<String>? = null

    private var restoreType: Output<String>? = null

    private var sourceClusterIdentifier: Output<String>? = null

    private var useLatestRestorableTime: Output<Boolean>? = null

    /**
     * @param value The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
     */
    @JvmName("bjvcmlfdqltnjaqt")
    public suspend fun restoreToTime(`value`: Output<String>) {
        this.restoreToTime = value
    }

    /**
     * @param value The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
     */
    @JvmName("vycbnpbjxnpeyajv")
    public suspend fun restoreType(`value`: Output<String>) {
        this.restoreType = value
    }

    /**
     * @param value The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
     */
    @JvmName("wxgjpejkyiuhhpua")
    public suspend fun sourceClusterIdentifier(`value`: Output<String>) {
        this.sourceClusterIdentifier = value
    }

    /**
     * @param value A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
     */
    @JvmName("vkbeomkfbvhpdekt")
    public suspend fun useLatestRestorableTime(`value`: Output<Boolean>) {
        this.useLatestRestorableTime = value
    }

    /**
     * @param value The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
     */
    @JvmName("vniltddoshtocjfr")
    public suspend fun restoreToTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreToTime = mapped
    }

    /**
     * @param value The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
     */
    @JvmName("cngadbqhvjirlyos")
    public suspend fun restoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreType = mapped
    }

    /**
     * @param value The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
     */
    @JvmName("fjxkxnqknjsjfkii")
    public suspend fun sourceClusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceClusterIdentifier = mapped
    }

    /**
     * @param value A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
     */
    @JvmName("cfyyepitlhqrghcs")
    public suspend fun useLatestRestorableTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLatestRestorableTime = mapped
    }

    internal fun build(): ClusterRestoreToPointInTimeArgs = ClusterRestoreToPointInTimeArgs(
        restoreToTime = restoreToTime,
        restoreType = restoreType,
        sourceClusterIdentifier = sourceClusterIdentifier ?: throw
            PulumiNullFieldException("sourceClusterIdentifier"),
        useLatestRestorableTime = useLatestRestorableTime,
    )
}
