@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property restoreToTime The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
 * @property restoreType The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
 * @property sourceClusterIdentifier The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
 * @property useLatestRestorableTime A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
 */
public data class ClusterRestoreToPointInTime(
    public val restoreToTime: String? = null,
    public val restoreType: String? = null,
    public val sourceClusterIdentifier: String,
    public val useLatestRestorableTime: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.docdb.outputs.ClusterRestoreToPointInTime): ClusterRestoreToPointInTime = ClusterRestoreToPointInTime(
            restoreToTime = javaType.restoreToTime().map({ args0 -> args0 }).orElse(null),
            restoreType = javaType.restoreType().map({ args0 -> args0 }).orElse(null),
            sourceClusterIdentifier = javaType.sourceClusterIdentifier(),
            useLatestRestorableTime = javaType.useLatestRestorableTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
