@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property create A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 * @property delete A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
 * @property update A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 */
public data class ElasticClusterTimeouts(
    public val create: String? = null,
    public val delete: String? = null,
    public val update: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.docdb.outputs.ElasticClusterTimeouts): ElasticClusterTimeouts = ElasticClusterTimeouts(
            create = javaType.create().map({ args0 -> args0 }).orElse(null),
            delete = javaType.delete().map({ args0 -> args0 }).orElse(null),
            update = javaType.update().map({ args0 -> args0 }).orElse(null),
        )
    }
}
