@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrderableDbInstance.
 * @property availabilityZones Availability zones where the instance is available.
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceClass
 * @property licenseModel
 * @property preferredInstanceClasses
 * @property vpc
 */
public data class GetOrderableDbInstanceResult(
    public val availabilityZones: List<String>,
    public val engine: String? = null,
    public val engineVersion: String,
    public val id: String,
    public val instanceClass: String,
    public val licenseModel: String? = null,
    public val preferredInstanceClasses: List<String>? = null,
    public val vpc: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.docdb.outputs.GetOrderableDbInstanceResult): GetOrderableDbInstanceResult = GetOrderableDbInstanceResult(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            licenseModel = javaType.licenseModel().map({ args0 -> args0 }).orElse(null),
            preferredInstanceClasses = javaType.preferredInstanceClasses().map({ args0 -> args0 }),
            vpc = javaType.vpc(),
        )
    }
}
