@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.drs.kotlin

import com.pulumi.aws.drs.kotlin.outputs.ReplicationConfigurationTemplatePitPolicy
import com.pulumi.aws.drs.kotlin.outputs.ReplicationConfigurationTemplateTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.drs.kotlin.outputs.ReplicationConfigurationTemplatePitPolicy.Companion.toKotlin as replicationConfigurationTemplatePitPolicyToKotlin
import com.pulumi.aws.drs.kotlin.outputs.ReplicationConfigurationTemplateTimeouts.Companion.toKotlin as replicationConfigurationTemplateTimeoutsToKotlin

/**
 * Builder for [ReplicationConfigurationTemplate].
 */
@PulumiTagMarker
public class ReplicationConfigurationTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationConfigurationTemplateArgs = ReplicationConfigurationTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationConfigurationTemplateArgsBuilder.() -> Unit) {
        val builder = ReplicationConfigurationTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationConfigurationTemplate {
        val builtJavaResource =
            com.pulumi.aws.drs.ReplicationConfigurationTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationConfigurationTemplate(builtJavaResource)
    }
}

/**
 * Provides an Elastic Disaster Recovery replication configuration template resource. Before using DRS, your account must be [initialized](https://docs.aws.amazon.com/drs/latest/userguide/getting-started-initializing.html).
 * > **NOTE:** Your configuration must use the PIT policy shown in the basic configuration due to AWS rules. The only value that you can change is the `retention_duration` of `rule_id` 3.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import DRS Replication Configuration Template using the `id`. For example:
 * ```sh
 * $ pulumi import aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate example templateid
 * ```
 */
public class ReplicationConfigurationTemplate internal constructor(
    override val javaResource: com.pulumi.aws.drs.ReplicationConfigurationTemplate,
) : KotlinCustomResource(javaResource, ReplicationConfigurationTemplateMapper) {
    /**
     * Replication configuration template ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
     */
    public val associateDefaultSecurityGroup: Output<Boolean>
        get() = javaResource.associateDefaultSecurityGroup().applyValue({ args0 -> args0 })

    /**
     * Whether to allow the AWS replication agent to automatically replicate newly added disks.
     */
    public val autoReplicateNewDisks: Output<Boolean>
        get() = javaResource.autoReplicateNewDisks().applyValue({ args0 -> args0 })

    /**
     * Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
     */
    public val bandwidthThrottling: Output<Int>
        get() = javaResource.bandwidthThrottling().applyValue({ args0 -> args0 })

    /**
     * Whether to create a Public IP for the Recovery Instance by default.
     */
    public val createPublicIp: Output<Boolean>
        get() = javaResource.createPublicIp().applyValue({ args0 -> args0 })

    /**
     * Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
     */
    public val dataPlaneRouting: Output<String>
        get() = javaResource.dataPlaneRouting().applyValue({ args0 -> args0 })

    /**
     * Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
     */
    public val defaultLargeStagingDiskType: Output<String>
        get() = javaResource.defaultLargeStagingDiskType().applyValue({ args0 -> args0 })

    /**
     * Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
     */
    public val ebsEncryption: Output<String>
        get() = javaResource.ebsEncryption().applyValue({ args0 -> args0 })

    /**
     * ARN of the EBS encryption key to be used during replication.
     */
    public val ebsEncryptionKeyArn: Output<String>?
        get() = javaResource.ebsEncryptionKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    public val pitPolicies: Output<List<ReplicationConfigurationTemplatePitPolicy>>?
        get() = javaResource.pitPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        replicationConfigurationTemplatePitPolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Instance type to be used for the replication server.
     */
    public val replicationServerInstanceType: Output<String>
        get() = javaResource.replicationServerInstanceType().applyValue({ args0 -> args0 })

    /**
     * Security group IDs that will be used by the replication server.
     */
    public val replicationServersSecurityGroupsIds: Output<List<String>>
        get() = javaResource.replicationServersSecurityGroupsIds().applyValue({ args0 ->
            args0.map({ args0 -> args0 })
        })

    /**
     * Subnet to be used by the replication staging area.
     */
    public val stagingAreaSubnetId: Output<String>
        get() = javaResource.stagingAreaSubnetId().applyValue({ args0 -> args0 })

    /**
     * Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
     */
    public val stagingAreaTags: Output<Map<String, String>>?
        get() = javaResource.stagingAreaTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Set of tags to be associated with the Replication Configuration Template resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ReplicationConfigurationTemplateTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    replicationConfigurationTemplateTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether to use a dedicated Replication Server in the replication staging area.
     * The following arguments are optional:
     */
    public val useDedicatedReplicationServer: Output<Boolean>
        get() = javaResource.useDedicatedReplicationServer().applyValue({ args0 -> args0 })
}

public object ReplicationConfigurationTemplateMapper :
    ResourceMapper<ReplicationConfigurationTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.drs.ReplicationConfigurationTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationConfigurationTemplate =
        ReplicationConfigurationTemplate(
            javaResource as
                com.pulumi.aws.drs.ReplicationConfigurationTemplate,
        )
}

/**
 * @see [ReplicationConfigurationTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationConfigurationTemplate].
 */
public suspend fun replicationConfigurationTemplate(
    name: String,
    block: suspend ReplicationConfigurationTemplateResourceBuilder.() -> Unit,
): ReplicationConfigurationTemplate {
    val builder = ReplicationConfigurationTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationConfigurationTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationConfigurationTemplate(name: String): ReplicationConfigurationTemplate {
    val builder = ReplicationConfigurationTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
