@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.drs.kotlin

import com.pulumi.aws.drs.ReplicationConfigurationTemplateArgs.builder
import com.pulumi.aws.drs.kotlin.inputs.ReplicationConfigurationTemplatePitPolicyArgs
import com.pulumi.aws.drs.kotlin.inputs.ReplicationConfigurationTemplatePitPolicyArgsBuilder
import com.pulumi.aws.drs.kotlin.inputs.ReplicationConfigurationTemplateTimeoutsArgs
import com.pulumi.aws.drs.kotlin.inputs.ReplicationConfigurationTemplateTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Disaster Recovery replication configuration template resource. Before using DRS, your account must be [initialized](https://docs.aws.amazon.com/drs/latest/userguide/getting-started-initializing.html).
 * > **NOTE:** Your configuration must use the PIT policy shown in the basic configuration due to AWS rules. The only value that you can change is the `retention_duration` of `rule_id` 3.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import DRS Replication Configuration Template using the `id`. For example:
 * ```sh
 * $ pulumi import aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate example templateid
 * ```
 * @property associateDefaultSecurityGroup Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
 * @property autoReplicateNewDisks Whether to allow the AWS replication agent to automatically replicate newly added disks.
 * @property bandwidthThrottling Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
 * @property createPublicIp Whether to create a Public IP for the Recovery Instance by default.
 * @property dataPlaneRouting Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
 * @property defaultLargeStagingDiskType Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
 * @property ebsEncryption Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
 * @property ebsEncryptionKeyArn ARN of the EBS encryption key to be used during replication.
 * @property pitPolicies Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
 * @property replicationServerInstanceType Instance type to be used for the replication server.
 * @property replicationServersSecurityGroupsIds Security group IDs that will be used by the replication server.
 * @property stagingAreaSubnetId Subnet to be used by the replication staging area.
 * @property stagingAreaTags Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
 * @property tags Set of tags to be associated with the Replication Configuration Template resource.
 * @property timeouts
 * @property useDedicatedReplicationServer Whether to use a dedicated Replication Server in the replication staging area.
 * The following arguments are optional:
 */
public data class ReplicationConfigurationTemplateArgs(
    public val associateDefaultSecurityGroup: Output<Boolean>? = null,
    public val autoReplicateNewDisks: Output<Boolean>? = null,
    public val bandwidthThrottling: Output<Int>? = null,
    public val createPublicIp: Output<Boolean>? = null,
    public val dataPlaneRouting: Output<String>? = null,
    public val defaultLargeStagingDiskType: Output<String>? = null,
    public val ebsEncryption: Output<String>? = null,
    public val ebsEncryptionKeyArn: Output<String>? = null,
    public val pitPolicies: Output<List<ReplicationConfigurationTemplatePitPolicyArgs>>? = null,
    public val replicationServerInstanceType: Output<String>? = null,
    public val replicationServersSecurityGroupsIds: Output<List<String>>? = null,
    public val stagingAreaSubnetId: Output<String>? = null,
    public val stagingAreaTags: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ReplicationConfigurationTemplateTimeoutsArgs>? = null,
    public val useDedicatedReplicationServer: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.drs.ReplicationConfigurationTemplateArgs> {
    override fun toJava(): com.pulumi.aws.drs.ReplicationConfigurationTemplateArgs =
        com.pulumi.aws.drs.ReplicationConfigurationTemplateArgs.builder()
            .associateDefaultSecurityGroup(associateDefaultSecurityGroup?.applyValue({ args0 -> args0 }))
            .autoReplicateNewDisks(autoReplicateNewDisks?.applyValue({ args0 -> args0 }))
            .bandwidthThrottling(bandwidthThrottling?.applyValue({ args0 -> args0 }))
            .createPublicIp(createPublicIp?.applyValue({ args0 -> args0 }))
            .dataPlaneRouting(dataPlaneRouting?.applyValue({ args0 -> args0 }))
            .defaultLargeStagingDiskType(defaultLargeStagingDiskType?.applyValue({ args0 -> args0 }))
            .ebsEncryption(ebsEncryption?.applyValue({ args0 -> args0 }))
            .ebsEncryptionKeyArn(ebsEncryptionKeyArn?.applyValue({ args0 -> args0 }))
            .pitPolicies(
                pitPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .replicationServerInstanceType(replicationServerInstanceType?.applyValue({ args0 -> args0 }))
            .replicationServersSecurityGroupsIds(
                replicationServersSecurityGroupsIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .stagingAreaSubnetId(stagingAreaSubnetId?.applyValue({ args0 -> args0 }))
            .stagingAreaTags(
                stagingAreaTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .useDedicatedReplicationServer(
                useDedicatedReplicationServer?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ReplicationConfigurationTemplateArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationTemplateArgsBuilder internal constructor() {
    private var associateDefaultSecurityGroup: Output<Boolean>? = null

    private var autoReplicateNewDisks: Output<Boolean>? = null

    private var bandwidthThrottling: Output<Int>? = null

    private var createPublicIp: Output<Boolean>? = null

    private var dataPlaneRouting: Output<String>? = null

    private var defaultLargeStagingDiskType: Output<String>? = null

    private var ebsEncryption: Output<String>? = null

    private var ebsEncryptionKeyArn: Output<String>? = null

    private var pitPolicies: Output<List<ReplicationConfigurationTemplatePitPolicyArgs>>? = null

    private var replicationServerInstanceType: Output<String>? = null

    private var replicationServersSecurityGroupsIds: Output<List<String>>? = null

    private var stagingAreaSubnetId: Output<String>? = null

    private var stagingAreaTags: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ReplicationConfigurationTemplateTimeoutsArgs>? = null

    private var useDedicatedReplicationServer: Output<Boolean>? = null

    /**
     * @param value Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
     */
    @JvmName("wnyvbxsgkvtdthtm")
    public suspend fun associateDefaultSecurityGroup(`value`: Output<Boolean>) {
        this.associateDefaultSecurityGroup = value
    }

    /**
     * @param value Whether to allow the AWS replication agent to automatically replicate newly added disks.
     */
    @JvmName("jftlwgxnbnvlqfqt")
    public suspend fun autoReplicateNewDisks(`value`: Output<Boolean>) {
        this.autoReplicateNewDisks = value
    }

    /**
     * @param value Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
     */
    @JvmName("gvgqaxihpgtcmemf")
    public suspend fun bandwidthThrottling(`value`: Output<Int>) {
        this.bandwidthThrottling = value
    }

    /**
     * @param value Whether to create a Public IP for the Recovery Instance by default.
     */
    @JvmName("xbelpklgltoweybh")
    public suspend fun createPublicIp(`value`: Output<Boolean>) {
        this.createPublicIp = value
    }

    /**
     * @param value Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
     */
    @JvmName("evvrlqpemfylwpkp")
    public suspend fun dataPlaneRouting(`value`: Output<String>) {
        this.dataPlaneRouting = value
    }

    /**
     * @param value Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
     */
    @JvmName("qffvamqfkefkuwxj")
    public suspend fun defaultLargeStagingDiskType(`value`: Output<String>) {
        this.defaultLargeStagingDiskType = value
    }

    /**
     * @param value Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
     */
    @JvmName("xlkauqvsgvbdlqki")
    public suspend fun ebsEncryption(`value`: Output<String>) {
        this.ebsEncryption = value
    }

    /**
     * @param value ARN of the EBS encryption key to be used during replication.
     */
    @JvmName("sguvkqtcgljrnxmq")
    public suspend fun ebsEncryptionKeyArn(`value`: Output<String>) {
        this.ebsEncryptionKeyArn = value
    }

    /**
     * @param value Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("tgleoljvegutwyoo")
    public suspend fun pitPolicies(`value`: Output<List<ReplicationConfigurationTemplatePitPolicyArgs>>) {
        this.pitPolicies = value
    }

    @JvmName("ciuidgqyrvmxtnig")
    public suspend fun pitPolicies(vararg values: Output<ReplicationConfigurationTemplatePitPolicyArgs>) {
        this.pitPolicies = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("vhuhblsvllxwlngx")
    public suspend fun pitPolicies(values: List<Output<ReplicationConfigurationTemplatePitPolicyArgs>>) {
        this.pitPolicies = Output.all(values)
    }

    /**
     * @param value Instance type to be used for the replication server.
     */
    @JvmName("onvmdyjimcapfrha")
    public suspend fun replicationServerInstanceType(`value`: Output<String>) {
        this.replicationServerInstanceType = value
    }

    /**
     * @param value Security group IDs that will be used by the replication server.
     */
    @JvmName("oyhkbdtqgygmfyuh")
    public suspend fun replicationServersSecurityGroupsIds(`value`: Output<List<String>>) {
        this.replicationServersSecurityGroupsIds = value
    }

    @JvmName("cqqgkirfeecpeiwg")
    public suspend fun replicationServersSecurityGroupsIds(vararg values: Output<String>) {
        this.replicationServersSecurityGroupsIds = Output.all(values.asList())
    }

    /**
     * @param values Security group IDs that will be used by the replication server.
     */
    @JvmName("lwcxnepoxhdghgnu")
    public suspend fun replicationServersSecurityGroupsIds(values: List<Output<String>>) {
        this.replicationServersSecurityGroupsIds = Output.all(values)
    }

    /**
     * @param value Subnet to be used by the replication staging area.
     */
    @JvmName("jfolshgsrapndsxi")
    public suspend fun stagingAreaSubnetId(`value`: Output<String>) {
        this.stagingAreaSubnetId = value
    }

    /**
     * @param value Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
     */
    @JvmName("ikucqwgnoniwxyvq")
    public suspend fun stagingAreaTags(`value`: Output<Map<String, String>>) {
        this.stagingAreaTags = value
    }

    /**
     * @param value Set of tags to be associated with the Replication Configuration Template resource.
     */
    @JvmName("ywtxgbscwqcvetgr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("rflflaajnjnubcox")
    public suspend fun timeouts(`value`: Output<ReplicationConfigurationTemplateTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Whether to use a dedicated Replication Server in the replication staging area.
     * The following arguments are optional:
     */
    @JvmName("dxxbmlmmwvfdtubm")
    public suspend fun useDedicatedReplicationServer(`value`: Output<Boolean>) {
        this.useDedicatedReplicationServer = value
    }

    /**
     * @param value Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
     */
    @JvmName("dtmhngimsbjdwgrc")
    public suspend fun associateDefaultSecurityGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateDefaultSecurityGroup = mapped
    }

    /**
     * @param value Whether to allow the AWS replication agent to automatically replicate newly added disks.
     */
    @JvmName("ovrpheqmpkfrprnh")
    public suspend fun autoReplicateNewDisks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReplicateNewDisks = mapped
    }

    /**
     * @param value Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
     */
    @JvmName("ifkqvnqingefefbn")
    public suspend fun bandwidthThrottling(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthThrottling = mapped
    }

    /**
     * @param value Whether to create a Public IP for the Recovery Instance by default.
     */
    @JvmName("yrsmpwuyhoiaovgs")
    public suspend fun createPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createPublicIp = mapped
    }

    /**
     * @param value Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
     */
    @JvmName("kktfxblcyqbwxdmg")
    public suspend fun dataPlaneRouting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPlaneRouting = mapped
    }

    /**
     * @param value Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
     */
    @JvmName("dmscxptgmxfargmg")
    public suspend fun defaultLargeStagingDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLargeStagingDiskType = mapped
    }

    /**
     * @param value Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
     */
    @JvmName("nnttwogijohvsykj")
    public suspend fun ebsEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsEncryption = mapped
    }

    /**
     * @param value ARN of the EBS encryption key to be used during replication.
     */
    @JvmName("omthlruldnlngcqy")
    public suspend fun ebsEncryptionKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsEncryptionKeyArn = mapped
    }

    /**
     * @param value Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("oxldnyheahavyeyc")
    public suspend fun pitPolicies(`value`: List<ReplicationConfigurationTemplatePitPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pitPolicies = mapped
    }

    /**
     * @param argument Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("hajynmvjivatrnqk")
    public suspend fun pitPolicies(argument: List<suspend ReplicationConfigurationTemplatePitPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationTemplatePitPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pitPolicies = mapped
    }

    /**
     * @param argument Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("mwywftsltpjeigma")
    public suspend fun pitPolicies(vararg argument: suspend ReplicationConfigurationTemplatePitPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationTemplatePitPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pitPolicies = mapped
    }

    /**
     * @param argument Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("gpklqiwxjswobfxd")
    public suspend fun pitPolicies(argument: suspend ReplicationConfigurationTemplatePitPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReplicationConfigurationTemplatePitPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pitPolicies = mapped
    }

    /**
     * @param values Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
     */
    @JvmName("pluwrjuydmatxkbf")
    public suspend fun pitPolicies(vararg values: ReplicationConfigurationTemplatePitPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pitPolicies = mapped
    }

    /**
     * @param value Instance type to be used for the replication server.
     */
    @JvmName("ckfalwrvpfsavgib")
    public suspend fun replicationServerInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationServerInstanceType = mapped
    }

    /**
     * @param value Security group IDs that will be used by the replication server.
     */
    @JvmName("biunwvhhubguvjui")
    public suspend fun replicationServersSecurityGroupsIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationServersSecurityGroupsIds = mapped
    }

    /**
     * @param values Security group IDs that will be used by the replication server.
     */
    @JvmName("umptgqsotjjoydxw")
    public suspend fun replicationServersSecurityGroupsIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationServersSecurityGroupsIds = mapped
    }

    /**
     * @param value Subnet to be used by the replication staging area.
     */
    @JvmName("tuefetxkxdmopruc")
    public suspend fun stagingAreaSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingAreaSubnetId = mapped
    }

    /**
     * @param value Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
     */
    @JvmName("kmbwtrasdsdujdxh")
    public suspend fun stagingAreaTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingAreaTags = mapped
    }

    /**
     * @param values Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
     */
    @JvmName("lmctxseolcnckqcr")
    public fun stagingAreaTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stagingAreaTags = mapped
    }

    /**
     * @param value Set of tags to be associated with the Replication Configuration Template resource.
     */
    @JvmName("ihxfogbrggdwrmow")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Set of tags to be associated with the Replication Configuration Template resource.
     */
    @JvmName("ccsumbdbpjxjbpvx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmpnnjyehnfcvxfi")
    public suspend fun timeouts(`value`: ReplicationConfigurationTemplateTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("csgoykntiwrariwa")
    public suspend fun timeouts(argument: suspend ReplicationConfigurationTemplateTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationConfigurationTemplateTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Whether to use a dedicated Replication Server in the replication staging area.
     * The following arguments are optional:
     */
    @JvmName("rghhtoqitxkhcjsg")
    public suspend fun useDedicatedReplicationServer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDedicatedReplicationServer = mapped
    }

    internal fun build(): ReplicationConfigurationTemplateArgs = ReplicationConfigurationTemplateArgs(
        associateDefaultSecurityGroup = associateDefaultSecurityGroup,
        autoReplicateNewDisks = autoReplicateNewDisks,
        bandwidthThrottling = bandwidthThrottling,
        createPublicIp = createPublicIp,
        dataPlaneRouting = dataPlaneRouting,
        defaultLargeStagingDiskType = defaultLargeStagingDiskType,
        ebsEncryption = ebsEncryption,
        ebsEncryptionKeyArn = ebsEncryptionKeyArn,
        pitPolicies = pitPolicies,
        replicationServerInstanceType = replicationServerInstanceType,
        replicationServersSecurityGroupsIds = replicationServersSecurityGroupsIds,
        stagingAreaSubnetId = stagingAreaSubnetId,
        stagingAreaTags = stagingAreaTags,
        tags = tags,
        timeouts = timeouts,
        useDedicatedReplicationServer = useDedicatedReplicationServer,
    )
}
