@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.drs.kotlin.inputs

import com.pulumi.aws.drs.inputs.ReplicationConfigurationTemplatePitPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether this rule is enabled or not.
 * @property interval How often, in the chosen units, a snapshot should be taken.
 * @property retentionDuration Duration to retain a snapshot for, in the chosen `units`.
 * @property ruleId ID of the rule. Valid values are integers.
 * @property units Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
 */
public data class ReplicationConfigurationTemplatePitPolicyArgs(
    public val enabled: Output<Boolean>? = null,
    public val interval: Output<Int>,
    public val retentionDuration: Output<Int>,
    public val ruleId: Output<Int>? = null,
    public val units: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.drs.inputs.ReplicationConfigurationTemplatePitPolicyArgs> {
    override fun toJava(): com.pulumi.aws.drs.inputs.ReplicationConfigurationTemplatePitPolicyArgs =
        com.pulumi.aws.drs.inputs.ReplicationConfigurationTemplatePitPolicyArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .interval(interval.applyValue({ args0 -> args0 }))
            .retentionDuration(retentionDuration.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .units(units.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigurationTemplatePitPolicyArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationTemplatePitPolicyArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var interval: Output<Int>? = null

    private var retentionDuration: Output<Int>? = null

    private var ruleId: Output<Int>? = null

    private var units: Output<String>? = null

    /**
     * @param value Whether this rule is enabled or not.
     */
    @JvmName("ujynhpkxcnyyjjyt")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value How often, in the chosen units, a snapshot should be taken.
     */
    @JvmName("lyoymgwajvkqkhyq")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Duration to retain a snapshot for, in the chosen `units`.
     */
    @JvmName("hpftpmuqxywjaplo")
    public suspend fun retentionDuration(`value`: Output<Int>) {
        this.retentionDuration = value
    }

    /**
     * @param value ID of the rule. Valid values are integers.
     */
    @JvmName("fbjaerenjgbtlllf")
    public suspend fun ruleId(`value`: Output<Int>) {
        this.ruleId = value
    }

    /**
     * @param value Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
     */
    @JvmName("okcmuvhxfnvxdhwe")
    public suspend fun units(`value`: Output<String>) {
        this.units = value
    }

    /**
     * @param value Whether this rule is enabled or not.
     */
    @JvmName("gdlpfrhnwrdjwegf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value How often, in the chosen units, a snapshot should be taken.
     */
    @JvmName("qlhekohejcxtruyl")
    public suspend fun interval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Duration to retain a snapshot for, in the chosen `units`.
     */
    @JvmName("cytqpsogguwoyxqd")
    public suspend fun retentionDuration(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param value ID of the rule. Valid values are integers.
     */
    @JvmName("iyadssdwrdccmoxa")
    public suspend fun ruleId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
     */
    @JvmName("yshybcfijshncgwg")
    public suspend fun units(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.units = mapped
    }

    internal fun build(): ReplicationConfigurationTemplatePitPolicyArgs =
        ReplicationConfigurationTemplatePitPolicyArgs(
            enabled = enabled,
            interval = interval ?: throw PulumiNullFieldException("interval"),
            retentionDuration = retentionDuration ?: throw PulumiNullFieldException("retentionDuration"),
            ruleId = ruleId,
            units = units ?: throw PulumiNullFieldException("units"),
        )
}
