@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.drs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether this rule is enabled or not.
 * @property interval How often, in the chosen units, a snapshot should be taken.
 * @property retentionDuration Duration to retain a snapshot for, in the chosen `units`.
 * @property ruleId ID of the rule. Valid values are integers.
 * @property units Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
 */
public data class ReplicationConfigurationTemplatePitPolicy(
    public val enabled: Boolean? = null,
    public val interval: Int,
    public val retentionDuration: Int,
    public val ruleId: Int? = null,
    public val units: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.drs.outputs.ReplicationConfigurationTemplatePitPolicy): ReplicationConfigurationTemplatePitPolicy = ReplicationConfigurationTemplatePitPolicy(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval(),
            retentionDuration = javaType.retentionDuration(),
            ruleId = javaType.ruleId().map({ args0 -> args0 }).orElse(null),
            units = javaType.units(),
        )
    }
}
