@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ContributorInsights].
 */
@PulumiTagMarker
public class ContributorInsightsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContributorInsightsArgs = ContributorInsightsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContributorInsightsArgsBuilder.() -> Unit) {
        val builder = ContributorInsightsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContributorInsights {
        val builtJavaResource = com.pulumi.aws.dynamodb.ContributorInsights(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContributorInsights(builtJavaResource)
    }
}

/**
 * Provides a DynamoDB contributor insights resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.dynamodb.ContributorInsights("test", {tableName: "ExampleTableName"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.dynamodb.ContributorInsights("test", table_name="ExampleTableName")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.DynamoDB.ContributorInsights("test", new()
 *     {
 *         TableName = "ExampleTableName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamodb.NewContributorInsights(ctx, "test", &dynamodb.ContributorInsightsArgs{
 * 			TableName: pulumi.String("ExampleTableName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.ContributorInsights;
 * import com.pulumi.aws.dynamodb.ContributorInsightsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ContributorInsights("test", ContributorInsightsArgs.builder()
 *             .tableName("ExampleTableName")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:dynamodb:ContributorInsights
 *     properties:
 *       tableName: ExampleTableName
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_dynamodb_contributor_insights` using the format `name:table_name/index:index_name`, followed by the account number. For example:
 * ```sh
 * $ pulumi import aws:dynamodb/contributorInsights:ContributorInsights test name:ExampleTableName/index:ExampleIndexName/123456789012
 * ```
 */
public class ContributorInsights internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.ContributorInsights,
) : KotlinCustomResource(javaResource, ContributorInsightsMapper) {
    /**
     * The global secondary index name
     */
    public val indexName: Output<String>?
        get() = javaResource.indexName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the table to enable contributor insights
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object ContributorInsightsMapper : ResourceMapper<ContributorInsights> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.ContributorInsights::class == javaResource::class

    override fun map(javaResource: Resource): ContributorInsights = ContributorInsights(
        javaResource
            as com.pulumi.aws.dynamodb.ContributorInsights,
    )
}

/**
 * @see [ContributorInsights].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContributorInsights].
 */
public suspend fun contributorInsights(
    name: String,
    block: suspend ContributorInsightsResourceBuilder.() -> Unit,
): ContributorInsights {
    val builder = ContributorInsightsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContributorInsights].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contributorInsights(name: String): ContributorInsights {
    val builder = ContributorInsightsResourceBuilder()
    builder.name(name)
    return builder.build()
}
