@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.GlobalTableArgs.builder
import com.pulumi.aws.dynamodb.kotlin.inputs.GlobalTableReplicaArgs
import com.pulumi.aws.dynamodb.kotlin.inputs.GlobalTableReplicaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages [DynamoDB Global Tables V1 (version 2017&#46;11&#46;29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html). These are layered on top of existing DynamoDB Tables.
 * > **NOTE:** To instead manage [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html), use the `aws.dynamodb.Table` resource `replica` configuration block.
 * > Note: There are many restrictions before you can properly create DynamoDB Global Tables in multiple regions. See the [AWS DynamoDB Global Table Requirements](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_reqs_bestpractices.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const us_east_1 = new aws.dynamodb.Table("us-east-1", {
 *     hashKey: "myAttribute",
 *     name: "myTable",
 *     streamEnabled: true,
 *     streamViewType: "NEW_AND_OLD_IMAGES",
 *     readCapacity: 1,
 *     writeCapacity: 1,
 *     attributes: [{
 *         name: "myAttribute",
 *         type: "S",
 *     }],
 * });
 * const us_west_2 = new aws.dynamodb.Table("us-west-2", {
 *     hashKey: "myAttribute",
 *     name: "myTable",
 *     streamEnabled: true,
 *     streamViewType: "NEW_AND_OLD_IMAGES",
 *     readCapacity: 1,
 *     writeCapacity: 1,
 *     attributes: [{
 *         name: "myAttribute",
 *         type: "S",
 *     }],
 * });
 * const myTable = new aws.dynamodb.GlobalTable("myTable", {
 *     name: "myTable",
 *     replicas: [
 *         {
 *             regionName: "us-east-1",
 *         },
 *         {
 *             regionName: "us-west-2",
 *         },
 *     ],
 * }, {
 *     dependsOn: [
 *         us_east_1,
 *         us_west_2,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * us_east_1 = aws.dynamodb.Table("us-east-1",
 *     hash_key="myAttribute",
 *     name="myTable",
 *     stream_enabled=True,
 *     stream_view_type="NEW_AND_OLD_IMAGES",
 *     read_capacity=1,
 *     write_capacity=1,
 *     attributes=[{
 *         "name": "myAttribute",
 *         "type": "S",
 *     }])
 * us_west_2 = aws.dynamodb.Table("us-west-2",
 *     hash_key="myAttribute",
 *     name="myTable",
 *     stream_enabled=True,
 *     stream_view_type="NEW_AND_OLD_IMAGES",
 *     read_capacity=1,
 *     write_capacity=1,
 *     attributes=[{
 *         "name": "myAttribute",
 *         "type": "S",
 *     }])
 * my_table = aws.dynamodb.GlobalTable("myTable",
 *     name="myTable",
 *     replicas=[
 *         {
 *             "region_name": "us-east-1",
 *         },
 *         {
 *             "region_name": "us-west-2",
 *         },
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             us_east_1,
 *             us_west_2,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var us_east_1 = new Aws.DynamoDB.Table("us-east-1", new()
 *     {
 *         HashKey = "myAttribute",
 *         Name = "myTable",
 *         StreamEnabled = true,
 *         StreamViewType = "NEW_AND_OLD_IMAGES",
 *         ReadCapacity = 1,
 *         WriteCapacity = 1,
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "myAttribute",
 *                 Type = "S",
 *             },
 *         },
 *     });
 *     var us_west_2 = new Aws.DynamoDB.Table("us-west-2", new()
 *     {
 *         HashKey = "myAttribute",
 *         Name = "myTable",
 *         StreamEnabled = true,
 *         StreamViewType = "NEW_AND_OLD_IMAGES",
 *         ReadCapacity = 1,
 *         WriteCapacity = 1,
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "myAttribute",
 *                 Type = "S",
 *             },
 *         },
 *     });
 *     var myTable = new Aws.DynamoDB.GlobalTable("myTable", new()
 *     {
 *         Name = "myTable",
 *         Replicas = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.GlobalTableReplicaArgs
 *             {
 *                 RegionName = "us-east-1",
 *             },
 *             new Aws.DynamoDB.Inputs.GlobalTableReplicaArgs
 *             {
 *                 RegionName = "us-west-2",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             us_east_1,
 *             us_west_2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamodb.NewTable(ctx, "us-east-1", &dynamodb.TableArgs{
 * 			HashKey:        pulumi.String("myAttribute"),
 * 			Name:           pulumi.String("myTable"),
 * 			StreamEnabled:  pulumi.Bool(true),
 * 			StreamViewType: pulumi.String("NEW_AND_OLD_IMAGES"),
 * 			ReadCapacity:   pulumi.Int(1),
 * 			WriteCapacity:  pulumi.Int(1),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("myAttribute"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewTable(ctx, "us-west-2", &dynamodb.TableArgs{
 * 			HashKey:        pulumi.String("myAttribute"),
 * 			Name:           pulumi.String("myTable"),
 * 			StreamEnabled:  pulumi.Bool(true),
 * 			StreamViewType: pulumi.String("NEW_AND_OLD_IMAGES"),
 * 			ReadCapacity:   pulumi.Int(1),
 * 			WriteCapacity:  pulumi.Int(1),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("myAttribute"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewGlobalTable(ctx, "myTable", &dynamodb.GlobalTableArgs{
 * 			Name: pulumi.String("myTable"),
 * 			Replicas: dynamodb.GlobalTableReplicaArray{
 * 				&dynamodb.GlobalTableReplicaArgs{
 * 					RegionName: pulumi.String("us-east-1"),
 * 				},
 * 				&dynamodb.GlobalTableReplicaArgs{
 * 					RegionName: pulumi.String("us-west-2"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			us_east_1,
 * 			us_west_2,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.GlobalTable;
 * import com.pulumi.aws.dynamodb.GlobalTableArgs;
 * import com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var us_east_1 = new Table("us-east-1", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .name("myTable")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var us_west_2 = new Table("us-west-2", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .name("myTable")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var myTable = new GlobalTable("myTable", GlobalTableArgs.builder()
 *             .name("myTable")
 *             .replicas(
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-east-1")
 *                     .build(),
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-west-2")
 *                     .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     us_east_1,
 *                     us_west_2)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   us-east-1:
 *     type: aws:dynamodb:Table
 *     properties:
 *       hashKey: myAttribute
 *       name: myTable
 *       streamEnabled: true
 *       streamViewType: NEW_AND_OLD_IMAGES
 *       readCapacity: 1
 *       writeCapacity: 1
 *       attributes:
 *         - name: myAttribute
 *           type: S
 *   us-west-2:
 *     type: aws:dynamodb:Table
 *     properties:
 *       hashKey: myAttribute
 *       name: myTable
 *       streamEnabled: true
 *       streamViewType: NEW_AND_OLD_IMAGES
 *       readCapacity: 1
 *       writeCapacity: 1
 *       attributes:
 *         - name: myAttribute
 *           type: S
 *   myTable:
 *     type: aws:dynamodb:GlobalTable
 *     properties:
 *       name: myTable
 *       replicas:
 *         - regionName: us-east-1
 *         - regionName: us-west-2
 *     options:
 *       dependson:
 *         - ${["us-east-1"]}
 *         - ${["us-west-2"]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DynamoDB Global Tables using the global table name. For example:
 * ```sh
 * $ pulumi import aws:dynamodb/globalTable:GlobalTable MyTable MyTable
 * ```
 * @property name The name of the global table. Must match underlying DynamoDB Table names in all regions.
 * @property replicas Underlying DynamoDB Table. At least 1 replica must be defined. See below.
 */
public data class GlobalTableArgs(
    public val name: Output<String>? = null,
    public val replicas: Output<List<GlobalTableReplicaArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.GlobalTableArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.GlobalTableArgs =
        com.pulumi.aws.dynamodb.GlobalTableArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .replicas(
                replicas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GlobalTableArgs].
 */
@PulumiTagMarker
public class GlobalTableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var replicas: Output<List<GlobalTableReplicaArgs>>? = null

    /**
     * @param value The name of the global table. Must match underlying DynamoDB Table names in all regions.
     */
    @JvmName("cionsnduirysujif")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("inqvavkdaxbveuuu")
    public suspend fun replicas(`value`: Output<List<GlobalTableReplicaArgs>>) {
        this.replicas = value
    }

    @JvmName("havnicirbcleiwwp")
    public suspend fun replicas(vararg values: Output<GlobalTableReplicaArgs>) {
        this.replicas = Output.all(values.asList())
    }

    /**
     * @param values Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("dhqbcqfxhaugogch")
    public suspend fun replicas(values: List<Output<GlobalTableReplicaArgs>>) {
        this.replicas = Output.all(values)
    }

    /**
     * @param value The name of the global table. Must match underlying DynamoDB Table names in all regions.
     */
    @JvmName("tcbyomtbvbynkagt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("hwwptsqheqvvwcyv")
    public suspend fun replicas(`value`: List<GlobalTableReplicaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("vinglxcnyebtfaga")
    public suspend fun replicas(argument: List<suspend GlobalTableReplicaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GlobalTableReplicaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("ttqtuodwiafkwygw")
    public suspend fun replicas(vararg argument: suspend GlobalTableReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GlobalTableReplicaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("lkhmiaaofsnexdwd")
    public suspend fun replicas(argument: suspend GlobalTableReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GlobalTableReplicaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param values Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("bwnisuqtnbscsggw")
    public suspend fun replicas(vararg values: GlobalTableReplicaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): GlobalTableArgs = GlobalTableArgs(
        name = name,
        replicas = replicas,
    )
}
