@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DynamoDB Resource Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dynamodb.ResourcePolicy("example", {
 *     resourceArn: exampleAwsDynamodbTable.arn,
 *     policy: test.json,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dynamodb.ResourcePolicy("example",
 *     resource_arn=example_aws_dynamodb_table["arn"],
 *     policy=test["json"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DynamoDB.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = exampleAwsDynamodbTable.Arn,
 *         Policy = test.Json,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamodb.NewResourcePolicy(ctx, "example", &dynamodb.ResourcePolicyArgs{
 * 			ResourceArn: pulumi.Any(exampleAwsDynamodbTable.Arn),
 * 			Policy:      pulumi.Any(test.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.ResourcePolicy;
 * import com.pulumi.aws.dynamodb.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleAwsDynamodbTable.arn())
 *             .policy(test.json())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dynamodb:ResourcePolicy
 *     properties:
 *       resourceArn: ${exampleAwsDynamodbTable.arn}
 *       policy: ${test.json}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DynamoDB Resource Policy using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:dynamodb/resourcePolicy:ResourcePolicy example arn:aws:dynamodb:us-east-1:1234567890:table/my-table
 * ```
 * @property confirmRemoveSelfResourceAccess Set this parameter to true to confirm that you want to remove your permissions to change the policy of this resource in the future.
 * @property policy n Amazon Web Services resource-based policy document in JSON format. The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when calculating the size of a policy against this limit. For a full list of all considerations that you should keep in mind while attaching a resource-based policy, see Resource-based policy considerations.
 * The following arguments are optional:
 * @property resourceArn The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The resources you can specify include tables and streams. You can control index permissions using the base table's policy. To specify the same permission level for your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the Resource field of a given Statement in your policy document. Alternatively, to specify different permissions for your table, indexes, or both, you can define multiple Statement fields in your policy document.
 */
public data class ResourcePolicyArgs(
    public val confirmRemoveSelfResourceAccess: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.ResourcePolicyArgs =
        com.pulumi.aws.dynamodb.ResourcePolicyArgs.builder()
            .confirmRemoveSelfResourceAccess(confirmRemoveSelfResourceAccess?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var confirmRemoveSelfResourceAccess: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value Set this parameter to true to confirm that you want to remove your permissions to change the policy of this resource in the future.
     */
    @JvmName("ckqepaadrixgapum")
    public suspend fun confirmRemoveSelfResourceAccess(`value`: Output<Boolean>) {
        this.confirmRemoveSelfResourceAccess = value
    }

    /**
     * @param value n Amazon Web Services resource-based policy document in JSON format. The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when calculating the size of a policy against this limit. For a full list of all considerations that you should keep in mind while attaching a resource-based policy, see Resource-based policy considerations.
     * The following arguments are optional:
     */
    @JvmName("ecsggqkccsjwbgrh")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The resources you can specify include tables and streams. You can control index permissions using the base table's policy. To specify the same permission level for your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the Resource field of a given Statement in your policy document. Alternatively, to specify different permissions for your table, indexes, or both, you can define multiple Statement fields in your policy document.
     */
    @JvmName("vbkwiilwcnhfoxfk")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Set this parameter to true to confirm that you want to remove your permissions to change the policy of this resource in the future.
     */
    @JvmName("uxfplagdmfwyulvc")
    public suspend fun confirmRemoveSelfResourceAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmRemoveSelfResourceAccess = mapped
    }

    /**
     * @param value n Amazon Web Services resource-based policy document in JSON format. The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when calculating the size of a policy against this limit. For a full list of all considerations that you should keep in mind while attaching a resource-based policy, see Resource-based policy considerations.
     * The following arguments are optional:
     */
    @JvmName("ypjrpaidermnyayv")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The resources you can specify include tables and streams. You can control index permissions using the base table's policy. To specify the same permission level for your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the Resource field of a given Statement in your policy document. Alternatively, to specify different permissions for your table, indexes, or both, you can define multiple Statement fields in your policy document.
     */
    @JvmName("wloikpiqvoyfngkq")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        confirmRemoveSelfResourceAccess = confirmRemoveSelfResourceAccess,
        policy = policy,
        resourceArn = resourceArn,
    )
}
