@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TableExport].
 */
@PulumiTagMarker
public class TableExportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableExportArgs = TableExportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableExportArgsBuilder.() -> Unit) {
        val builder = TableExportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TableExport {
        val builtJavaResource = com.pulumi.aws.dynamodb.TableExport(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TableExport(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucketPrefix: "example",
 *     forceDestroy: true,
 * });
 * const exampleTable = new aws.dynamodb.Table("example", {
 *     name: "example-table-1",
 *     billingMode: "PAY_PER_REQUEST",
 *     hashKey: "user_id",
 *     attributes: [{
 *         name: "user_id",
 *         type: "S",
 *     }],
 *     pointInTimeRecovery: {
 *         enabled: true,
 *     },
 * });
 * const exampleTableExport = new aws.dynamodb.TableExport("example", {
 *     tableArn: exampleTable.arn,
 *     s3Bucket: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket_prefix="example",
 *     force_destroy=True)
 * example_table = aws.dynamodb.Table("example",
 *     name="example-table-1",
 *     billing_mode="PAY_PER_REQUEST",
 *     hash_key="user_id",
 *     attributes=[{
 *         "name": "user_id",
 *         "type": "S",
 *     }],
 *     point_in_time_recovery={
 *         "enabled": True,
 *     })
 * example_table_export = aws.dynamodb.TableExport("example",
 *     table_arn=example_table.arn,
 *     s3_bucket=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         BucketPrefix = "example",
 *         ForceDestroy = true,
 *     });
 *     var exampleTable = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Name = "example-table-1",
 *         BillingMode = "PAY_PER_REQUEST",
 *         HashKey = "user_id",
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "user_id",
 *                 Type = "S",
 *             },
 *         },
 *         PointInTimeRecovery = new Aws.DynamoDB.Inputs.TablePointInTimeRecoveryArgs
 *         {
 *             Enabled = true,
 *         },
 *     });
 *     var exampleTableExport = new Aws.DynamoDB.TableExport("example", new()
 *     {
 *         TableArn = exampleTable.Arn,
 *         S3Bucket = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			BucketPrefix: pulumi.String("example"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTable, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Name:        pulumi.String("example-table-1"),
 * 			BillingMode: pulumi.String("PAY_PER_REQUEST"),
 * 			HashKey:     pulumi.String("user_id"),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("user_id"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 			PointInTimeRecovery: &dynamodb.TablePointInTimeRecoveryArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewTableExport(ctx, "example", &dynamodb.TableExportArgs{
 * 			TableArn: exampleTable.Arn,
 * 			S3Bucket: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs;
 * import com.pulumi.aws.dynamodb.TableExport;
 * import com.pulumi.aws.dynamodb.TableExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucketPrefix("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .name("example-table-1")
 *             .billingMode("PAY_PER_REQUEST")
 *             .hashKey("user_id")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("user_id")
 *                 .type("S")
 *                 .build())
 *             .pointInTimeRecovery(TablePointInTimeRecoveryArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *         var exampleTableExport = new TableExport("exampleTableExport", TableExportArgs.builder()
 *             .tableArn(exampleTable.arn())
 *             .s3Bucket(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucketPrefix: example
 *       forceDestroy: true
 *   exampleTable:
 *     type: aws:dynamodb:Table
 *     name: example
 *     properties:
 *       name: example-table-1
 *       billingMode: PAY_PER_REQUEST
 *       hashKey: user_id
 *       attributes:
 *         - name: user_id
 *           type: S
 *       pointInTimeRecovery:
 *         enabled: true
 *   exampleTableExport:
 *     type: aws:dynamodb:TableExport
 *     name: example
 *     properties:
 *       tableArn: ${exampleTable.arn}
 *       s3Bucket: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with export time
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dynamodb.TableExport("example", {
 *     exportTime: "2023-04-02T11:30:13+01:00",
 *     s3Bucket: exampleAwsS3Bucket.id,
 *     tableArn: exampleAwsDynamodbTable.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dynamodb.TableExport("example",
 *     export_time="2023-04-02T11:30:13+01:00",
 *     s3_bucket=example_aws_s3_bucket["id"],
 *     table_arn=example_aws_dynamodb_table["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DynamoDB.TableExport("example", new()
 *     {
 *         ExportTime = "2023-04-02T11:30:13+01:00",
 *         S3Bucket = exampleAwsS3Bucket.Id,
 *         TableArn = exampleAwsDynamodbTable.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamodb.NewTableExport(ctx, "example", &dynamodb.TableExportArgs{
 * 			ExportTime: pulumi.String("2023-04-02T11:30:13+01:00"),
 * 			S3Bucket:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 			TableArn:   pulumi.Any(exampleAwsDynamodbTable.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.TableExport;
 * import com.pulumi.aws.dynamodb.TableExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TableExport("example", TableExportArgs.builder()
 *             .exportTime("2023-04-02T11:30:13+01:00")
 *             .s3Bucket(exampleAwsS3Bucket.id())
 *             .tableArn(exampleAwsDynamodbTable.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dynamodb:TableExport
 *     properties:
 *       exportTime: 2023-04-02T11:30:13+01:00
 *       s3Bucket: ${exampleAwsS3Bucket.id}
 *       tableArn: ${exampleAwsDynamodbTable.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DynamoDB table exports using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:dynamodb/tableExport:TableExport example arn:aws:dynamodb:us-west-2:12345678911:table/my-table-1/export/01580735656614-2c2f422e
 * ```
 */
public class TableExport internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.TableExport,
) : KotlinCustomResource(javaResource, TableExportMapper) {
    /**
     * ARN of the Table Export.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Billable size of the table export.
     */
    public val billedSizeInBytes: Output<Int>
        get() = javaResource.billedSizeInBytes().applyValue({ args0 -> args0 })

    /**
     * Time at which the export task completed.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * Format for the exported data. Valid values are `DYNAMODB_JSON` or `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
     */
    public val exportFormat: Output<String>?
        get() = javaResource.exportFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Status of the export - export can be in one of the following states `IN_PROGRESS`, `COMPLETED`, or `FAILED`.
     */
    public val exportStatus: Output<String>
        get() = javaResource.exportStatus().applyValue({ args0 -> args0 })

    /**
     * Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
     */
    public val exportTime: Output<String>
        get() = javaResource.exportTime().applyValue({ args0 -> args0 })

    /**
     * Number of items exported.
     */
    public val itemCount: Output<Int>
        get() = javaResource.itemCount().applyValue({ args0 -> args0 })

    /**
     * Name of the manifest file for the export task. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Manifest) for more information on this manifest file.
     */
    public val manifestFilesS3Key: Output<String>
        get() = javaResource.manifestFilesS3Key().applyValue({ args0 -> args0 })

    /**
     * Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
     */
    public val s3Bucket: Output<String>
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0 })

    /**
     * ID of the AWS account that owns the bucket the export will be stored in.
     */
    public val s3BucketOwner: Output<String>
        get() = javaResource.s3BucketOwner().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    public val s3Prefix: Output<String>
        get() = javaResource.s3Prefix().applyValue({ args0 -> args0 })

    /**
     * Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
     */
    public val s3SseAlgorithm: Output<String>
        get() = javaResource.s3SseAlgorithm().applyValue({ args0 -> args0 })

    /**
     * ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
     */
    public val s3SseKmsKeyId: Output<String>?
        get() = javaResource.s3SseKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time at which the export task began.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * ARN associated with the table to export.
     * The following arguments are optional:
     */
    public val tableArn: Output<String>
        get() = javaResource.tableArn().applyValue({ args0 -> args0 })
}

public object TableExportMapper : ResourceMapper<TableExport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.TableExport::class == javaResource::class

    override fun map(javaResource: Resource): TableExport = TableExport(
        javaResource as
            com.pulumi.aws.dynamodb.TableExport,
    )
}

/**
 * @see [TableExport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TableExport].
 */
public suspend fun tableExport(name: String, block: suspend TableExportResourceBuilder.() -> Unit): TableExport {
    val builder = TableExportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TableExport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tableExport(name: String): TableExport {
    val builder = TableExportResourceBuilder()
    builder.name(name)
    return builder.build()
}
