@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.TableExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucketPrefix: "example",
 *     forceDestroy: true,
 * });
 * const exampleTable = new aws.dynamodb.Table("example", {
 *     name: "example-table-1",
 *     billingMode: "PAY_PER_REQUEST",
 *     hashKey: "user_id",
 *     attributes: [{
 *         name: "user_id",
 *         type: "S",
 *     }],
 *     pointInTimeRecovery: {
 *         enabled: true,
 *     },
 * });
 * const exampleTableExport = new aws.dynamodb.TableExport("example", {
 *     tableArn: exampleTable.arn,
 *     s3Bucket: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket_prefix="example",
 *     force_destroy=True)
 * example_table = aws.dynamodb.Table("example",
 *     name="example-table-1",
 *     billing_mode="PAY_PER_REQUEST",
 *     hash_key="user_id",
 *     attributes=[{
 *         "name": "user_id",
 *         "type": "S",
 *     }],
 *     point_in_time_recovery={
 *         "enabled": True,
 *     })
 * example_table_export = aws.dynamodb.TableExport("example",
 *     table_arn=example_table.arn,
 *     s3_bucket=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         BucketPrefix = "example",
 *         ForceDestroy = true,
 *     });
 *     var exampleTable = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Name = "example-table-1",
 *         BillingMode = "PAY_PER_REQUEST",
 *         HashKey = "user_id",
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "user_id",
 *                 Type = "S",
 *             },
 *         },
 *         PointInTimeRecovery = new Aws.DynamoDB.Inputs.TablePointInTimeRecoveryArgs
 *         {
 *             Enabled = true,
 *         },
 *     });
 *     var exampleTableExport = new Aws.DynamoDB.TableExport("example", new()
 *     {
 *         TableArn = exampleTable.Arn,
 *         S3Bucket = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			BucketPrefix: pulumi.String("example"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTable, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Name:        pulumi.String("example-table-1"),
 * 			BillingMode: pulumi.String("PAY_PER_REQUEST"),
 * 			HashKey:     pulumi.String("user_id"),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("user_id"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 			PointInTimeRecovery: &dynamodb.TablePointInTimeRecoveryArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewTableExport(ctx, "example", &dynamodb.TableExportArgs{
 * 			TableArn: exampleTable.Arn,
 * 			S3Bucket: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs;
 * import com.pulumi.aws.dynamodb.TableExport;
 * import com.pulumi.aws.dynamodb.TableExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucketPrefix("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .name("example-table-1")
 *             .billingMode("PAY_PER_REQUEST")
 *             .hashKey("user_id")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("user_id")
 *                 .type("S")
 *                 .build())
 *             .pointInTimeRecovery(TablePointInTimeRecoveryArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *         var exampleTableExport = new TableExport("exampleTableExport", TableExportArgs.builder()
 *             .tableArn(exampleTable.arn())
 *             .s3Bucket(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucketPrefix: example
 *       forceDestroy: true
 *   exampleTable:
 *     type: aws:dynamodb:Table
 *     name: example
 *     properties:
 *       name: example-table-1
 *       billingMode: PAY_PER_REQUEST
 *       hashKey: user_id
 *       attributes:
 *         - name: user_id
 *           type: S
 *       pointInTimeRecovery:
 *         enabled: true
 *   exampleTableExport:
 *     type: aws:dynamodb:TableExport
 *     name: example
 *     properties:
 *       tableArn: ${exampleTable.arn}
 *       s3Bucket: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with export time
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dynamodb.TableExport("example", {
 *     exportTime: "2023-04-02T11:30:13+01:00",
 *     s3Bucket: exampleAwsS3Bucket.id,
 *     tableArn: exampleAwsDynamodbTable.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dynamodb.TableExport("example",
 *     export_time="2023-04-02T11:30:13+01:00",
 *     s3_bucket=example_aws_s3_bucket["id"],
 *     table_arn=example_aws_dynamodb_table["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DynamoDB.TableExport("example", new()
 *     {
 *         ExportTime = "2023-04-02T11:30:13+01:00",
 *         S3Bucket = exampleAwsS3Bucket.Id,
 *         TableArn = exampleAwsDynamodbTable.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamodb.NewTableExport(ctx, "example", &dynamodb.TableExportArgs{
 * 			ExportTime: pulumi.String("2023-04-02T11:30:13+01:00"),
 * 			S3Bucket:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 			TableArn:   pulumi.Any(exampleAwsDynamodbTable.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.TableExport;
 * import com.pulumi.aws.dynamodb.TableExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TableExport("example", TableExportArgs.builder()
 *             .exportTime("2023-04-02T11:30:13+01:00")
 *             .s3Bucket(exampleAwsS3Bucket.id())
 *             .tableArn(exampleAwsDynamodbTable.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dynamodb:TableExport
 *     properties:
 *       exportTime: 2023-04-02T11:30:13+01:00
 *       s3Bucket: ${exampleAwsS3Bucket.id}
 *       tableArn: ${exampleAwsDynamodbTable.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DynamoDB table exports using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:dynamodb/tableExport:TableExport example arn:aws:dynamodb:us-west-2:12345678911:table/my-table-1/export/01580735656614-2c2f422e
 * ```
 * @property exportFormat Format for the exported data. Valid values are `DYNAMODB_JSON` or `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
 * @property exportTime Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
 * @property s3Bucket Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
 * @property s3BucketOwner ID of the AWS account that owns the bucket the export will be stored in.
 * @property s3Prefix Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
 * @property s3SseAlgorithm Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
 * @property s3SseKmsKeyId ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
 * @property tableArn ARN associated with the table to export.
 * The following arguments are optional:
 */
public data class TableExportArgs(
    public val exportFormat: Output<String>? = null,
    public val exportTime: Output<String>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3BucketOwner: Output<String>? = null,
    public val s3Prefix: Output<String>? = null,
    public val s3SseAlgorithm: Output<String>? = null,
    public val s3SseKmsKeyId: Output<String>? = null,
    public val tableArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.TableExportArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.TableExportArgs =
        com.pulumi.aws.dynamodb.TableExportArgs.builder()
            .exportFormat(exportFormat?.applyValue({ args0 -> args0 }))
            .exportTime(exportTime?.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3BucketOwner(s3BucketOwner?.applyValue({ args0 -> args0 }))
            .s3Prefix(s3Prefix?.applyValue({ args0 -> args0 }))
            .s3SseAlgorithm(s3SseAlgorithm?.applyValue({ args0 -> args0 }))
            .s3SseKmsKeyId(s3SseKmsKeyId?.applyValue({ args0 -> args0 }))
            .tableArn(tableArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableExportArgs].
 */
@PulumiTagMarker
public class TableExportArgsBuilder internal constructor() {
    private var exportFormat: Output<String>? = null

    private var exportTime: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    private var s3BucketOwner: Output<String>? = null

    private var s3Prefix: Output<String>? = null

    private var s3SseAlgorithm: Output<String>? = null

    private var s3SseKmsKeyId: Output<String>? = null

    private var tableArn: Output<String>? = null

    /**
     * @param value Format for the exported data. Valid values are `DYNAMODB_JSON` or `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
     */
    @JvmName("bkiggixmvlogxgog")
    public suspend fun exportFormat(`value`: Output<String>) {
        this.exportFormat = value
    }

    /**
     * @param value Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
     */
    @JvmName("fedeqrspohdcuivi")
    public suspend fun exportTime(`value`: Output<String>) {
        this.exportTime = value
    }

    /**
     * @param value Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
     */
    @JvmName("jghxeecnvjpxpnyl")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value ID of the AWS account that owns the bucket the export will be stored in.
     */
    @JvmName("qvrvmhixdiuwkrce")
    public suspend fun s3BucketOwner(`value`: Output<String>) {
        this.s3BucketOwner = value
    }

    /**
     * @param value Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    @JvmName("rrixatoretfaapxj")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
     */
    @JvmName("glvlykowuswirkre")
    public suspend fun s3SseAlgorithm(`value`: Output<String>) {
        this.s3SseAlgorithm = value
    }

    /**
     * @param value ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
     */
    @JvmName("uusqmmdwalhwkutn")
    public suspend fun s3SseKmsKeyId(`value`: Output<String>) {
        this.s3SseKmsKeyId = value
    }

    /**
     * @param value ARN associated with the table to export.
     * The following arguments are optional:
     */
    @JvmName("pjdprgqofgoeqqlm")
    public suspend fun tableArn(`value`: Output<String>) {
        this.tableArn = value
    }

    /**
     * @param value Format for the exported data. Valid values are `DYNAMODB_JSON` or `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
     */
    @JvmName("qmnntnjejlehwejs")
    public suspend fun exportFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportFormat = mapped
    }

    /**
     * @param value Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
     */
    @JvmName("ftceijftfcwysoyi")
    public suspend fun exportTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportTime = mapped
    }

    /**
     * @param value Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
     */
    @JvmName("cbrxyeylhabdtisn")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value ID of the AWS account that owns the bucket the export will be stored in.
     */
    @JvmName("pinfqpebykdukxkj")
    public suspend fun s3BucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketOwner = mapped
    }

    /**
     * @param value Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    @JvmName("tsvexvvqqvhvqgpk")
    public suspend fun s3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    /**
     * @param value Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
     */
    @JvmName("cjkejjbnvkigwmqw")
    public suspend fun s3SseAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3SseAlgorithm = mapped
    }

    /**
     * @param value ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
     */
    @JvmName("ltbwiewogmmplwir")
    public suspend fun s3SseKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3SseKmsKeyId = mapped
    }

    /**
     * @param value ARN associated with the table to export.
     * The following arguments are optional:
     */
    @JvmName("wnfgfkuxpdwdkaxv")
    public suspend fun tableArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableArn = mapped
    }

    internal fun build(): TableExportArgs = TableExportArgs(
        exportFormat = exportFormat,
        exportTime = exportTime,
        s3Bucket = s3Bucket,
        s3BucketOwner = s3BucketOwner,
        s3Prefix = s3Prefix,
        s3SseAlgorithm = s3SseAlgorithm,
        s3SseKmsKeyId = s3SseKmsKeyId,
        tableArn = tableArn,
    )
}
