@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TableReplica].
 */
@PulumiTagMarker
public class TableReplicaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableReplicaArgs = TableReplicaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableReplicaArgsBuilder.() -> Unit) {
        val builder = TableReplicaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TableReplica {
        val builtJavaResource = com.pulumi.aws.dynamodb.TableReplica(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TableReplica(builtJavaResource)
    }
}

/**
 * Provides a DynamoDB table replica resource for [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html).
 * > **Note:** Use `lifecycle` `ignore_changes` for `replica` in the associated aws.dynamodb.Table configuration.
 * > **Note:** Do not use the `replica` configuration block of aws.dynamodb.Table together with this resource as the two configuration options are mutually exclusive.
 * ## Example Usage
 * ### Basic Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dynamodb.Table("example", {
 *     name: "TestTable",
 *     hashKey: "BrodoBaggins",
 *     billingMode: "PAY_PER_REQUEST",
 *     streamEnabled: true,
 *     streamViewType: "NEW_AND_OLD_IMAGES",
 *     attributes: [{
 *         name: "BrodoBaggins",
 *         type: "S",
 *     }],
 * });
 * const exampleTableReplica = new aws.dynamodb.TableReplica("example", {
 *     globalTableArn: example.arn,
 *     tags: {
 *         Name: "IZPAWS",
 *         Pozo: "Amargo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dynamodb.Table("example",
 *     name="TestTable",
 *     hash_key="BrodoBaggins",
 *     billing_mode="PAY_PER_REQUEST",
 *     stream_enabled=True,
 *     stream_view_type="NEW_AND_OLD_IMAGES",
 *     attributes=[{
 *         "name": "BrodoBaggins",
 *         "type": "S",
 *     }])
 * example_table_replica = aws.dynamodb.TableReplica("example",
 *     global_table_arn=example.arn,
 *     tags={
 *         "Name": "IZPAWS",
 *         "Pozo": "Amargo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Name = "TestTable",
 *         HashKey = "BrodoBaggins",
 *         BillingMode = "PAY_PER_REQUEST",
 *         StreamEnabled = true,
 *         StreamViewType = "NEW_AND_OLD_IMAGES",
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "BrodoBaggins",
 *                 Type = "S",
 *             },
 *         },
 *     });
 *     var exampleTableReplica = new Aws.DynamoDB.TableReplica("example", new()
 *     {
 *         GlobalTableArn = example.Arn,
 *         Tags =
 *         {
 *             { "Name", "IZPAWS" },
 *             { "Pozo", "Amargo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Name:           pulumi.String("TestTable"),
 * 			HashKey:        pulumi.String("BrodoBaggins"),
 * 			BillingMode:    pulumi.String("PAY_PER_REQUEST"),
 * 			StreamEnabled:  pulumi.Bool(true),
 * 			StreamViewType: pulumi.String("NEW_AND_OLD_IMAGES"),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("BrodoBaggins"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewTableReplica(ctx, "example", &dynamodb.TableReplicaArgs{
 * 			GlobalTableArn: example.Arn,
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("IZPAWS"),
 * 				"Pozo": pulumi.String("Amargo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.TableReplica;
 * import com.pulumi.aws.dynamodb.TableReplicaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .name("TestTable")
 *             .hashKey("BrodoBaggins")
 *             .billingMode("PAY_PER_REQUEST")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("BrodoBaggins")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var exampleTableReplica = new TableReplica("exampleTableReplica", TableReplicaArgs.builder()
 *             .globalTableArn(example.arn())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "IZPAWS"),
 *                 Map.entry("Pozo", "Amargo")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dynamodb:Table
 *     properties:
 *       name: TestTable
 *       hashKey: BrodoBaggins
 *       billingMode: PAY_PER_REQUEST
 *       streamEnabled: true
 *       streamViewType: NEW_AND_OLD_IMAGES
 *       attributes:
 *         - name: BrodoBaggins
 *           type: S
 *   exampleTableReplica:
 *     type: aws:dynamodb:TableReplica
 *     name: example
 *     properties:
 *       globalTableArn: ${example.arn}
 *       tags:
 *         Name: IZPAWS
 *         Pozo: Amargo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DynamoDB table replicas using the `table-name:main-region`. For example:
 * ~> __Note:__ When importing, use the region where the initial or _main_ global table resides, _not_ the region of the replica.
 * ```sh
 * $ pulumi import aws:dynamodb/tableReplica:TableReplica example TestTable:us-west-2
 * ```
 */
public class TableReplica internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.TableReplica,
) : KotlinCustomResource(javaResource, TableReplicaMapper) {
    /**
     * ARN of the table replica.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the _main_ or global table which this resource will replicate.
     * Optional arguments:
     */
    public val globalTableArn: Output<String>
        get() = javaResource.globalTableArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Whether to enable Point In Time Recovery for the replica. Default is `false`.
     */
    public val pointInTimeRecovery: Output<Boolean>?
        get() = javaResource.pointInTimeRecovery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
     */
    public val tableClassOverride: Output<String>?
        get() = javaResource.tableClassOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TableReplicaMapper : ResourceMapper<TableReplica> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.TableReplica::class == javaResource::class

    override fun map(javaResource: Resource): TableReplica = TableReplica(
        javaResource as
            com.pulumi.aws.dynamodb.TableReplica,
    )
}

/**
 * @see [TableReplica].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TableReplica].
 */
public suspend fun tableReplica(
    name: String,
    block: suspend TableReplicaResourceBuilder.() -> Unit,
): TableReplica {
    val builder = TableReplicaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TableReplica].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tableReplica(name: String): TableReplica {
    val builder = TableReplicaResourceBuilder()
    builder.name(name)
    return builder.build()
}
