@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Tag].
 */
@PulumiTagMarker
public class TagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagArgs = TagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagArgsBuilder.() -> Unit) {
        val builder = TagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Tag {
        val builtJavaResource = com.pulumi.aws.dynamodb.Tag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tag(builtJavaResource)
    }
}

/**
 * Manages an individual DynamoDB resource tag. This resource should only be used in cases where DynamoDB resources are created outside the provider (e.g., Table replicas in other regions).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.dynamodb.Table` and `aws.dynamodb.Tag` to manage tags of the same DynamoDB Table in the same region will cause a perpetual difference where the `aws_dynamodb_cluster` resource will try to remove the tag being added by the `aws.dynamodb.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const replica = aws.getRegion({});
 * const current = aws.getRegion({});
 * const example = new aws.dynamodb.Table("example", {replicas: [{
 *     regionName: replica.then(replica => replica.name),
 * }]});
 * const test = new aws.dynamodb.Tag("test", {
 *     resourceArn: pulumi.all([example&#46;arn, current, replica])&#46;apply(([arn, current, replica]) => std.replaceOutput({
 *         text: arn,
 *         search: current.name,
 *         replace: replica.name,
 *     })).apply(invoke => invoke.result),
 *     key: "testkey",
 *     value: "testvalue",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * replica = aws.get_region()
 * current = aws.get_region()
 * example = aws.dynamodb.Table("example", replicas=[{
 *     "region_name": replica.name,
 * }])
 * test = aws.dynamodb.Tag("test",
 *     resource_arn=example.arn.apply(lambda arn: std.replace_output(text=arn,
 *         search=current.name,
 *         replace=replica.name)).apply(lambda invoke: invoke.result),
 *     key="testkey",
 *     value="testvalue")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replica = Aws.GetRegion.Invoke();
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Replicas = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableReplicaArgs
 *             {
 *                 RegionName = replica.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var test = new Aws.DynamoDB.Tag("test", new()
 *     {
 *         ResourceArn = Output.Tuple(example.Arn, current, replica).Apply(values =>
 *         {
 *             var arn = values.Item1;
 *             var current = values.Item2;
 *             var replica = values.Item3;
 *             return Std.Replace.Invoke(new()
 *             {
 *                 Text = arn,
 *                 Search = current.Apply(getRegionResult => getRegionResult.Name),
 *                 Replace = replica.Apply(getRegionResult => getRegionResult.Name),
 *             });
 *         }).Apply(invoke => invoke.Result),
 *         Key = "testkey",
 *         Value = "testvalue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		replica, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Replicas: dynamodb.TableReplicaTypeArray{
 * 				&dynamodb.TableReplicaTypeArgs{
 * 					RegionName: pulumi.String(replica.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dynamodb.NewTag(ctx, "test", &dynamodb.TagArgs{
 * 			ResourceArn: pulumi.String(example.Arn.ApplyT(func(arn string) (std.ReplaceResult, error) {
 * 				return std.ReplaceResult(interface{}(std.ReplaceOutput(ctx, std.ReplaceOutputArgs{
 * 					Text:    arn,
 * 					Search:  current.Name,
 * 					Replace: replica.Name,
 * 				}, nil))), nil
 * 			}).(std.ReplaceResultOutput).ApplyT(func(invoke std.ReplaceResult) (*string, error) {
 * 				return invoke.Result, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			Key:   pulumi.String("testkey"),
 * 			Value: pulumi.String("testvalue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableReplicaArgs;
 * import com.pulumi.aws.dynamodb.Tag;
 * import com.pulumi.aws.dynamodb.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var replica = AwsFunctions.getRegion();
 *         final var current = AwsFunctions.getRegion();
 *         var example = new Table("example", TableArgs.builder()
 *             .replicas(TableReplicaArgs.builder()
 *                 .regionName(replica.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var test = new Tag("test", TagArgs.builder()
 *             .resourceArn(example.arn().applyValue(arn -> StdFunctions.replace()).applyValue(invoke -> invoke.result()))
 *             .key("testkey")
 *             .value("testvalue")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dynamodb:Table
 *     properties:
 *       replicas:
 *         - regionName: ${replica.name}
 *   test:
 *     type: aws:dynamodb:Tag
 *     properties:
 *       resourceArn:
 *         fn::invoke:
 *           Function: std:replace
 *           Arguments:
 *             text: ${example.arn}
 *             search: ${current.name}
 *             replace: ${replica.name}
 *           Return: result
 *       key: testkey
 *       value: testvalue
 * variables:
 *   replica:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_dynamodb_tag` using the DynamoDB resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:dynamodb/tag:Tag example arn:aws:dynamodb:us-east-1:123456789012:table/example,Name
 * ```
 */
public class Tag internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.Tag,
) : KotlinCustomResource(javaResource, TagMapper) {
    /**
     * Tag name.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the DynamoDB resource to tag.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Tag value.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object TagMapper : ResourceMapper<Tag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.Tag::class == javaResource::class

    override fun map(javaResource: Resource): Tag = Tag(javaResource as com.pulumi.aws.dynamodb.Tag)
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tag].
 */
public suspend fun tag(name: String, block: suspend TagResourceBuilder.() -> Unit): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tag(name: String): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    return builder.build()
}
