@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.GetTableItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTableItem.
 * @property expressionAttributeNames
 * @property key A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
 * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
 * The following arguments are optional:
 * @property projectionExpression A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
 * If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.
 * @property tableName The name of the table containing the requested item.
 */
public data class GetTableItemPlainArgs(
    public val expressionAttributeNames: Map<String, String>? = null,
    public val key: String,
    public val projectionExpression: String? = null,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.GetTableItemPlainArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.GetTableItemPlainArgs =
        com.pulumi.aws.dynamodb.inputs.GetTableItemPlainArgs.builder()
            .expressionAttributeNames(
                expressionAttributeNames?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .key(key.let({ args0 -> args0 }))
            .projectionExpression(projectionExpression?.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTableItemPlainArgs].
 */
@PulumiTagMarker
public class GetTableItemPlainArgsBuilder internal constructor() {
    private var expressionAttributeNames: Map<String, String>? = null

    private var key: String? = null

    private var projectionExpression: String? = null

    private var tableName: String? = null

    /**
     * @param value
     */
    @JvmName("kogkgtuyvyoxaodr")
    public suspend fun expressionAttributeNames(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expressionAttributeNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("rhvpriqmyyqxicrr")
    public fun expressionAttributeNames(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressionAttributeNames = mapped
    }

    /**
     * @param value A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
     * The following arguments are optional:
     */
    @JvmName("vwobrfvvdcbscoiv")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     * If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.
     */
    @JvmName("ntiekxljoxcfmtey")
    public suspend fun projectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.projectionExpression = mapped
    }

    /**
     * @param value The name of the table containing the requested item.
     */
    @JvmName("nuncefhdpihlruvr")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetTableItemPlainArgs = GetTableItemPlainArgs(
        expressionAttributeNames = expressionAttributeNames,
        key = key ?: throw PulumiNullFieldException("key"),
        projectionExpression = projectionExpression,
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
