@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.GetTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTable.
 * @property name Name of the DynamoDB table.
 * @property serverSideEncryption
 * @property tags
 */
public data class GetTablePlainArgs(
    public val name: String,
    public val serverSideEncryption: GetTableServerSideEncryption? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.GetTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.GetTablePlainArgs =
        com.pulumi.aws.dynamodb.inputs.GetTablePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .serverSideEncryption(serverSideEncryption?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetTablePlainArgs].
 */
@PulumiTagMarker
public class GetTablePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var serverSideEncryption: GetTableServerSideEncryption? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the DynamoDB table.
     */
    @JvmName("rjdkgtxjhrqacpgg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("kcmbdbwgxxpupawc")
    public suspend fun serverSideEncryption(`value`: GetTableServerSideEncryption?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverSideEncryption = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sreofeteagmbtmyv")
    public suspend fun serverSideEncryption(argument: suspend GetTableServerSideEncryptionBuilder.() -> Unit) {
        val toBeMapped = GetTableServerSideEncryptionBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.serverSideEncryption = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqmcqcyqfyvqgoyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fnjaquhxgiwxfitk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetTablePlainArgs = GetTablePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        serverSideEncryption = serverSideEncryption,
        tags = tags,
    )
}
