@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the attribute
 * @property type Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
 */
public data class TableAttributeArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableAttributeArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableAttributeArgs =
        com.pulumi.aws.dynamodb.inputs.TableAttributeArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableAttributeArgs].
 */
@PulumiTagMarker
public class TableAttributeArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the attribute
     */
    @JvmName("tedrykaxxkkmojgp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
     */
    @JvmName("ipqbabfuslskdumy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the attribute
     */
    @JvmName("hycflxntpohhchbn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
     */
    @JvmName("dywoekaphfrsvoyf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TableAttributeArgs = TableAttributeArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
