@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableGlobalSecondaryIndexArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hashKey Name of the hash key in the index; must be defined as an attribute in the resource.
 * @property name Name of the index.
 * @property nonKeyAttributes Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
 * @property projectionType One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
 * @property rangeKey Name of the range key; must be defined
 * @property readCapacity Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
 * @property writeCapacity Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
 */
public data class TableGlobalSecondaryIndexArgs(
    public val hashKey: Output<String>,
    public val name: Output<String>,
    public val nonKeyAttributes: Output<List<String>>? = null,
    public val projectionType: Output<String>,
    public val rangeKey: Output<String>? = null,
    public val readCapacity: Output<Int>? = null,
    public val writeCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableGlobalSecondaryIndexArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableGlobalSecondaryIndexArgs =
        com.pulumi.aws.dynamodb.inputs.TableGlobalSecondaryIndexArgs.builder()
            .hashKey(hashKey.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .nonKeyAttributes(nonKeyAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .projectionType(projectionType.applyValue({ args0 -> args0 }))
            .rangeKey(rangeKey?.applyValue({ args0 -> args0 }))
            .readCapacity(readCapacity?.applyValue({ args0 -> args0 }))
            .writeCapacity(writeCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableGlobalSecondaryIndexArgs].
 */
@PulumiTagMarker
public class TableGlobalSecondaryIndexArgsBuilder internal constructor() {
    private var hashKey: Output<String>? = null

    private var name: Output<String>? = null

    private var nonKeyAttributes: Output<List<String>>? = null

    private var projectionType: Output<String>? = null

    private var rangeKey: Output<String>? = null

    private var readCapacity: Output<Int>? = null

    private var writeCapacity: Output<Int>? = null

    /**
     * @param value Name of the hash key in the index; must be defined as an attribute in the resource.
     */
    @JvmName("pyylsipfpgfvgcox")
    public suspend fun hashKey(`value`: Output<String>) {
        this.hashKey = value
    }

    /**
     * @param value Name of the index.
     */
    @JvmName("tfenaqbeokpyggkq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("vjxjdstftopquvnh")
    public suspend fun nonKeyAttributes(`value`: Output<List<String>>) {
        this.nonKeyAttributes = value
    }

    @JvmName("oymmgybbsgwuvkop")
    public suspend fun nonKeyAttributes(vararg values: Output<String>) {
        this.nonKeyAttributes = Output.all(values.asList())
    }

    /**
     * @param values Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("friamyrmgmvkuwll")
    public suspend fun nonKeyAttributes(values: List<Output<String>>) {
        this.nonKeyAttributes = Output.all(values)
    }

    /**
     * @param value One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
     */
    @JvmName("uppjcpgobwilwcoe")
    public suspend fun projectionType(`value`: Output<String>) {
        this.projectionType = value
    }

    /**
     * @param value Name of the range key; must be defined
     */
    @JvmName("lbxcpqojvbwndmuh")
    public suspend fun rangeKey(`value`: Output<String>) {
        this.rangeKey = value
    }

    /**
     * @param value Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
     */
    @JvmName("lcodqamirkhfaioc")
    public suspend fun readCapacity(`value`: Output<Int>) {
        this.readCapacity = value
    }

    /**
     * @param value Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
     */
    @JvmName("ppsrasyuscstogas")
    public suspend fun writeCapacity(`value`: Output<Int>) {
        this.writeCapacity = value
    }

    /**
     * @param value Name of the hash key in the index; must be defined as an attribute in the resource.
     */
    @JvmName("toqrrfxdxqsdqvug")
    public suspend fun hashKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hashKey = mapped
    }

    /**
     * @param value Name of the index.
     */
    @JvmName("gjgdebpswhynrnxk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("oksajjosbnlqnwek")
    public suspend fun nonKeyAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonKeyAttributes = mapped
    }

    /**
     * @param values Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("hkfjebqjgfkfcetw")
    public suspend fun nonKeyAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonKeyAttributes = mapped
    }

    /**
     * @param value One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
     */
    @JvmName("oycyqmwjvhyqrluw")
    public suspend fun projectionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectionType = mapped
    }

    /**
     * @param value Name of the range key; must be defined
     */
    @JvmName("ogglaboxxwntqjap")
    public suspend fun rangeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeKey = mapped
    }

    /**
     * @param value Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
     */
    @JvmName("pshtglxsbsovgjhe")
    public suspend fun readCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readCapacity = mapped
    }

    /**
     * @param value Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
     */
    @JvmName("uubrrnqcxuwsqfse")
    public suspend fun writeCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeCapacity = mapped
    }

    internal fun build(): TableGlobalSecondaryIndexArgs = TableGlobalSecondaryIndexArgs(
        hashKey = hashKey ?: throw PulumiNullFieldException("hashKey"),
        name = name ?: throw PulumiNullFieldException("name"),
        nonKeyAttributes = nonKeyAttributes,
        projectionType = projectionType ?: throw PulumiNullFieldException("projectionType"),
        rangeKey = rangeKey,
        readCapacity = readCapacity,
        writeCapacity = writeCapacity,
    )
}
