@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableImportTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property inputCompressionType Type of compression to be used on the input coming from the imported table.
 * Valid values are `GZIP`, `ZSTD` and `NONE`.
 * @property inputFormat The format of the source data.
 * Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
 * @property inputFormatOptions Describe the format options for the data that was imported into the target table.
 * There is one value, `csv`.
 * See below.
 * @property s3BucketSource Values for the S3 bucket the source file is imported from.
 * See below.
 */
public data class TableImportTableArgs(
    public val inputCompressionType: Output<String>? = null,
    public val inputFormat: Output<String>,
    public val inputFormatOptions: Output<TableImportTableInputFormatOptionsArgs>? = null,
    public val s3BucketSource: Output<TableImportTableS3BucketSourceArgs>,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableImportTableArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableImportTableArgs =
        com.pulumi.aws.dynamodb.inputs.TableImportTableArgs.builder()
            .inputCompressionType(inputCompressionType?.applyValue({ args0 -> args0 }))
            .inputFormat(inputFormat.applyValue({ args0 -> args0 }))
            .inputFormatOptions(
                inputFormatOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3BucketSource(
                s3BucketSource.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TableImportTableArgs].
 */
@PulumiTagMarker
public class TableImportTableArgsBuilder internal constructor() {
    private var inputCompressionType: Output<String>? = null

    private var inputFormat: Output<String>? = null

    private var inputFormatOptions: Output<TableImportTableInputFormatOptionsArgs>? = null

    private var s3BucketSource: Output<TableImportTableS3BucketSourceArgs>? = null

    /**
     * @param value Type of compression to be used on the input coming from the imported table.
     * Valid values are `GZIP`, `ZSTD` and `NONE`.
     */
    @JvmName("jresvyevanixpafw")
    public suspend fun inputCompressionType(`value`: Output<String>) {
        this.inputCompressionType = value
    }

    /**
     * @param value The format of the source data.
     * Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
     */
    @JvmName("pokbhfdwmdoerfqt")
    public suspend fun inputFormat(`value`: Output<String>) {
        this.inputFormat = value
    }

    /**
     * @param value Describe the format options for the data that was imported into the target table.
     * There is one value, `csv`.
     * See below.
     */
    @JvmName("ubtlghurcmrldhcs")
    public suspend fun inputFormatOptions(`value`: Output<TableImportTableInputFormatOptionsArgs>) {
        this.inputFormatOptions = value
    }

    /**
     * @param value Values for the S3 bucket the source file is imported from.
     * See below.
     */
    @JvmName("hpxiewwsrkqjnesr")
    public suspend fun s3BucketSource(`value`: Output<TableImportTableS3BucketSourceArgs>) {
        this.s3BucketSource = value
    }

    /**
     * @param value Type of compression to be used on the input coming from the imported table.
     * Valid values are `GZIP`, `ZSTD` and `NONE`.
     */
    @JvmName("lqmotjpesbngrykf")
    public suspend fun inputCompressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputCompressionType = mapped
    }

    /**
     * @param value The format of the source data.
     * Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
     */
    @JvmName("uoldrdosntkchwco")
    public suspend fun inputFormat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputFormat = mapped
    }

    /**
     * @param value Describe the format options for the data that was imported into the target table.
     * There is one value, `csv`.
     * See below.
     */
    @JvmName("vlheknyfjjnihdht")
    public suspend fun inputFormatOptions(`value`: TableImportTableInputFormatOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFormatOptions = mapped
    }

    /**
     * @param argument Describe the format options for the data that was imported into the target table.
     * There is one value, `csv`.
     * See below.
     */
    @JvmName("uuiioydcgldwbnrr")
    public suspend fun inputFormatOptions(argument: suspend TableImportTableInputFormatOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TableImportTableInputFormatOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputFormatOptions = mapped
    }

    /**
     * @param value Values for the S3 bucket the source file is imported from.
     * See below.
     */
    @JvmName("gtrosibqbkdytwft")
    public suspend fun s3BucketSource(`value`: TableImportTableS3BucketSourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketSource = mapped
    }

    /**
     * @param argument Values for the S3 bucket the source file is imported from.
     * See below.
     */
    @JvmName("totibccmxpcyqlgg")
    public suspend fun s3BucketSource(argument: suspend TableImportTableS3BucketSourceArgsBuilder.() -> Unit) {
        val toBeMapped = TableImportTableS3BucketSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3BucketSource = mapped
    }

    internal fun build(): TableImportTableArgs = TableImportTableArgs(
        inputCompressionType = inputCompressionType,
        inputFormat = inputFormat ?: throw PulumiNullFieldException("inputFormat"),
        inputFormatOptions = inputFormatOptions,
        s3BucketSource = s3BucketSource ?: throw PulumiNullFieldException("s3BucketSource"),
    )
}
