@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableTtlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attributeName Name of the table attribute to store the TTL timestamp in.
 * Required if `enabled` is `true`, must not be set otherwise.
 * @property enabled Whether TTL is enabled.
 * Default value is `false`.
 */
public data class TableTtlArgs(
    public val attributeName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableTtlArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableTtlArgs =
        com.pulumi.aws.dynamodb.inputs.TableTtlArgs.builder()
            .attributeName(attributeName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableTtlArgs].
 */
@PulumiTagMarker
public class TableTtlArgsBuilder internal constructor() {
    private var attributeName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Name of the table attribute to store the TTL timestamp in.
     * Required if `enabled` is `true`, must not be set otherwise.
     */
    @JvmName("onincmfdthrhqman")
    public suspend fun attributeName(`value`: Output<String>) {
        this.attributeName = value
    }

    /**
     * @param value Whether TTL is enabled.
     * Default value is `false`.
     */
    @JvmName("foouctknxgyjcmsg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the table attribute to store the TTL timestamp in.
     * Required if `enabled` is `true`, must not be set otherwise.
     */
    @JvmName("sdmuwbytselagqol")
    public suspend fun attributeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeName = mapped
    }

    /**
     * @param value Whether TTL is enabled.
     * Default value is `false`.
     */
    @JvmName("cyjstinrxgsxilit")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): TableTtlArgs = TableTtlArgs(
        attributeName = attributeName,
        enabled = enabled,
    )
}
