@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getTableItem.
 * @property expressionAttributeNames
 * @property id The provider-assigned unique ID for this managed resource.
 * @property item JSON representation of a map of attribute names to [AttributeValue](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_AttributeValue.html) objects, as specified by ProjectionExpression.
 * @property key
 * @property projectionExpression
 * @property tableName
 */
public data class GetTableItemResult(
    public val expressionAttributeNames: Map<String, String>? = null,
    public val id: String,
    public val item: String,
    public val key: String,
    public val projectionExpression: String? = null,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.GetTableItemResult): GetTableItemResult = GetTableItemResult(
            expressionAttributeNames = javaType.expressionAttributeNames().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            item = javaType.item(),
            key = javaType.key(),
            projectionExpression = javaType.projectionExpression().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
        )
    }
}
