@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the DynamoDB table.
 * @property nonKeyAttributes
 * @property projectionType
 * @property rangeKey
 */
public data class GetTableLocalSecondaryIndex(
    public val name: String,
    public val nonKeyAttributes: List<String>,
    public val projectionType: String,
    public val rangeKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.GetTableLocalSecondaryIndex): GetTableLocalSecondaryIndex = GetTableLocalSecondaryIndex(
            name = javaType.name(),
            nonKeyAttributes = javaType.nonKeyAttributes().map({ args0 -> args0 }),
            projectionType = javaType.projectionType(),
            rangeKey = javaType.rangeKey(),
        )
    }
}
