@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property inputCompressionType Type of compression to be used on the input coming from the imported table.
 * Valid values are `GZIP`, `ZSTD` and `NONE`.
 * @property inputFormat The format of the source data.
 * Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
 * @property inputFormatOptions Describe the format options for the data that was imported into the target table.
 * There is one value, `csv`.
 * See below.
 * @property s3BucketSource Values for the S3 bucket the source file is imported from.
 * See below.
 */
public data class TableImportTable(
    public val inputCompressionType: String? = null,
    public val inputFormat: String,
    public val inputFormatOptions: TableImportTableInputFormatOptions? = null,
    public val s3BucketSource: TableImportTableS3BucketSource,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableImportTable): TableImportTable = TableImportTable(
            inputCompressionType = javaType.inputCompressionType().map({ args0 -> args0 }).orElse(null),
            inputFormat = javaType.inputFormat(),
            inputFormatOptions = javaType.inputFormatOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dynamodb.kotlin.outputs.TableImportTableInputFormatOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3BucketSource = javaType.s3BucketSource().let({ args0 ->
                com.pulumi.aws.dynamodb.kotlin.outputs.TableImportTableS3BucketSource.Companion.toKotlin(args0)
            }),
        )
    }
}
