@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the index
 * @property nonKeyAttributes Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
 * @property projectionType One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
 * @property rangeKey Name of the range key.
 */
public data class TableLocalSecondaryIndex(
    public val name: String,
    public val nonKeyAttributes: List<String>? = null,
    public val projectionType: String,
    public val rangeKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableLocalSecondaryIndex): TableLocalSecondaryIndex = TableLocalSecondaryIndex(
            name = javaType.name(),
            nonKeyAttributes = javaType.nonKeyAttributes().map({ args0 -> args0 }),
            projectionType = javaType.projectionType(),
            rangeKey = javaType.rangeKey(),
        )
    }
}
