@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributeName Name of the table attribute to store the TTL timestamp in.
 * Required if `enabled` is `true`, must not be set otherwise.
 * @property enabled Whether TTL is enabled.
 * Default value is `false`.
 */
public data class TableTtl(
    public val attributeName: String? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableTtl): TableTtl = TableTtl(
            attributeName = javaType.attributeName().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
